/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsstorage.craftinggrid.CraftingGrid;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.RFCraftingRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketGridSync(BlockPos pos, ResourceKey<Level> type, List<Recipe> recipes) {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketGridSync> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), s -> Optional.ofNullable(s.pos), (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION).apply(ByteBufCodecs::optional), s -> Optional.ofNullable(s.type), (StreamCodec)Recipe.STREAM_CODEC.apply(ByteBufCodecs.list()), PacketGridSync::recipes, (pos, type, recipes) -> new PacketGridSync((BlockPos)pos.orElse(null), (ResourceKey<Level>)((ResourceKey)type.orElse(null)), (List<Recipe>)recipes));

    public PacketGridSync(BlockPos pos, ResourceKey<Level> type, CraftingGrid grid) {
        this(pos, type, PacketGridSync.getRecipes(grid));
    }

    private static List<Recipe> getRecipes(CraftingGrid grid) {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (int i = 0; i < 6; ++i) {
            RFCraftingRecipe recipe = grid.getRecipe(i);
            List<ItemStack> inventory = recipe.getInventory();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            stacks.add(recipe.getResult());
            for (int j = 0; j < 9; ++j) {
                stacks.add(inventory.get(j));
            }
            recipes.add(new Recipe(stacks));
        }
        return recipes;
    }

    public CraftingGridProvider handleMessage(Level world, Player player) {
        BlockEntity te;
        CraftingGridProvider provider = null;
        if (this.pos == null) {
            GenericContainer container = PacketGridSync.getOpenContainer();
            if (container == null) {
                Logging.log((String)"Container is missing!");
                return null;
            }
            te = container.getBe();
        } else {
            te = world.getBlockEntity(this.pos);
        }
        if (te instanceof CraftingGridProvider) {
            provider = (CraftingGridProvider)te;
        }
        if (provider != null) {
            for (int i = 0; i < this.recipes.size(); ++i) {
                List<ItemStack> stacks = this.recipes.get(i).stacks();
                provider.setRecipe(i, stacks.toArray(new ItemStack[0]));
            }
        }
        return provider;
    }

    private static GenericContainer getOpenContainer() {
        AbstractContainerMenu container = SafeClientTools.getClientPlayer().containerMenu;
        if (container instanceof GenericContainer) {
            return (GenericContainer)container;
        }
        return null;
    }

    public record Recipe(List<ItemStack> stacks) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Recipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, Recipe::stacks, Recipe::new);
    }
}

