/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.skin.provider;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.mojang.authlib.properties.Property;
import it.unimi.dsi.fastutil.Pair;
import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.config.Config;
import net.lionarius.skinrestorer.config.provider.MineskinProviderConfig;
import net.lionarius.skinrestorer.mineskin.Java11RequestHandler;
import net.lionarius.skinrestorer.skin.SkinVariant;
import net.lionarius.skinrestorer.skin.provider.SkinProvider;
import net.lionarius.skinrestorer.util.JsonUtils;
import net.lionarius.skinrestorer.util.Result;
import net.lionarius.skinrestorer.util.WebUtils;
import org.jetbrains.annotations.NotNull;
import org.mineskin.MineSkinClient;
import org.mineskin.data.SkinInfo;
import org.mineskin.data.Variant;
import org.mineskin.data.Visibility;
import org.mineskin.request.GenerateRequest;
import org.mineskin.response.QueueResponse;

public final class MineskinSkinProvider
implements SkinProvider {
    public static final String PROVIDER_NAME = "web";
    private static MineSkinClient MINESKIN_CLIENT;
    private static LoadingCache<Pair<URI, SkinVariant>, Optional<Property>> SKIN_CACHE;

    public static void reload() {
        Config config = SkinRestorer.getConfig();
        String configApiKey = config.providersConfig().mineskin().apiKey();
        MINESKIN_CLIENT = MineSkinClient.builder().userAgent(WebUtils.USER_AGENT).gson(JsonUtils.GSON).timeout((int)Duration.ofSeconds(config.requestTimeout()).toMillis()).requestHandler((baseUrl, userAgent, apiKey, timeout, gson) -> new Java11RequestHandler(baseUrl, userAgent, apiKey, timeout, gson, SkinRestorer.getConfig().proxy().map(proxy -> new InetSocketAddress(proxy.host(), proxy.port())).orElse(null))).apiKey(configApiKey.isEmpty() ? null : configApiKey).build();
        MineskinSkinProvider.createCache();
    }

    private static void createCache() {
        MineskinProviderConfig config = SkinRestorer.getConfig().providersConfig().mineskin();
        long time = config.cache().enabled() ? config.cache().duration() : 0L;
        SKIN_CACHE = CacheBuilder.newBuilder().expireAfterWrite(time, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Pair<URI, SkinVariant>, Optional<Property>>(){

            @NotNull
            public Optional<Property> load(@NotNull Pair<URI, SkinVariant> key) throws Exception {
                return MineskinSkinProvider.loadSkin((URI)key.first(), (SkinVariant)((Object)key.second()));
            }
        });
    }

    @Override
    public String getArgumentName() {
        return "url";
    }

    @Override
    public boolean hasVariantSupport() {
        return true;
    }

    @Override
    public Result<Optional<Property>, Exception> fetchSkin(String url, SkinVariant variant) {
        try {
            URI uri = new URI(url);
            return Result.success((Optional)SKIN_CACHE.get((Object)Pair.of((Object)uri, (Object)((Object)variant))));
        }
        catch (UncheckedExecutionException e) {
            return Result.error((Exception)e.getCause());
        }
        catch (Exception e) {
            return Result.error(e);
        }
    }

    private static Optional<Property> loadSkin(URI uri, SkinVariant variant) throws Exception {
        Variant mineskinVariant = switch (variant) {
            default -> throw new MatchException(null, null);
            case SkinVariant.CLASSIC -> Variant.CLASSIC;
            case SkinVariant.SLIM -> Variant.SLIM;
        };
        GenerateRequest request = GenerateRequest.url((URI)uri).variant(mineskinVariant).name("skinrestorer-skin").visibility(Visibility.UNLISTED);
        SkinInfo skin = (SkinInfo)((CompletableFuture)((CompletableFuture)((CompletableFuture)MINESKIN_CLIENT.queue().submit(request).thenApply(QueueResponse::getJob)).thenCompose(jobInfo -> jobInfo.waitForCompletion(MINESKIN_CLIENT))).thenCompose(jobReference -> jobReference.getOrLoadSkin(MINESKIN_CLIENT))).join();
        return Optional.of(new Property("textures", skin.texture().data().value(), skin.texture().data().signature()));
    }
}

