/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.controllers;

import net.mehvahdjukaar.supplementaries.common.entities.ISpyglassMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.LookControl;

public class LookControlWithSpyglass<M extends Mob>
extends LookControl {
    private final M spyglassMob;
    private int useSpyglassDuration = 0;

    public LookControlWithSpyglass(M mob) {
        super(mob);
        this.spyglassMob = mob;
    }

    public void setLookAt(double x, double y, double z, float deltaYaw, float deltaPitch) {
        super.setLookAt(x, y, z, deltaYaw, deltaPitch);
        double dist = this.mob.distanceToSqr(x, y, z);
        double startUsingSpyglassDist = ((ISpyglassMob)this.spyglassMob).getStartUsingSpyglassDistance();
        boolean shouldUseSpyglass = dist >= startUsingSpyglassDist * startUsingSpyglassDist;
        ((ISpyglassMob)this.spyglassMob).setUsingSpyglass(shouldUseSpyglass);
        this.useSpyglassDuration = shouldUseSpyglass ? 10 : 0;
    }

    public void tick() {
        super.tick();
        if (this.useSpyglassDuration > 0) {
            --this.useSpyglassDuration;
            if (this.useSpyglassDuration == 0) {
                ((ISpyglassMob)this.spyglassMob).setUsingSpyglass(false);
            }
        }
    }
}

