/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.coroutil.util.CULog;
import com.corosus.watut.FakePlayerHelper;
import com.corosus.watut.InventorySnapshot;
import com.corosus.watut.PlayerStatus;
import com.corosus.watut.PlayerStatusManager;
import com.corosus.watut.WatutMod;
import com.corosus.watut.WatutNetworking;
import com.corosus.watut.config.ConfigCommon;
import com.corosus.watut.config.ConfigServerControlledSyncedToClient;
import com.corosus.watut.config.ConfigServerSyncHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PlayerStatusManagerServer
extends PlayerStatusManager {
    @Override
    public void tickPlayer(Player player) {
        this.getStatus(player).setTicksToMarkPlayerIdleSyncedForClient(ConfigCommon.ticksToMarkPlayerIdle);
        super.tickPlayer(player);
    }

    public void receiveAny(Player player, CompoundTag data) {
        data.putString(WatutNetworking.NBTDataPlayerUUID, player.getUUID().toString());
        if (data.contains(WatutNetworking.NBTDataPlayerGuiStatus)) {
            PlayerStatus.PlayerGuiState playerGuiState = PlayerStatus.PlayerGuiState.get(data.getInt(WatutNetworking.NBTDataPlayerGuiStatus));
            this.getStatus(player).setPlayerGuiState(playerGuiState);
        }
        if (data.contains(WatutNetworking.NBTDataPlayerChatStatus)) {
            PlayerStatus.PlayerChatState state = PlayerStatus.PlayerChatState.get(data.getInt(WatutNetworking.NBTDataPlayerChatStatus));
            this.getStatus(player).setPlayerChatState(state);
        }
        if (data.contains(WatutNetworking.NBTDataPlayerIdleTicks)) {
            this.handleIdleState(player, data.getInt(WatutNetworking.NBTDataPlayerIdleTicks));
            data.putInt(WatutNetworking.NBTDataPlayerTicksToGoIdle, ConfigCommon.ticksToMarkPlayerIdle);
        }
        if (data.contains(WatutNetworking.NBTDataPlayerMouseX)) {
            float x = data.getFloat(WatutNetworking.NBTDataPlayerMouseX);
            float y = data.getFloat(WatutNetworking.NBTDataPlayerMouseY);
            boolean pressed = data.getBoolean(WatutNetworking.NBTDataPlayerMousePressed);
            this.setMouse(player.getUUID(), x, y, pressed);
        }
        this.getStatus(player).getNbtCache().merge(data);
        if (data.contains(WatutNetworking.NBTDataPlayerScreenCompressedPixelData)) {
            // empty if block
        }
        if (data.contains(WatutNetworking.NBTDataPlayerGuiStatus) || data.contains(WatutNetworking.NBTDataPlayerIdleTicks) || data.contains(WatutNetworking.NBTDataPlayerChatStatus)) {
            WatutNetworking.instance().serverSendToClientAll(data);
        } else {
            WatutNetworking.instance().serverSendToClientNear(data, player.position(), ConfigServerControlledSyncedToClient.distanceRequiredToShowGUIInfo, player.level());
        }
    }

    public void handleIdleState(Player player, int idleTicks) {
        if (WatutMod.instance().getPlayerList() == null) {
            return;
        }
        PlayerStatus status = this.getStatus(player);
        if (WatutMod.instance().getPlayerList().getPlayerCount() > 1 || this.singleplayerTesting) {
            if (idleTicks > ConfigCommon.ticksToMarkPlayerIdle) {
                if (!status.isIdle()) {
                    this.broadcast(player.getDisplayName().getString() + " has gone idle");
                }
            } else if (status.isIdle()) {
                this.broadcast(player.getDisplayName().getString() + " is no longer idle");
            }
        }
        status.setTicksSinceLastAction(idleTicks);
    }

    public void broadcast(String msg) {
        if (WatutMod.instance().getPlayerList() == null) {
            return;
        }
        if (ConfigCommon.announceIdleStatesInChat) {
            WatutMod.instance().getPlayerList().broadcastSystemMessage((Component)Component.literal((String)msg), false);
        }
    }

    @Override
    public void playerLoggedIn(Player player) {
        super.playerLoggedIn(player);
        WatutMod.dbg("player logged in " + String.valueOf(player.getName()));
        if (player instanceof ServerPlayer) {
            for (Map.Entry entry : this.lookupPlayerToStatus.entrySet()) {
                WatutMod.dbg("sending update all packet for " + ((UUID)entry.getKey()).toString() + " to " + player.getDisplayName().getString() + " with status " + String.valueOf((Object)PlayerStatus.PlayerGuiState.get(((PlayerStatus)entry.getValue()).getNbtCache().getInt(WatutNetworking.NBTDataPlayerGuiStatus))));
                WatutNetworking.instance().serverSendToClientPlayer(((PlayerStatus)entry.getValue()).getNbtCache(), player);
            }
            CULog.dbg((String)("sending server config sync to " + String.valueOf(player.getName())));
            WatutNetworking.instance().serverSendToClientPlayer(this.getServerConfigNBT(), player);
        }
    }

    public void syncServerConfigToAllPlayers() {
        if (WatutMod.instance().getPlayerList() == null) {
            return;
        }
        for (ServerPlayer serverPlayer : WatutMod.instance().getPlayerList().getPlayers()) {
            CULog.dbg((String)("sending server config sync to " + String.valueOf(serverPlayer.getName())));
            WatutNetworking.instance().serverSendToClientPlayer(this.getServerConfigNBT(), (Player)serverPlayer);
        }
    }

    public CompoundTag getServerConfigNBT() {
        CompoundTag nbt = ConfigServerSyncHelper.getInstance().getSyncableConfigOnServer();
        nbt.putBoolean(WatutNetworking.NBTDataServerConfig, true);
        return nbt;
    }

    public void sendItemMove(Player player, Level level, ItemStack itemStack, double fromX, double fromY, double fromZ, double toX, double toY, double toZ) {
        this.sendItemMove(player, level, itemStack, (float)fromX, (float)fromY, (float)fromZ, (float)toX, (float)toY, (float)toZ);
    }

    public void sendItemMove(Player player, Level level, ItemStack itemStack, float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        if (level.getNearestPlayer((double)fromX, (double)fromY, (double)fromZ, (double)ConfigServerControlledSyncedToClient.distanceRequiredToShowGUIInfo, entity -> entity != player) != null) {
            CompoundTag data = new CompoundTag();
            Tag itemData = itemStack.save((HolderLookup.Provider)level.registryAccess());
            if (itemData.sizeInBytes() > 31000) {
                CULog.dbg((String)"itemstack too large for sending, using simple version");
                itemStack = this.getSimpleItemStack(itemStack);
                itemData = itemStack.save((HolderLookup.Provider)level.registryAccess());
            }
            data.put(WatutNetworking.NBTDataItemTransferItemStack, itemData);
            data.putFloat(WatutNetworking.NBTDataItemTransferFromX, fromX);
            data.putFloat(WatutNetworking.NBTDataItemTransferFromY, fromY);
            data.putFloat(WatutNetworking.NBTDataItemTransferFromZ, fromZ);
            data.putFloat(WatutNetworking.NBTDataItemTransferToX, toX);
            data.putFloat(WatutNetworking.NBTDataItemTransferToY, toY);
            data.putFloat(WatutNetworking.NBTDataItemTransferToZ, toZ);
            WatutNetworking.instance().serverSendToClientNear(data, new Vec3((double)fromX, (double)fromY, (double)fromZ), ConfigServerControlledSyncedToClient.distanceRequiredToShowGUIInfo, level);
        }
    }

    public void makeNewInventorySnapshot(AbstractContainerMenu abstractContainerMenu, Player player) {
        PlayerStatus playerStatus = this.getStatus(player);
        playerStatus.getInventorySnapshotPlayer().itemStackList.clear();
        playerStatus.getInventorySnapshotContainer().itemStackList.clear();
        playerStatus.getInventorySnapshotCarried().itemStackList.clear();
        for (ItemStack item : player.getInventory().items) {
            playerStatus.getInventorySnapshotPlayer().itemStackList.add(item.copy());
        }
        for (Slot slot : abstractContainerMenu.slots) {
            if (slot.container instanceof Inventory) continue;
            playerStatus.getInventorySnapshotContainer().itemStackList.add(slot.getItem().copy());
        }
        if (!abstractContainerMenu.getCarried().isEmpty()) {
            playerStatus.getInventorySnapshotCarried().itemStackList.add(abstractContainerMenu.getCarried().copy());
        }
    }

    public void doClickPre(AbstractContainerMenu abstractContainerMenu, int pSlotId, int pButton, ClickType pClickType, Player player) {
        if (!ConfigServerControlledSyncedToClient.showItemsBeingTransferredBetweenPlayerAndContainer) {
            return;
        }
        if (FakePlayerHelper.isFakePlayer(player)) {
            return;
        }
        PlayerStatus playerStatus = this.getStatus(player);
        if (playerStatus.isPlayerGuiDontSendItemInfo()) {
            return;
        }
        if (playerStatus.getLastBlockOpened().equals((Object)BlockPos.ZERO)) {
            return;
        }
        this.makeNewInventorySnapshot(abstractContainerMenu, player);
    }

    public void useBlock(Player player, BlockPos pos) {
        if (!ConfigServerControlledSyncedToClient.showItemsBeingTransferredBetweenPlayerAndContainer) {
            return;
        }
        if (FakePlayerHelper.isFakePlayer(player)) {
            return;
        }
        PlayerStatus playerStatus = this.getStatus(player);
        if (playerStatus.isPlayerGuiDontSendItemInfo()) {
            return;
        }
        playerStatus.setLastBlockOpened(pos);
    }

    public void doClickPost(AbstractContainerMenu abstractContainerMenu, int pSlotId, int pButton, ClickType pClickType, Player player) {
        block17: {
            List containerRemovedItems;
            List containerAddedItems;
            List playerRemovedItems;
            List playerAddedItems;
            block16: {
                if (!ConfigServerControlledSyncedToClient.showItemsBeingTransferredBetweenPlayerAndContainer) {
                    return;
                }
                if (FakePlayerHelper.isFakePlayer(player)) {
                    return;
                }
                PlayerStatus playerStatus = this.getStatus(player);
                if (playerStatus.isPlayerGuiDontSendItemInfo()) {
                    return;
                }
                if (playerStatus.getLastBlockOpened().equals((Object)BlockPos.ZERO)) {
                    return;
                }
                InventorySnapshot inventorySnapshotPlayerPost = new InventorySnapshot();
                InventorySnapshot inventorySnapshotContainerPost = new InventorySnapshot();
                InventorySnapshot inventorySnapshotCarriedPost = new InventorySnapshot();
                for (ItemStack item : player.getInventory().items) {
                    inventorySnapshotPlayerPost.itemStackList.add(item.copy());
                }
                for (Slot slot : abstractContainerMenu.slots) {
                    if (slot.container instanceof Inventory) continue;
                    inventorySnapshotContainerPost.itemStackList.add(slot.getItem().copy());
                }
                if (!abstractContainerMenu.getCarried().isEmpty()) {
                    inventorySnapshotCarriedPost.itemStackList.add(abstractContainerMenu.getCarried().copy());
                }
                Pair<List<ItemStack>, List<ItemStack>> listsPlayer = this.processInventorySnapshots(playerStatus.getInventorySnapshotPlayer().itemStackList, inventorySnapshotPlayerPost.itemStackList);
                playerAddedItems = (List)listsPlayer.getFirst();
                playerRemovedItems = (List)listsPlayer.getSecond();
                Pair<List<ItemStack>, List<ItemStack>> listsContainer = this.processInventorySnapshots(playerStatus.getInventorySnapshotContainer().itemStackList, inventorySnapshotContainerPost.itemStackList);
                containerAddedItems = (List)listsContainer.getFirst();
                containerRemovedItems = (List)listsContainer.getSecond();
                if (pClickType != ClickType.PICKUP) break block16;
                if (!abstractContainerMenu.getCarried().isEmpty() && playerAddedItems.size() == 0 && containerAddedItems.size() == 0) {
                    ItemStack itemStackCarriedMatch = this.getMatchingItem(abstractContainerMenu.getCarried(), playerRemovedItems);
                    if (itemStackCarriedMatch != null) {
                        playerStatus.setCarriedItemFromPlayerInventory(true);
                    } else {
                        itemStackCarriedMatch = this.getMatchingItem(abstractContainerMenu.getCarried(), containerRemovedItems);
                        if (itemStackCarriedMatch != null) {
                            playerStatus.setCarriedItemFromPlayerInventory(false);
                        }
                    }
                }
                if (playerStatus.getInventorySnapshotCarried().itemStackList.size() <= 0) break block17;
                ItemStack prevCarried = playerStatus.getInventorySnapshotCarried().itemStackList.get(0);
                for (ItemStack itemStackAdded : playerAddedItems) {
                    if (!ItemStack.isSameItem((ItemStack)prevCarried, (ItemStack)itemStackAdded) || playerStatus.isCarriedItemFromPlayerInventory()) continue;
                    this.sendItemMove(player, itemStackAdded, false);
                }
                for (ItemStack itemStackAdded : containerAddedItems) {
                    if (!ItemStack.isSameItem((ItemStack)prevCarried, (ItemStack)itemStackAdded) || !playerStatus.isCarriedItemFromPlayerInventory()) continue;
                    this.sendItemMove(player, itemStackAdded, true);
                }
                break block17;
            }
            if (pClickType == ClickType.QUICK_MOVE) {
                ItemStack itemStackAdded;
                for (ItemStack itemStackRemoved : playerRemovedItems) {
                    itemStackAdded = this.getMatchingItem(itemStackRemoved, containerAddedItems);
                    if (itemStackAdded == null || itemStackAdded.getCount() < itemStackRemoved.getCount()) continue;
                    this.sendItemMove(player, itemStackAdded, true);
                }
                for (ItemStack itemStackRemoved : containerRemovedItems) {
                    itemStackAdded = this.getMatchingItem(itemStackRemoved, playerAddedItems);
                    if (itemStackAdded == null || itemStackAdded.getCount() < itemStackRemoved.getCount()) continue;
                    this.sendItemMove(player, itemStackAdded, false);
                }
            }
        }
    }

    public ItemStack getSimpleItemStack(ItemStack itemStack) {
        return new ItemStack((ItemLike)itemStack.getItem(), itemStack.getCount());
    }

    public Pair<List<ItemStack>, List<ItemStack>> processInventorySnapshots(List<ItemStack> pre, List<ItemStack> post) {
        ArrayList<ItemStack> addedItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> removedItems = new ArrayList<ItemStack>();
        for (int i = 0; i < post.size(); ++i) {
            ItemStack stack;
            ItemStack stackPost;
            ItemStack stackPre = pre.get(i);
            if (!ItemStack.isSameItem((ItemStack)stackPre, (ItemStack)(stackPost = post.get(i)))) {
                if (stackPre.isEmpty() && !stackPost.isEmpty()) {
                    addedItems.add(stackPost.copy());
                    continue;
                }
                if (stackPre.isEmpty() || !stackPost.isEmpty()) continue;
                removedItems.add(stackPre.copy());
                continue;
            }
            if (stackPre.getCount() > stackPost.getCount()) {
                stack = stackPre.copy();
                stack.setCount(stackPre.getCount() - stackPost.getCount());
                removedItems.add(stack);
                continue;
            }
            if (stackPre.getCount() >= stackPost.getCount()) continue;
            stack = stackPost.copy();
            stack.setCount(stackPost.getCount() - stackPre.getCount());
            addedItems.add(stack);
        }
        return Pair.of(addedItems, removedItems);
    }

    public ItemStack getMatchingItem(ItemStack itemStack, List<ItemStack> itemStackList) {
        for (ItemStack itemStack1 : itemStackList) {
            if (!ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)itemStack1)) continue;
            return itemStack1;
        }
        return null;
    }

    public void sendItemMove(Player player, ItemStack itemStack, boolean toContainer) {
        PlayerStatus playerStatus = this.getStatus(player);
        BlockPos pos = playerStatus.getLastBlockOpened();
        float distFromFace = 0.55f;
        Vec3 lookVec = this.getBodyAngle(player).scale((double)distFromFace);
        if (toContainer) {
            this.sendItemMove(player, player.level(), itemStack, player.getX() + lookVec.x, player.getY() + 1.2, player.getZ() + lookVec.z, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.7f), (double)((float)pos.getZ() + 0.5f));
        } else {
            this.sendItemMove(player, player.level(), itemStack, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.7f), (double)((float)pos.getZ() + 0.5f), player.getX() + lookVec.x, player.getY() + 1.2, player.getZ() + lookVec.z);
        }
    }
}

