/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.datagen.JustDireBlockTags;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.FakePlayerUtil;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.UsefulFakePlayer;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.FakePlayer;

public class ClickerT1BE
extends BaseMachineBE
implements RedstoneControlledBE {
    public RedstoneControlData redstoneControlData = new RedstoneControlData();
    protected List<BlockPos> positionsToClick = new ArrayList<BlockPos>();
    protected List<? extends LivingEntity> entitiesToClick = new ArrayList<LivingEntity>();
    public int clickType = 0;
    public CLICK_TARGET clickTarget = CLICK_TARGET.BLOCK;
    public boolean sneaking = false;
    public boolean showFakePlayer = false;
    public int maxHoldTicks = 1;

    public ClickerT1BE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.MACHINE_SLOTS = 1;
    }

    public ClickerT1BE(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)Registration.ClickerT1BE.get(), pPos, pBlockState);
    }

    public void setClickerSettings(int clickType, int clickTarget, boolean sneaking, boolean showFakePlayer, int maxHoldTicks) {
        this.clickType = clickType;
        this.clickTarget = CLICK_TARGET.values()[clickTarget];
        this.sneaking = sneaking;
        this.showFakePlayer = showFakePlayer;
        this.maxHoldTicks = maxHoldTicks;
        this.positionsToClick.clear();
        this.entitiesToClick.clear();
        this.markDirtyClient();
    }

    @Override
    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.doClick();
    }

    public ItemStack getClickStack() {
        return this.getMachineHandler().getStackInSlot(0);
    }

    public void setClickStack(ItemStack stack) {
        this.getMachineHandler().setStackInSlot(0, stack);
    }

    public boolean isStackValid(ItemStack itemStack) {
        return true;
    }

    public boolean canClick() {
        return true;
    }

    public boolean clearTrackerIfNeeded(ItemStack itemStack) {
        if (this.positionsToClick.isEmpty() && this.entitiesToClick.isEmpty()) {
            return false;
        }
        if (!this.isStackValid(itemStack)) {
            return true;
        }
        if (!this.canClick()) {
            return true;
        }
        return !this.isActiveRedstone() && !this.redstoneControlData.redstoneMode.equals((Object)MiscHelpers.RedstoneMode.PULSE);
    }

    @Override
    public boolean canRun() {
        return super.canRun() || this.clickType == 2 && this.getUsefulFakePlayer((ServerLevel)this.level).isUsingItem();
    }

    public void doClick() {
        ItemStack placeStack = this.getClickStack();
        if (this.clearTrackerIfNeeded(placeStack)) {
            this.positionsToClick.clear();
            this.entitiesToClick.clear();
            return;
        }
        if (!this.canClick()) {
            return;
        }
        UsefulFakePlayer fakePlayer = this.getUsefulFakePlayer((ServerLevel)this.level);
        if (this.clickTarget.equals((Object)CLICK_TARGET.BLOCK) || this.clickTarget.equals((Object)CLICK_TARGET.AIR)) {
            if (this.isActiveRedstone() && this.canRun() && this.positionsToClick.isEmpty()) {
                this.positionsToClick = this.findSpotsToClick(fakePlayer);
            }
            if (this.positionsToClick.isEmpty()) {
                return;
            }
            if (this.canRun()) {
                BlockPos blockPos = this.positionsToClick.remove(0);
                this.clickBlock(placeStack, fakePlayer, blockPos);
            }
        } else {
            if (this.isActiveRedstone() && this.canRun() && this.entitiesToClick.isEmpty()) {
                this.entitiesToClick = this.findEntitiesToClick(this.getAABB());
            }
            if (this.entitiesToClick.isEmpty()) {
                return;
            }
            if (this.canRun() || this.clickType == 2 && fakePlayer.isUsingItem()) {
                LivingEntity entity = this.entitiesToClick.remove(0);
                this.clickEntity(placeStack, fakePlayer, entity);
            }
        }
    }

    public InteractionResult clickEntity(ItemStack itemStack, UsefulFakePlayer fakePlayer, LivingEntity entity) {
        Level level;
        fakePlayer.setReach(0.9);
        Direction placing = Direction.values()[this.direction];
        FakePlayerUtil.setupFakePlayerForUse(fakePlayer, entity.blockPosition(), placing, entity.position(), itemStack, this.sneaking);
        if (this.showFakePlayer && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!itemStack.isEmpty()) {
                fakePlayer.drawParticles(serverLevel, itemStack);
            }
        }
        FakePlayerUtil.FakePlayerResult fakePlayerResult = FakePlayerUtil.clickEntityInDirection(fakePlayer, this.level, entity, this.clickType, this.maxHoldTicks);
        this.setClickStack(fakePlayerResult.returnStack());
        FakePlayerUtil.cleanupFakePlayerFromUse(fakePlayer, fakePlayer.getMainHandItem());
        return fakePlayerResult.interactionResult();
    }

    public InteractionResult clickBlock(ItemStack itemStack, UsefulFakePlayer fakePlayer, BlockPos blockPos) {
        Level level;
        Direction placing = Direction.values()[this.direction];
        FakePlayerUtil.setupFakePlayerForUse(fakePlayer, blockPos, placing, itemStack, this.sneaking);
        if (this.showFakePlayer && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack showStack = itemStack.isEmpty() ? new ItemStack((ItemLike)Items.COBBLESTONE) : itemStack;
            fakePlayer.drawParticles(serverLevel, showStack);
        }
        FakePlayerUtil.FakePlayerResult fakePlayerResult = new FakePlayerUtil.FakePlayerResult(InteractionResult.FAIL, itemStack);
        if (!this.level.getBlockState(blockPos).isAir() && this.clickTarget.equals((Object)CLICK_TARGET.BLOCK)) {
            fakePlayer.setReach(0.9);
            fakePlayerResult = FakePlayerUtil.clickBlockInDirection(fakePlayer, this.level, this.clickType, this.maxHoldTicks);
        } else if (this.level.getBlockState(blockPos).isAir() && this.clickTarget.equals((Object)CLICK_TARGET.AIR)) {
            fakePlayer.setReach(1.0);
            fakePlayerResult = FakePlayerUtil.rightClickAirInDirection(fakePlayer, this.level, this.clickType, this.maxHoldTicks);
        }
        this.setClickStack(fakePlayerResult.returnStack());
        FakePlayerUtil.cleanupFakePlayerFromUse(fakePlayer, fakePlayer.getMainHandItem());
        return fakePlayerResult.interactionResult();
    }

    public boolean isBlockPosValid(FakePlayer fakePlayer, BlockPos blockPos) {
        if (!this.level.mayInteract((Player)fakePlayer, blockPos)) {
            return false;
        }
        if (this.level.getBlockState(blockPos).isAir() && this.clickTarget.equals((Object)CLICK_TARGET.BLOCK)) {
            return false;
        }
        if (!this.level.getBlockState(blockPos).isAir() && this.clickTarget.equals((Object)CLICK_TARGET.AIR)) {
            return false;
        }
        if (this.level.getBlockState(blockPos).is(JustDireBlockTags.NO_AUTO_CLICK)) {
            return false;
        }
        return this.canPlaceAt(this.level, blockPos, fakePlayer);
    }

    public List<BlockPos> findSpotsToClick(FakePlayer fakePlayer) {
        ArrayList<BlockPos> returnList = new ArrayList<BlockPos>();
        BlockPos blockPos = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
        if (this.isBlockPosValid(fakePlayer, blockPos)) {
            returnList.add(blockPos);
        }
        return returnList;
    }

    public AABB getAABB() {
        return new AABB(this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)));
    }

    public List<? extends LivingEntity> findEntitiesToClick(AABB aabb) {
        ArrayList returnList = new ArrayList(this.level.getEntitiesOfClass(LivingEntity.class, aabb, this::isValidEntity));
        return returnList;
    }

    public boolean isValidEntity(Entity entity) {
        Animal animal;
        if (this.clickTarget.equals((Object)CLICK_TARGET.HOSTILE) && !(entity instanceof Monster)) {
            return false;
        }
        if ((this.clickTarget.equals((Object)CLICK_TARGET.PASSIVE) || this.clickTarget.equals((Object)CLICK_TARGET.ADULT) || this.clickTarget.equals((Object)CLICK_TARGET.CHILD)) && !(entity instanceof Animal)) {
            return false;
        }
        if (this.clickTarget.equals((Object)CLICK_TARGET.ADULT) && entity instanceof Animal && (animal = (Animal)entity).isBaby()) {
            return false;
        }
        if (this.clickTarget.equals((Object)CLICK_TARGET.CHILD) && entity instanceof Animal && !(animal = (Animal)entity).isBaby()) {
            return false;
        }
        return !this.clickTarget.equals((Object)CLICK_TARGET.PLAYER) || entity instanceof Player;
    }

    @Override
    public boolean isDefaultSettings() {
        if (!super.isDefaultSettings()) {
            return false;
        }
        if (this.clickType != 0) {
            return false;
        }
        if (!this.clickTarget.equals((Object)CLICK_TARGET.BLOCK)) {
            return false;
        }
        if (this.sneaking) {
            return false;
        }
        if (this.showFakePlayer) {
            return false;
        }
        return this.maxHoldTicks == 1;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("clickType", this.clickType);
        tag.putInt("clickTarget", this.clickTarget.ordinal());
        tag.putBoolean("sneaking", this.sneaking);
        tag.putBoolean("showFakePlayer", this.showFakePlayer);
        tag.putInt("maxHoldTicks", this.maxHoldTicks);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.clickType = tag.getInt("clickType");
        this.clickTarget = CLICK_TARGET.values()[tag.getInt("clickTarget")];
        this.sneaking = tag.getBoolean("sneaking");
        this.showFakePlayer = tag.getBoolean("showFakePlayer");
        if (tag.contains("maxHoldTicks")) {
            this.maxHoldTicks = tag.getInt("maxHoldTicks");
        }
        super.loadAdditional(tag, provider);
    }

    public static enum CLICK_TARGET {
        BLOCK,
        AIR,
        HOSTILE,
        PASSIVE,
        ADULT,
        CHILD,
        PLAYER,
        LIVING;


        public CLICK_TARGET next() {
            CLICK_TARGET[] values = CLICK_TARGET.values();
            int nextOrdinal = (this.ordinal() + 1) % values.length;
            return values[nextOrdinal];
        }
    }
}

