/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.entities;

import com.direwolf20.justdirethings.common.items.interfaces.AbilityMethods;
import com.direwolf20.justdirethings.setup.Registration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class DecoyEntity
extends LivingEntity {
    private static final EntityDataAccessor<Optional<UUID>> PLAYER_UUID = SynchedEntityData.defineId(DecoyEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public DecoyEntity(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    public DecoyEntity(Level level) {
        this((EntityType<? extends LivingEntity>)((EntityType)Registration.DecoyEntity.get()), level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.ARMOR, 0.0);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.tickCount % 10 == 0) {
                this.aggroMobs();
            }
            if (this.tickCount >= 200) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void aggroMobs() {
        int radius = 10;
        AABB aabb = new AABB(this.getX() - (double)radius, this.getY() - (double)radius, this.getZ() - (double)radius, this.getX() + (double)radius, this.getY() + (double)radius, this.getZ() + (double)radius);
        ArrayList aggroList = new ArrayList(this.level().getEntitiesOfClass(Mob.class, aabb, AbilityMethods::isValidStompEntity));
        for (Mob mob : aggroList) {
            mob.setTarget((LivingEntity)this);
        }
    }

    public void setSummonerName(String playerName) {
        this.setCustomName((Component)Component.literal((String)(playerName + "_")).append((Component)Component.translatable((String)"justdirethings.decoy")));
    }

    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.entityData.get(PLAYER_UUID);
    }

    public void setOwnerUUID(UUID uuid) {
        this.entityData.set(PLAYER_UUID, Optional.of(uuid));
    }

    public HumanoidArm getMainArm() {
        return null;
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        return !damageSource.is(DamageTypes.GENERIC_KILL);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PLAYER_UUID, Optional.empty());
    }

    public Iterable<ItemStack> getArmorSlots() {
        return NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("player_uuid")) {
            this.entityData.set(PLAYER_UUID, Optional.of(compound.getUUID("player_uuid")));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (((Optional)this.entityData.get(PLAYER_UUID)).isPresent()) {
            compound.putUUID("player_uuid", (UUID)((Optional)this.entityData.get(PLAYER_UUID)).get());
        }
    }
}

