/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs;

import guideme.internal.shaded.lucene.codecs.KnnFieldVectorsWriter;
import guideme.internal.shaded.lucene.codecs.KnnVectorsWriter;
import guideme.internal.shaded.lucene.index.ByteVectorValues;
import guideme.internal.shaded.lucene.index.DocsWithFieldSet;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.FloatVectorValues;
import guideme.internal.shaded.lucene.index.KnnVectorValues;
import guideme.internal.shaded.lucene.index.MergeState;
import guideme.internal.shaded.lucene.index.Sorter;
import guideme.internal.shaded.lucene.index.SortingCodecReader;
import guideme.internal.shaded.lucene.index.VectorEncoding;
import guideme.internal.shaded.lucene.search.DocIdSet;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public abstract class BufferingKnnVectorsWriter
extends KnnVectorsWriter {
    private final List<FieldWriter<?>> fields = new ArrayList();

    protected BufferingKnnVectorsWriter() {
    }

    @Override
    public KnnFieldVectorsWriter<?> addField(final FieldInfo fieldInfo) throws IOException {
        FieldWriter<Object[]> newField = switch (fieldInfo.getVectorEncoding()) {
            case VectorEncoding.FLOAT32 -> new FieldWriter<float[]>(this, fieldInfo){

                @Override
                public float[] copyValue(float[] vectorValue) {
                    return ArrayUtil.copyOfSubArray(vectorValue, 0, fieldInfo.getVectorDimension());
                }
            };
            case VectorEncoding.BYTE -> new FieldWriter<byte[]>(this, fieldInfo){

                @Override
                public byte[] copyValue(byte[] vectorValue) {
                    return ArrayUtil.copyOfSubArray(vectorValue, 0, fieldInfo.getVectorDimension());
                }
            };
            default -> throw new UnsupportedOperationException();
        };
        this.fields.add(newField);
        return newField;
    }

    @Override
    public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        for (FieldWriter<?> fieldData : this.fields) {
            switch (fieldData.fieldInfo.getVectorEncoding()) {
                case FLOAT32: {
                    BufferedFloatVectorValues bufferedFloatVectorValues = new BufferedFloatVectorValues(fieldData.vectors, fieldData.fieldInfo.getVectorDimension(), fieldData.docsWithField);
                    FloatVectorValues floatVectorValues = sortMap != null ? new SortingFloatVectorValues(bufferedFloatVectorValues, fieldData.docsWithField, sortMap) : bufferedFloatVectorValues;
                    this.writeField(fieldData.fieldInfo, floatVectorValues, maxDoc);
                    break;
                }
                case BYTE: {
                    BufferedByteVectorValues bufferedByteVectorValues = new BufferedByteVectorValues(fieldData.vectors, fieldData.fieldInfo.getVectorDimension(), fieldData.docsWithField);
                    ByteVectorValues byteVectorValues = sortMap != null ? new SortingByteVectorValues(bufferedByteVectorValues, fieldData.docsWithField, sortMap) : bufferedByteVectorValues;
                    this.writeField(fieldData.fieldInfo, byteVectorValues, maxDoc);
                }
            }
        }
    }

    @Override
    public long ramBytesUsed() {
        long total = 0L;
        for (FieldWriter<?> field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    @Override
    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        switch (fieldInfo.getVectorEncoding()) {
            case FLOAT32: {
                FloatVectorValues floatVectorValues = KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState);
                this.writeField(fieldInfo, floatVectorValues, mergeState.segmentInfo.maxDoc());
                break;
            }
            case BYTE: {
                ByteVectorValues byteVectorValues = KnnVectorsWriter.MergedVectorValues.mergeByteVectorValues(fieldInfo, mergeState);
                this.writeField(fieldInfo, byteVectorValues, mergeState.segmentInfo.maxDoc());
            }
        }
    }

    protected abstract void writeField(FieldInfo var1, FloatVectorValues var2, int var3) throws IOException;

    protected abstract void writeField(FieldInfo var1, ByteVectorValues var2, int var3) throws IOException;

    private static abstract class FieldWriter<T>
    extends KnnFieldVectorsWriter<T> {
        private final FieldInfo fieldInfo;
        private final int dim;
        private final DocsWithFieldSet docsWithField;
        private final List<T> vectors;
        private int lastDocID = -1;

        FieldWriter(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            this.dim = fieldInfo.getVectorDimension();
            this.docsWithField = new DocsWithFieldSet();
            this.vectors = new ArrayList<T>();
        }

        @Override
        public final void addValue(int docID, T value) {
            if (docID == this.lastDocID) {
                throw new IllegalArgumentException("VectorValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
            }
            assert (docID > this.lastDocID);
            this.docsWithField.add(docID);
            this.vectors.add(this.copyValue(value));
            this.lastDocID = docID;
        }

        @Override
        public abstract T copyValue(T var1);

        @Override
        public final long ramBytesUsed() {
            if (this.vectors.isEmpty()) {
                return 0L;
            }
            return this.docsWithField.ramBytesUsed() + (long)this.vectors.size() * (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) + (long)this.vectors.size() * (long)this.dim * 4L;
        }
    }

    private static class BufferedFloatVectorValues
    extends FloatVectorValues {
        final List<float[]> vectors;
        final int dimension;
        private final DocIdSet docsWithField;
        private final KnnVectorValues.DocIndexIterator iterator;

        BufferedFloatVectorValues(List<float[]> vectors, int dimension, DocIdSet docsWithField) throws IOException {
            this.vectors = vectors;
            this.dimension = dimension;
            this.docsWithField = docsWithField;
            this.iterator = BufferedFloatVectorValues.fromDISI(docsWithField.iterator());
        }

        @Override
        public int dimension() {
            return this.dimension;
        }

        @Override
        public int size() {
            return this.vectors.size();
        }

        @Override
        public int ordToDoc(int ord) {
            return ord;
        }

        @Override
        public float[] vectorValue(int targetOrd) {
            return this.vectors.get(targetOrd);
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.iterator;
        }

        @Override
        public BufferedFloatVectorValues copy() throws IOException {
            return new BufferedFloatVectorValues(this.vectors, this.dimension, this.docsWithField);
        }
    }

    private static class SortingFloatVectorValues
    extends FloatVectorValues {
        private final BufferedFloatVectorValues delegate;
        private final Supplier<SortingCodecReader.SortingValuesIterator> iteratorSupplier;

        SortingFloatVectorValues(BufferedFloatVectorValues delegate, DocsWithFieldSet docsWithField, Sorter.DocMap sortMap) throws IOException {
            this.delegate = delegate.copy();
            this.iteratorSupplier = SortingCodecReader.iteratorSupplier(delegate, sortMap);
        }

        @Override
        public float[] vectorValue(int ord) throws IOException {
            return this.delegate.vectorValue(ord);
        }

        @Override
        public int dimension() {
            return this.delegate.dimension();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public SortingFloatVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.iteratorSupplier.get();
        }
    }

    private static class BufferedByteVectorValues
    extends ByteVectorValues {
        final List<byte[]> vectors;
        final int dimension;
        private final DocIdSet docsWithField;
        private final KnnVectorValues.DocIndexIterator iterator;

        BufferedByteVectorValues(List<byte[]> vectors, int dimension, DocIdSet docsWithField) throws IOException {
            this.vectors = vectors;
            this.dimension = dimension;
            this.docsWithField = docsWithField;
            this.iterator = BufferedByteVectorValues.fromDISI(docsWithField.iterator());
        }

        @Override
        public int dimension() {
            return this.dimension;
        }

        @Override
        public int size() {
            return this.vectors.size();
        }

        @Override
        public byte[] vectorValue(int targetOrd) {
            return this.vectors.get(targetOrd);
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.iterator;
        }

        @Override
        public BufferedByteVectorValues copy() throws IOException {
            return new BufferedByteVectorValues(this.vectors, this.dimension, this.docsWithField);
        }
    }

    private static class SortingByteVectorValues
    extends ByteVectorValues {
        private final BufferedByteVectorValues delegate;
        private final Supplier<SortingCodecReader.SortingValuesIterator> iteratorSupplier;

        SortingByteVectorValues(BufferedByteVectorValues delegate, DocsWithFieldSet docsWithField, Sorter.DocMap sortMap) throws IOException {
            this.delegate = delegate;
            this.iteratorSupplier = SortingCodecReader.iteratorSupplier(delegate, sortMap);
        }

        @Override
        public byte[] vectorValue(int ord) throws IOException {
            return this.delegate.vectorValue(ord);
        }

        @Override
        public int dimension() {
            return this.delegate.dimension();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public SortingByteVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.iteratorSupplier.get();
        }
    }
}

