/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.extensions.gfm;

import guideme.libs.micromark.Token;
import guideme.libs.micromark.extensions.gfm.Align;
import guideme.libs.micromark.extensions.gfm.GfmTableSyntax;
import guideme.libs.micromark.html.HtmlContext;
import guideme.libs.micromark.html.HtmlContextProperty;
import guideme.libs.micromark.html.HtmlExtension;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GfmTableHtml {
    private static final HtmlContextProperty<List<Align>> TABLE_ALIGN = new HtmlContextProperty();
    private static final HtmlContextProperty<Integer> TABLE_COLUMN = new HtmlContextProperty();
    public static final HtmlExtension EXTENSION = HtmlExtension.builder().enter("table", GfmTableHtml::enterTable).enter("tableBody", GfmTableHtml::enterTableBody).enter("tableData", GfmTableHtml::enterTableData).enter("tableHead", GfmTableHtml::enterTableHead).enter("tableHeader", GfmTableHtml::enterTableHeader).enter("tableRow", GfmTableHtml::enterTableRow).exit("codeTextData", GfmTableHtml::exitCodeTextData).exit("table", GfmTableHtml::exitTable).exit("tableBody", GfmTableHtml::exitTableBody).exit("tableData", GfmTableHtml::exitTableData).exit("tableHead", GfmTableHtml::exitTableHead).exit("tableHeader", GfmTableHtml::exitTableHeader).exit("tableRow", GfmTableHtml::exitTableRow).build();
    private static final Pattern PIPE_PATTERN = Pattern.compile("\\\\([\\\\|])");

    private GfmTableHtml() {
    }

    private static void enterTable(HtmlContext context, Token token) {
        List<Align> tableAlign = token.get(GfmTableSyntax.ALIGN);
        context.lineEndingIfNeeded();
        context.tag("<table>");
        context.set(TABLE_ALIGN, tableAlign);
    }

    private static void enterTableBody(HtmlContext context, Token token) {
        context.setSlurpOneLineEnding(false);
        context.tag("<tbody>");
    }

    private static void enterTableData(HtmlContext context, Token token) {
        List<Align> tableAlign = context.get(TABLE_ALIGN);
        Integer tableColumn = context.get(TABLE_COLUMN);
        if (tableColumn >= tableAlign.size()) {
            context.buffer();
        } else {
            context.lineEndingIfNeeded();
            String align = GfmTableHtml.getAlignmentAttr(tableAlign.get(tableColumn));
            context.tag("<td" + align + ">");
        }
    }

    private static void enterTableHead(HtmlContext context, Token token) {
        context.lineEndingIfNeeded();
        context.tag("<thead>");
    }

    private static void enterTableHeader(HtmlContext context, Token token) {
        List<Align> tableAlign = context.get(TABLE_ALIGN);
        Integer tableColumn = context.get(TABLE_COLUMN);
        String align = GfmTableHtml.getAlignmentAttr(tableAlign.get(tableColumn));
        context.lineEndingIfNeeded();
        context.tag("<th" + align + ">");
    }

    private static void enterTableRow(HtmlContext context, Token token) {
        context.set(TABLE_COLUMN, 0);
        context.lineEndingIfNeeded();
        context.tag("<tr>");
    }

    private static void exitCodeTextData(HtmlContext context, Token token) {
        String value = context.sliceSerialize(token);
        if (context.has(TABLE_ALIGN)) {
            value = PIPE_PATTERN.matcher(value).replaceAll(mr -> {
                String g = mr.group(1);
                return Matcher.quoteReplacement(g.equals("|") ? g : mr.group());
            });
        }
        context.raw(context.encode(value));
    }

    private static void exitTable(HtmlContext context, Token token) {
        context.remove(TABLE_ALIGN);
        context.setSlurpAllLineEndings(false);
        context.lineEndingIfNeeded();
        context.tag("</table>");
    }

    private static void exitTableBody(HtmlContext context, Token token) {
        context.lineEndingIfNeeded();
        context.tag("</tbody>");
    }

    private static void exitTableData(HtmlContext context, Token token) {
        List<Align> tableAlign = context.get(TABLE_ALIGN);
        Integer tableColumn = context.get(TABLE_COLUMN);
        if (tableColumn < tableAlign.size()) {
            context.tag("</td>");
            context.set(TABLE_COLUMN, tableColumn + 1);
        } else {
            context.resume();
        }
    }

    private static void exitTableHead(HtmlContext context, Token token) {
        context.lineEndingIfNeeded();
        context.tag("</thead>");
        context.setSlurpOneLineEnding(true);
    }

    private static void exitTableHeader(HtmlContext context, Token token) {
        Integer tableColumn = context.get(TABLE_COLUMN);
        context.tag("</th>");
        context.set(TABLE_COLUMN, tableColumn + 1);
    }

    private static void exitTableRow(HtmlContext context, Token token) {
        List<Align> tableAlign = context.get(TABLE_ALIGN);
        Integer tableColumn = context.get(TABLE_COLUMN);
        while (tableColumn < tableAlign.size()) {
            context.lineEndingIfNeeded();
            context.tag("<td" + GfmTableHtml.getAlignmentAttr(tableAlign.get(tableColumn)) + "></td>");
            Integer n = tableColumn;
            tableColumn = tableColumn + 1;
        }
        context.set(TABLE_COLUMN, tableColumn);
        context.lineEndingIfNeeded();
        context.tag("</tr>");
    }

    private static String getAlignmentAttr(Align align) {
        return switch (align) {
            default -> throw new MatchException(null, null);
            case Align.NONE -> "";
            case Align.LEFT -> " align=\"left\"";
            case Align.RIGHT -> " align=\"right\"";
            case Align.CENTER -> " align=\"center\"";
        };
    }
}

