/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.client.shake;

import java.util.Random;
import org.joml.Vector2f;

public class ShakeData {
    private final Vector2f amplitude;
    private final Vector2f frequency;
    private long durationMillis;
    private long startTimestamp;
    private short seed;
    private boolean isFinished;

    public ShakeData(Vector2f amplitude, Vector2f frequency, double durationInSeconds, short seed) {
        this.amplitude = amplitude;
        this.frequency = frequency;
        this.startTimestamp = System.currentTimeMillis();
        this.durationMillis = (long)(durationInSeconds * 1000.0);
        this.seed = seed;
    }

    public ShakeData(Vector2f amplitude, Vector2f frequency, double durationInSeconds) {
        this(amplitude, frequency, durationInSeconds, (short)new Random().nextInt(Short.MIN_VALUE, Short.MAX_VALUE));
    }

    public ShakeData(float amplitude, float frequency, double durationInSeconds) {
        this(new Vector2f(amplitude, amplitude), new Vector2f(frequency * 1.24f, frequency * 0.81f), durationInSeconds);
    }

    public Vector2f update() {
        if (this.isFinished) {
            return new Vector2f(0.0f, 0.0f);
        }
        long now = System.currentTimeMillis();
        long elapsedTime = now - this.startTimestamp;
        float t = (float)Math.min((double)elapsedTime / (double)this.durationMillis, 1.0);
        float easedT = 1.0f - t;
        if (t >= 1.0f) {
            this.isFinished = true;
        }
        float offsetX = this.amplitude.x() * (float)Math.sin((double)this.seed * Math.PI + (double)((float)elapsedTime / 1000.0f * this.frequency.x() * 2.0f) * Math.PI) * easedT;
        float offsetY = this.amplitude.y() * (float)Math.sin((double)this.seed * Math.PI + (double)((float)elapsedTime / 1000.0f * this.frequency.y() * 2.0f) * Math.PI) * easedT;
        return new Vector2f(offsetX, offsetY);
    }

    public boolean isFinished() {
        return this.isFinished;
    }
}

