/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.module.config.loader;

import dev.architectury.platform.Platform;
import it.hurts.octostudios.octolib.module.config.cfgbuilder.CompoundEntry;
import it.hurts.octostudios.octolib.module.config.cfgbuilder.ConfigEntry;
import it.hurts.octostudios.octolib.module.config.loader.IConfigFileLoader;
import it.hurts.octostudios.octolib.module.config.provider.ConfigProvider;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class SolidConfigLoader<T>
implements IConfigFileLoader<T, T> {
    @Override
    public void saveToFiles(String filePath, T data, ConfigProvider provider) {
        File file = Platform.getConfigFolder().resolve(filePath + ".yaml").toFile();
        if (file.getParentFile().isDirectory() || file.getParentFile().mkdirs()) {
            try (FileWriter writer = new FileWriter(file);){
                provider.save(writer, data);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T loadFiles(String filePath, ConfigEntry pattern, ConfigProvider provider) {
        File file = Platform.getConfigFolder().resolve(filePath + ".yaml").toFile();
        if (!file.isFile()) return null;
        try (FileReader reader = new FileReader(file);){
            Object object = provider.load(reader, (CompoundEntry)pattern);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

