/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.model;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.client.model.BlockVariantsModel;
import it.zerono.mods.zerocore.lib.client.model.ICustomModelBuilder;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.neoforged.neoforge.client.event.ModelEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockVariantsModelBuilder
implements ICustomModelBuilder {
    private static final ModelResourceLocation[] EMPTY_VARIANTS = new ModelResourceLocation[0];
    private final boolean _ambientOcclusion;
    private final boolean _guid3D;
    private final boolean _builtInRenderer;
    private final Int2ObjectMap<BlockEntrySource> _blocks;
    private final List<ModelResourceLocation> _modelsToBeLoaded;
    private @Nullable Consumer<@NotNull BlockVariantsModel> _fallbackDataBuilder;

    public BlockVariantsModelBuilder(boolean ambientOcclusion, boolean guid3D, boolean builtInRenderer) {
        this._ambientOcclusion = ambientOcclusion;
        this._guid3D = guid3D;
        this._builtInRenderer = builtInRenderer;
        this._blocks = new Int2ObjectOpenHashMap();
        this._modelsToBeLoaded = new ObjectArrayList(64);
    }

    public void loadAdditionalModel(ModelResourceLocation model, ModelResourceLocation ... others) {
        this.loadAdditionalStandaloneModels(model);
        this.loadAdditionalStandaloneModels(others);
    }

    public void addBlock(int id, ModelResourceLocation originalModel, boolean hasGeneralQuads, ModelResourceLocation ... additionalVariants) {
        if (additionalVariants.length == 0) {
            additionalVariants = EMPTY_VARIANTS;
        } else {
            this.loadAdditionalStandaloneModels(additionalVariants);
        }
        this._blocks.put(id, (Object)new BlockEntrySource(id, originalModel, additionalVariants, hasGeneralQuads));
    }

    protected BlockVariantsModel createReplacementModel(int blockCount, boolean ambientOcclusion, boolean guid3D, boolean builtInRenderer) {
        return new BlockVariantsModel(blockCount, ambientOcclusion, guid3D, builtInRenderer);
    }

    protected void setFallbackModelData(int blockId, int variantIndex) {
        this._fallbackDataBuilder = model -> model.setFallbackModelData(blockId, variantIndex);
    }

    protected void setFallbackModelData(int blockId, int variantIndex, Consumer<// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ModelData.Builder> builder) {
        this._fallbackDataBuilder = model -> model.setFallbackModelData(blockId, variantIndex, builder);
    }

    @Override
    public void onRegisterModels(ModelEvent.RegisterAdditional event) {
        this._modelsToBeLoaded.forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
    }

    @Override
    public void onBakeModels(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        BlockVariantsModel replacementModel = this.createReplacementModel(this._blocks.size(), this._ambientOcclusion, this._guid3D, this._builtInRenderer);
        if (null != this._fallbackDataBuilder) {
            this._fallbackDataBuilder.accept(replacementModel);
        }
        for (BlockEntrySource block : this._blocks.values()) {
            BakedModel[] variantsModels = new BakedModel[1 + block.variants.length];
            variantsModels[0] = (BakedModel)modelRegistry.get(block.originalModel);
            if (null == variantsModels[0]) {
                Log.LOGGER.warn(Log.CLIENT, "Unable to lookup the original model for a block variant: {}. Skipping block!", (Object)block.originalModel);
                continue;
            }
            for (int idx = 0; idx < block.variants.length; ++idx) {
                BakedModel variantModel;
                if (modelRegistry.containsKey(block.variants[idx])) {
                    variantModel = (BakedModel)modelRegistry.get(block.variants[idx]);
                } else {
                    Log.LOGGER.warn(Log.CLIENT, "Unable to lookup model for a block variant: {}", (Object)block.variants[idx]);
                    variantModel = ModRenderHelper.getMissingModel();
                }
                variantsModels[1 + idx] = variantModel;
            }
            replacementModel.addBlock(block.blockId, block.hasGeneralQuads, variantsModels);
            modelRegistry.put(block.originalModel, replacementModel);
        }
    }

    private void loadAdditionalStandaloneModels(ModelResourceLocation ... models) {
        for (ModelResourceLocation model : models) {
            if (!model.variant().equals("standalone")) continue;
            this._modelsToBeLoaded.add(model);
        }
    }

    private record BlockEntrySource(int blockId, ModelResourceLocation originalModel, ModelResourceLocation[] variants, boolean hasGeneralQuads) {
    }
}

