/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.recipe;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.AbstractModRecipeBuilder;
import it.zerono.mods.zerocore.lib.recipe.AbstractTwoToOneRecipe;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public class TwoToOneRecipeBuilder<Ingredient1, Ingredient2, Result, RecipeIngredient1 extends IRecipeIngredient<Ingredient1>, RecipeIngredient2 extends IRecipeIngredient<Ingredient2>, RecipeResult extends IRecipeResult<Result>, Recipe extends AbstractTwoToOneRecipe<Ingredient1, Ingredient2, Result, RecipeIngredient1, RecipeIngredient2, RecipeResult>>
extends AbstractModRecipeBuilder<Recipe, Result, RecipeResult, TwoToOneRecipeBuilder<Ingredient1, Ingredient2, Result, RecipeIngredient1, RecipeIngredient2, RecipeResult, Recipe>> {
    private final Supplier<@NotNull Recipe> _recipeFactory;

    public TwoToOneRecipeBuilder(RecipeIngredient1 ingredient1, RecipeIngredient2 ingredient2, RecipeResult result, TriFunction<RecipeIngredient1, RecipeIngredient2, RecipeResult, Recipe> recipeFactory) {
        super(result);
        Preconditions.checkArgument((!ingredient1.isEmpty() ? 1 : 0) != 0, (Object)"Ingredient 1 cannot be empty");
        Preconditions.checkArgument((!ingredient2.isEmpty() ? 1 : 0) != 0, (Object)"Ingredient 2 cannot be empty");
        Preconditions.checkArgument((!result.isEmpty() ? 1 : 0) != 0, (Object)"Result cannot be empty");
        Preconditions.checkNotNull(recipeFactory, (Object)"Recipe factory cannot be empty");
        this._recipeFactory = () -> Objects.requireNonNull((AbstractTwoToOneRecipe)recipeFactory.apply(ingredient1, ingredient2, result));
    }

    @Override
    protected Recipe getRecipe() {
        return (Recipe)((AbstractTwoToOneRecipe)this._recipeFactory.get());
    }
}

