/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin.builtin.wrapper;

import com.mojang.brigadier.StringReader;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import org.jetbrains.annotations.Nullable;

public class EntitySelectorWrapper {
    private static final Map<String, EntitySelector> ENTITY_SELECTOR_CACHE = new HashMap<String, EntitySelector>();
    private static final EntitySelector ALL_ENTITIES_SELECTOR = new EntitySelector(Integer.MAX_VALUE, true, false, List.of(), MinMaxBounds.Doubles.ANY, Function.identity(), null, EntitySelectorParser.ORDER_RANDOM, false, null, null, null, true);

    public static EntitySelector of(EntitySelector selector) {
        return selector;
    }

    @HideFromJS
    public static EntitySelector wrap(Context cx, @Nullable Object o) {
        EntitySelector sel;
        if (o == null) {
            return ALL_ENTITIES_SELECTOR;
        }
        if (o instanceof EntitySelector) {
            EntitySelector s = (EntitySelector)o;
            return s;
        }
        String s = o.toString();
        if (s.isBlank()) {
            return ALL_ENTITIES_SELECTOR;
        }
        if (ENTITY_SELECTOR_CACHE.containsKey(s)) {
            sel = ENTITY_SELECTOR_CACHE.get(s);
        } else {
            try {
                sel = new EntitySelectorParser(new StringReader(s), true).parse();
                ENTITY_SELECTOR_CACHE.put(s, sel);
            }
            catch (Exception ex) {
                ConsoleJS.getCurrent(cx).error("Error parsing entity selector, falling back to all", ex);
                return ALL_ENTITIES_SELECTOR;
            }
        }
        return sel;
    }
}

