/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;
import sonar.fluxnetworks.client.gui.basic.GuiPopupCore;
import sonar.fluxnetworks.common.connection.FluxMenu;

public abstract class GuiPopupHost
extends GuiFocusable {
    private GuiPopupCore<?> mCurrentPopup;

    protected GuiPopupHost(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
    }

    public final void openPopup(GuiPopupCore<?> popup) {
        if (popup == null || popup.mHost != this) {
            return;
        }
        this.closePopup();
        this.mCurrentPopup = popup;
        this.mCurrentPopup.init(this.getMinecraft(), this.width, this.height);
        this.onPopupOpen(this.mCurrentPopup);
    }

    protected void onPopupOpen(GuiPopupCore<?> popup) {
    }

    public final void closePopup() {
        if (this.mCurrentPopup != null) {
            this.onPopupClose(this.mCurrentPopup);
            this.mCurrentPopup.onClose();
            this.mCurrentPopup = null;
        }
    }

    protected void onPopupClose(GuiPopupCore<?> popup) {
    }

    @Nullable
    public final GuiPopupCore<?> getCurrentPopup() {
        return this.mCurrentPopup;
    }

    public final void mouseMoved(double mouseX, double mouseY) {
        if (this.mCurrentPopup != null) {
            this.mCurrentPopup.mouseMoved(mouseX, mouseY);
            return;
        }
        if (this.onMouseMoved(mouseX, mouseY)) {
            return;
        }
        super.mouseMoved(mouseX, mouseY);
    }

    protected boolean onMouseMoved(double mouseX, double mouseY) {
        return false;
    }

    public final boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.mCurrentPopup != null) {
            return this.mCurrentPopup.mouseClicked(mouseX, mouseY, mouseButton);
        }
        boolean result = this.onMouseClicked(mouseX, mouseY, mouseButton);
        for (GuiEventListener child : this.children()) {
            if (!child.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            this.setFocused(child);
            if (mouseButton == 0) {
                this.setDragging(true);
            }
            return true;
        }
        boolean focused = false;
        for (GuiEventListener child : this.children()) {
            EditBox editBox;
            if (!(child instanceof EditBox) || !(editBox = (EditBox)child).isFocused() || !editBox.isMouseOver(mouseX, mouseY)) continue;
            focused = true;
            break;
        }
        if (!focused) {
            this.setFocused(null);
            return true;
        }
        return result;
    }

    protected boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public final boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.mCurrentPopup != null) {
            return this.mCurrentPopup.mouseReleased(mouseX, mouseY, mouseButton);
        }
        return this.onMouseReleased(mouseX, mouseY, mouseButton) || super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public final boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        if (this.mCurrentPopup != null) {
            return this.mCurrentPopup.mouseDragged(mouseX, mouseY, mouseButton, deltaX, deltaY);
        }
        return this.onMouseDragged(mouseX, mouseY, mouseButton, deltaX, mouseY) || super.mouseDragged(mouseX, mouseY, mouseButton, deltaX, mouseY);
    }

    public boolean onMouseDragged(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        return false;
    }

    public final boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.mCurrentPopup != null) {
            return this.mCurrentPopup.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return this.onMouseScrolled(mouseX, mouseY, scrollX, scrollY) || super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean onMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return false;
    }

    @Override
    public final boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.mCurrentPopup != null) {
            return this.mCurrentPopup.keyPressed(keyCode, scanCode, modifiers);
        }
        return this.onKeyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public final boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.mCurrentPopup != null) {
            return this.mCurrentPopup.keyReleased(keyCode, scanCode, modifiers);
        }
        return this.onKeyReleased(keyCode, scanCode, modifiers) || super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public final boolean charTyped(char c, int modifiers) {
        if (this.mCurrentPopup != null) {
            return this.mCurrentPopup.charTyped(c, modifiers);
        }
        return this.onCharTypes(c, modifiers) || super.charTyped(c, modifiers);
    }

    public boolean onCharTypes(char c, int modifiers) {
        return false;
    }

    public void init() {
        super.init();
        if (this.mCurrentPopup != null) {
            this.mCurrentPopup.init(this.getMinecraft(), this.width, this.height);
        }
    }

    protected void drawForegroundLayer(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
    }

    protected void drawBackgroundLayer(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
    }

    public final void render(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float partialTick) {
        super.render(gr, mouseX, mouseY, partialTick);
        float deltaTicks = this.getMinecraft().getTimer().getRealtimeDeltaTicks();
        this.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
        if (this.mCurrentPopup != null) {
            gr.pose().pushPose();
            gr.pose().translate(0.0f, 0.0f, 300.0f);
            this.mCurrentPopup.drawBackgroundLayer(gr, mouseX, mouseY, deltaTicks);
            gr.pose().translate(0.0f, 0.0f, 10.0f);
            this.mCurrentPopup.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
            gr.pose().popPose();
        }
    }

    protected final void renderLabels(@Nonnull GuiGraphics gr, int mouseX, int mouseY) {
    }

    protected final void renderBg(@Nonnull GuiGraphics gr, float partialTick, int mouseX, int mouseY) {
        float deltaTicks = this.getMinecraft().getTimer().getRealtimeDeltaTicks();
        this.drawBackgroundLayer(gr, mouseX, mouseY, deltaTicks);
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        if (this.mCurrentPopup != null) {
            this.mCurrentPopup.containerTick();
        }
    }
}

