/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.loot.function;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import vectorwing.farmersdelight.common.block.entity.SkilletBlockEntity;
import vectorwing.farmersdelight.common.registry.ModLootFunctions;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CopySkilletFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"copy_skillet");
    public static final MapCodec<CopySkilletFunction> CODEC = RecordCodecBuilder.mapCodec(p_298131_ -> CopySkilletFunction.commonFields((RecordCodecBuilder.Instance)p_298131_).apply((Applicative)p_298131_, CopySkilletFunction::new));

    private CopySkilletFunction(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return CopySkilletFunction.simpleBuilder(CopySkilletFunction::new);
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        BlockEntity tile = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (tile instanceof SkilletBlockEntity) {
            SkilletBlockEntity blockEntity = (SkilletBlockEntity)tile;
            stack = blockEntity.getSkilletAsItem();
        }
        return stack;
    }

    public LootItemFunctionType<CopySkilletFunction> getType() {
        return ModLootFunctions.COPY_SKILLET.get();
    }
}

