/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.gui;

import com.mojang.authlib.GameProfile;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.client.waypoint.Waypoint;
import dev.ftb.mods.ftbchunks.net.ShareWaypointPacket;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.NordButton;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractButtonListScreen;
import dev.ftb.mods.ftblibrary.ui.misc.SimpleToast;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class WaypointShareMenu {
    public static Optional<ContextMenuItem> makeShareMenu(Player sharingPlayer, Waypoint waypoint) {
        ArrayList<ContextMenuItem> items = new ArrayList<ContextMenuItem>();
        if (((Boolean)FTBChunksWorldConfig.WAYPOINT_SHARING_SERVER.get()).booleanValue()) {
            items.add(new ContextMenuItem((Component)Component.translatable((String)"ftbchunks.waypoint.share.server"), Icons.BEACON, b -> WaypointShareMenu.shareWaypoint(waypoint, ShareWaypointPacket.ShareType.SERVER, List.of())));
        }
        if (((Boolean)FTBChunksWorldConfig.WAYPOINT_SHARING_PARTY.get()).booleanValue()) {
            items.add(new ContextMenuItem((Component)Component.translatable((String)"ftbchunks.waypoint.share.party"), Icons.FRIENDS_GROUP, b -> WaypointShareMenu.shareWaypoint(waypoint, ShareWaypointPacket.ShareType.PARTY, List.of())));
        }
        if (((Boolean)FTBChunksWorldConfig.WAYPOINT_SHARING_PLAYERS.get()).booleanValue()) {
            items.add(new ContextMenuItem((Component)Component.translatable((String)"ftbchunks.waypoint.share.player"), Icons.PLAYER, b -> {
                Collection knownClientPlayers = FTBTeamsAPI.api().getClientManager().knownClientPlayers();
                List<GameProfile> list = knownClientPlayers.stream().filter(KnownClientPlayer::online).filter(p -> !p.id().equals(sharingPlayer.getGameProfile().getId())).map(KnownClientPlayer::profile).toList();
                ArrayList<GameProfile> selectedProfiles = new ArrayList<GameProfile>();
                new ShareWaypointButtonList(selectedProfiles, waypoint, list).openGui();
            }));
        }
        return items.isEmpty() ? Optional.empty() : Optional.of(ContextMenuItem.subMenu((Component)Component.translatable((String)"ftbchunks.waypoint.share"), (Icon)Icons.INFO, items));
    }

    private static void shareWaypoint(Waypoint waypoint, ShareWaypointPacket.ShareType type, List<UUID> targets) {
        GlobalPos waypointPos = new GlobalPos(waypoint.getDimension(), waypoint.getPos());
        NetworkManager.sendToServer((CustomPacketPayload)new ShareWaypointPacket(waypoint.getName(), waypointPos, type, targets));
        SimpleToast.info((Component)Component.translatable((String)"ftbchunks.waypoint.shared_by_you", (Object[])new Object[]{waypoint.getDisplayName()}), (Component)Component.empty());
    }

    private static class ShareWaypointButtonList
    extends AbstractButtonListScreen {
        private final List<GameProfile> selectedProfiles;
        private final Waypoint waypoint;
        private final List<GameProfile> gameProfiles;

        public ShareWaypointButtonList(List<GameProfile> selectedProfiles, Waypoint waypoint, List<GameProfile> gameProfiles) {
            this.selectedProfiles = selectedProfiles;
            this.waypoint = waypoint;
            this.gameProfiles = gameProfiles;
        }

        protected void doCancel() {
            this.closeGui();
        }

        protected void doAccept() {
            List<UUID> toShare = this.selectedProfiles.stream().map(GameProfile::getId).toList();
            if (!toShare.isEmpty()) {
                WaypointShareMenu.shareWaypoint(this.waypoint, ShareWaypointPacket.ShareType.PLAYER, toShare);
            }
            this.closeGui();
        }

        public void addButtons(Panel panel) {
            for (final GameProfile gameProfile : this.gameProfiles) {
                MutableComponent unchecked = Component.literal((String)"\u2610 ").append(gameProfile.getName());
                MutableComponent checked = Component.literal((String)"\u2611 ").withStyle(ChatFormatting.GREEN).append(gameProfile.getName());
                NordButton widget = new NordButton(panel, (Component)unchecked, (Icon)FaceIcon.getFace((GameProfile)gameProfile), (Component)unchecked, (Component)checked){
                    final /* synthetic */ Component val$unchecked;
                    final /* synthetic */ Component val$checked;
                    {
                        this.val$unchecked = component;
                        this.val$checked = component2;
                        super(panel, txt, icon);
                    }

                    public void onClicked(MouseButton button) {
                        if (selectedProfiles.contains(gameProfile)) {
                            selectedProfiles.remove(gameProfile);
                            this.title = this.val$unchecked;
                        } else {
                            selectedProfiles.add(gameProfile);
                            this.title = this.val$checked;
                        }
                        this.playClickSound();
                    }
                };
                panel.add((Widget)widget);
            }
        }
    }
}

