/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.blocks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.api.power.ItemEnergy;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Cached;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.ModuleTools;
import mcjty.rftoolsbase.api.control.code.ICompiledOpcode;
import mcjty.rftoolsbase.api.control.code.IOpcodeRunnable;
import mcjty.rftoolsbase.api.control.machines.IProcessor;
import mcjty.rftoolsbase.api.control.machines.IProgram;
import mcjty.rftoolsbase.api.control.parameters.BlockSide;
import mcjty.rftoolsbase.api.control.parameters.IParameter;
import mcjty.rftoolsbase.api.control.parameters.Inventory;
import mcjty.rftoolsbase.api.control.parameters.Parameter;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolsbase.api.control.parameters.Tuple;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.machineinfo.IMachineInformation;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardItem;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolscontrol.compat.RFToolsStuff;
import mcjty.rftoolscontrol.modules.craftingstation.blocks.CraftingStationTileEntity;
import mcjty.rftoolscontrol.modules.multitank.blocks.MultiTankTileEntity;
import mcjty.rftoolscontrol.modules.multitank.util.MultiTankFluidProperties;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorContainer;
import mcjty.rftoolscontrol.modules.processor.client.GuiProcessor;
import mcjty.rftoolscontrol.modules.processor.data.HudMode;
import mcjty.rftoolscontrol.modules.processor.data.ProcessorCardInfoData;
import mcjty.rftoolscontrol.modules.processor.data.ProcessorCoreData;
import mcjty.rftoolscontrol.modules.processor.data.ProcessorCraftingData;
import mcjty.rftoolscontrol.modules.processor.data.ProcessorEventData;
import mcjty.rftoolscontrol.modules.processor.data.ProcessorExtraData;
import mcjty.rftoolscontrol.modules.processor.data.ProcessorGraphicsOperationsData;
import mcjty.rftoolscontrol.modules.processor.data.ProcessorSettingsData;
import mcjty.rftoolscontrol.modules.processor.items.CPUCoreItem;
import mcjty.rftoolscontrol.modules.processor.items.GraphicsCardItem;
import mcjty.rftoolscontrol.modules.processor.items.NetworkCardItem;
import mcjty.rftoolscontrol.modules.processor.items.NetworkIdentifierItem;
import mcjty.rftoolscontrol.modules.processor.items.RAMChipItem;
import mcjty.rftoolscontrol.modules.processor.logic.LogicInventoryTools;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterSerializer;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTools;
import mcjty.rftoolscontrol.modules.processor.logic.TypeConverters;
import mcjty.rftoolscontrol.modules.processor.logic.compiled.CompiledCard;
import mcjty.rftoolscontrol.modules.processor.logic.compiled.CompiledEvent;
import mcjty.rftoolscontrol.modules.processor.logic.compiled.CompiledOpcode;
import mcjty.rftoolscontrol.modules.processor.logic.grid.ProgramCardInstance;
import mcjty.rftoolscontrol.modules.processor.logic.registry.Opcodes;
import mcjty.rftoolscontrol.modules.processor.logic.running.CpuCore;
import mcjty.rftoolscontrol.modules.processor.logic.running.ExceptionType;
import mcjty.rftoolscontrol.modules.processor.logic.running.ProgException;
import mcjty.rftoolscontrol.modules.processor.logic.running.RunningProgram;
import mcjty.rftoolscontrol.modules.processor.network.PacketGetFluids;
import mcjty.rftoolscontrol.modules.processor.util.CardInfo;
import mcjty.rftoolscontrol.modules.processor.util.Commands;
import mcjty.rftoolscontrol.modules.processor.util.QueuedEvent;
import mcjty.rftoolscontrol.modules.processor.util.WaitForItem;
import mcjty.rftoolscontrol.modules.processor.util.WatchInfo;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpBox;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpLine;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpText;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import mcjty.rftoolscontrol.modules.various.blocks.NodeTileEntity;
import mcjty.rftoolscontrol.modules.various.blocks.WorkbenchTileEntity;
import mcjty.rftoolscontrol.modules.various.data.TokenData;
import mcjty.rftoolscontrol.modules.various.items.TokenItem;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ProcessorTileEntity
extends TickingTileEntity
implements IProcessor {
    public static final int CARD_SLOTS = 6;
    public static final int ITEM_SLOTS = 24;
    public static final int EXPANSION_SLOTS = 16;
    public static final int MAXVARS = 32;
    public static final int MAXFLUIDVARS = 24;
    private static final BiFunction<ParameterType, Object, ItemStack> CONVERTOR_ITEM = TypeConverters::convertToItem;
    private static final BiFunction<ParameterType, Object, FluidStack> CONVERTOR_FLUID = TypeConverters::convertToFluid;
    private static final BiFunction<ParameterType, Object, BlockSide> CONVERTOR_SIDE = TypeConverters::convertToSide;
    private static final BiFunction<ParameterType, Object, Inventory> CONVERTOR_INVENTORY = TypeConverters::convertToInventory;
    private static final BiFunction<ParameterType, Object, Tuple> CONVERTOR_TUPLE = TypeConverters::convertToTuple;
    private static final BiFunction<ParameterType, Object, List<Parameter>> CONVERTOR_VECTOR = TypeConverters::convertToVector;
    private static final BiFunction<ParameterType, Object, Integer> CONVERTOR_INTEGER = TypeConverters::convertToInteger;
    private static final BiFunction<ParameterType, Object, Long> CONVERTOR_LONG = TypeConverters::convertToLong;
    private static final BiFunction<ParameterType, Object, String> CONVERTOR_STRING = TypeConverters::convertToString;
    private static final BiFunction<ParameterType, Object, Boolean> CONVERTOR_BOOL = TypeConverters::convertToBool;
    private static final BiFunction<ParameterType, Object, Number> CONVERTOR_NUMBER = TypeConverters::convertToNumber;
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, ProcessorContainer.CONTAINER_FACTORY).itemValid((slot, stack) -> {
        if (this.isExpansionSlot((int)slot)) {
            return this.isValidExpansionItem(stack.getItem());
        }
        if (this.isCardSlot((int)slot)) {
            return stack.getItem() == VariousModule.PROGRAM_CARD.get();
        }
        return true;
    }).onUpdate((slot, stack) -> this.onUpdateCard((int)slot)).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<ProcessorTileEntity, GenericItemHandler> ITEM_CAP = tile -> tile.items;
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)Config.processorMaxenergy.get()).intValue(), (long)((Integer)Config.processorReceivepertick.get()).intValue());
    @Cap(type=CapType.ENERGY)
    private static final Function<ProcessorTileEntity, GenericEnergyStorage> ENERGY_CAP = tile -> tile.energyStorage;
    @Cap(type=CapType.CONTAINER)
    private static final Function<ProcessorTileEntity, MenuProvider> SCREEN_CAP = tile -> new DefaultContainerProvider("Processor").containerSupplier((windowId, player) -> ProcessorContainer.create(windowId, tile.getBlockPos(), (GenericTileEntity)tile, player)).itemHandler(() -> tile.items).energyHandler(() -> tile.energyStorage).data(ProcessorModule.PROCESSOR_SETTINGS_DATA, ProcessorSettingsData.STREAM_CODEC, ProcessorSettingsData.CODEC).setupSync((GenericTileEntity)tile);
    private final List<CpuCore> cpuCores = new ArrayList<CpuCore>();
    @GuiValue
    public static final Value<ProcessorTileEntity, String> VALUE_HUD = Value.create((String)"hud", (Type)Type.STRING, s -> s.getShowHud().getName(), (s, val) -> s.setShowHud(HudMode.stringToMode(val)));
    @GuiValue
    public static final Value<ProcessorTileEntity, Boolean> VALUE_EXCLUSIVE = Value.create((String)"exclusive", (Type)Type.BOOLEAN, ProcessorTileEntity::isExclusive, ProcessorTileEntity::setExclusive);
    private boolean cardsDirty = true;
    private boolean coresDirty = true;
    private int maxVars = -1;
    private int hasNetworkCard = -1;
    private int storageCard = -2;
    private boolean hasGraphicsCard = false;
    private final Cached<List<Predicate<ItemStack>>> filterCaches = Cached.of(this::getFilterCaches);
    private List<String> orderedOps = null;
    private final List<GfxOp> clientGfxOps = new ArrayList<GfxOp>();
    private int prevIn = 0;
    private final int[] powerOut = new int[]{0, 0, 0, 0, 0, 0};
    private int fluidSlotsAvailable = -1;
    public long clientTime = 0L;
    private List<String> clientLog = new ArrayList<String>();
    private List<String> clientDebugLog = new ArrayList<String>();
    private ResourceKey<Level> dummyType = null;
    public static final Key<Integer> PARAM_CARD = new Key("card", Type.INTEGER);
    public static final Key<Integer> PARAM_ITEMS = new Key("items", Type.INTEGER);
    public static final Key<Integer> PARAM_VARS = new Key("vars", Type.INTEGER);
    public static final Key<Integer> PARAM_FLUID = new Key("fluids", Type.INTEGER);
    public static final Key<String> PARAM_CMD = new Key("cmd", Type.STRING);
    public static final Key<Boolean> PARAM_EXCLUSIVE = new Key("exclusive", Type.BOOLEAN);
    public static final Key<String> PARAM_HUDMODE = new Key("hudmode", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_ALLOCATE = Command.create((String)"allocate", (te, player, params) -> {
        int card = (Integer)params.get(PARAM_CARD);
        int itemAlloc = (Integer)params.get(PARAM_ITEMS);
        int varAlloc = (Integer)params.get(PARAM_VARS);
        int fluidAlloc = (Integer)params.get(PARAM_FLUID);
        te.allocate(card, itemAlloc, varAlloc, fluidAlloc);
    });
    @ServerCommand
    public static final Command<?> CMD_EXECUTE = Command.create((String)"execute", (te, player, params) -> Commands.executeCommand(te, (String)params.get(PARAM_CMD)));
    @ServerCommand
    public static final Command<?> CMD_SETEXCLUSIVE = Command.create((String)"setExclusive", (te, player, params) -> te.setExclusive((Boolean)params.get(PARAM_EXCLUSIVE)));
    @ServerCommand
    public static final Command<?> CMD_SETHUDMODE = Command.create((String)"setHudMode", (te, player, params) -> te.setShowHud(HudMode.stringToMode((String)params.get(PARAM_HUDMODE))));
    @ServerCommand(type=String.class)
    public static final ListCommand<?, ?> CMD_GETDEBUGLOG = ListCommand.create((String)"rftoolscontrol.processor.getDebugLog", (te, player, params) -> te.getDebugLog(), (te, player, params, list) -> {
        te.clientDebugLog = list;
    });
    @ServerCommand(type=String.class)
    public static final ListCommand<?, ?> CMD_GETLOG = ListCommand.create((String)"rftoolscontrol.processor.getLog", (te, player, params) -> te.getLog(), (te, player, params, list) -> {
        te.clientLog = list;
    });
    @ServerCommand(type=Parameter.class, serializer=ParameterSerializer.class)
    public static final ListCommand<?, ?> CMD_GETVARS = ListCommand.create((String)"rftoolscontrol.processor.getVars", (te, player, params) -> te.getVariables(), (te, player, params, list) -> GuiProcessor.storeVarsForClient(list));
    @ServerCommand(type=PacketGetFluids.FluidEntry.class, serializer=PacketGetFluids.FluidEntry.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETFLUIDS = ListCommand.create((String)"rftoolscontrol.processor.getFluids", (te, player, params) -> te.getFluids(), (te, player, params, list) -> GuiProcessor.storeFluidsForClient(list));

    public ProcessorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ProcessorModule.PROCESSOR.be().get(), pos, state);
    }

    public ProcessorTileEntity(ResourceKey<Level> type, BlockPos pos) {
        this(pos, null);
        this.dummyType = type;
    }

    public ProcessorCoreData getCoreData() {
        return (ProcessorCoreData)this.getData(ProcessorModule.PROCESSOR_CORE_DATA.get());
    }

    public ProcessorCardInfoData getCardInfoData() {
        return (ProcessorCardInfoData)this.getData(ProcessorModule.PROCESSOR_CARD_INFO_DATA.get());
    }

    public ProcessorGraphicsOperationsData getGraphicsOperationsData() {
        return (ProcessorGraphicsOperationsData)this.getData(ProcessorModule.PROCESSOR_GRAPHICS_DATA.get());
    }

    public ProcessorEventData getEventData() {
        return (ProcessorEventData)this.getData(ProcessorModule.PROCESSOR_EVENTS_DATA.get());
    }

    private Queue<QueuedEvent> getEventQueue() {
        return this.getEventData().queuedEvents();
    }

    private void setEventQueue(Queue<QueuedEvent> queue) {
        ProcessorEventData data = this.getEventData();
        this.setData(ProcessorModule.PROCESSOR_EVENTS_DATA.get(), data.withQueuedEvents(queue));
    }

    private void clearEventQueue() {
        ProcessorEventData data = this.getEventData();
        if (!data.queuedEvents().isEmpty()) {
            this.setData(ProcessorModule.PROCESSOR_EVENTS_DATA.get(), data.withQueuedEvents(new ArrayDeque<QueuedEvent>()));
        }
    }

    private void filterEventQueue(Predicate<QueuedEvent> predicate) {
        ProcessorEventData data = this.getEventData();
        Queue filtered = data.queuedEvents().stream().filter(predicate).collect(Collectors.toCollection(ArrayDeque::new));
        if (filtered.size() != data.queuedEvents().size()) {
            this.setData(ProcessorModule.PROCESSOR_EVENTS_DATA.get(), data.withQueuedEvents(filtered));
        }
    }

    private boolean isEventRunning(int cardIndex, int eventIndex) {
        return this.getEventData().runningEvents().contains(Pair.of((Object)cardIndex, (Object)eventIndex));
    }

    private void addRunningEvent(int cardIndex, int eventIndex) {
        Pair key = Pair.of((Object)cardIndex, (Object)eventIndex);
        ProcessorEventData data = this.getEventData();
        if (!data.runningEvents().contains(key)) {
            HashSet<Pair<Integer, Integer>> updated = new HashSet<Pair<Integer, Integer>>(data.runningEvents());
            updated.add((Pair<Integer, Integer>)key);
            this.setData(ProcessorModule.PROCESSOR_EVENTS_DATA.get(), data.withRunningEvents(updated));
        }
    }

    private void removeRunningEvent(int cardIndex, int eventIndex) {
        Pair key = Pair.of((Object)cardIndex, (Object)eventIndex);
        ProcessorEventData data = this.getEventData();
        if (data.runningEvents().contains(key)) {
            HashSet<Pair<Integer, Integer>> updated = new HashSet<Pair<Integer, Integer>>(data.runningEvents());
            updated.remove(key);
            this.setData(ProcessorModule.PROCESSOR_EVENTS_DATA.get(), data.withRunningEvents(updated));
        }
    }

    private void retainRunningEvents(Predicate<Pair<Integer, Integer>> predicate) {
        ProcessorEventData data = this.getEventData();
        Set filtered = data.runningEvents().stream().filter(predicate).collect(Collectors.toCollection(HashSet::new));
        if (filtered.size() != data.runningEvents().size()) {
            this.setData(ProcessorModule.PROCESSOR_EVENTS_DATA.get(), data.withRunningEvents(filtered));
        }
    }

    private void clearRunningEvents() {
        ProcessorEventData data = this.getEventData();
        if (!data.runningEvents().isEmpty()) {
            this.setData(ProcessorModule.PROCESSOR_EVENTS_DATA.get(), data.withRunningEvents(new HashSet<Pair<Integer, Integer>>()));
        }
    }

    private List<WaitForItem> getWaitingForItems() {
        return this.getCraftingData().waitingForItems();
    }

    private void setWaitingForItems(List<WaitForItem> waitingForItems) {
        ProcessorCraftingData data = this.getCraftingData();
        this.setData(ProcessorModule.PROCESSOR_CRAFTING_DATA.get(), data.withWaitingForItems(waitingForItems));
    }

    private Set<BlockPos> getCraftingStations() {
        return this.getCraftingData().craftingStations();
    }

    private void setCraftingStations(Set<BlockPos> stations) {
        ProcessorCraftingData data = this.getCraftingData();
        this.setData(ProcessorModule.PROCESSOR_CRAFTING_DATA.get(), data.withCraftingStations(stations));
    }

    private void addWaitingForItem(WaitForItem waitForItem) {
        ProcessorCraftingData data = this.getCraftingData();
        ArrayList<WaitForItem> updated = new ArrayList<WaitForItem>(data.waitingForItems());
        updated.add(waitForItem);
        this.setData(ProcessorModule.PROCESSOR_CRAFTING_DATA.get(), data.withWaitingForItems(updated));
    }

    private void removeWaitingForItem(int index) {
        ProcessorCraftingData data = this.getCraftingData();
        ArrayList<WaitForItem> updated = new ArrayList<WaitForItem>(data.waitingForItems());
        if (index >= 0 && index < updated.size()) {
            updated.remove(index);
            this.setData(ProcessorModule.PROCESSOR_CRAFTING_DATA.get(), data.withWaitingForItems(updated));
        }
    }

    private void clearWaitingForItems() {
        if (!this.getWaitingForItems().isEmpty()) {
            this.setWaitingForItems(new ArrayList<WaitForItem>());
        }
    }

    private List<CardInfo> getCardInfos() {
        ProcessorCardInfoData data = this.getCardInfoData();
        List<CardInfo> infos = data.infos();
        if (infos.size() != 6) {
            ArrayList<CardInfo> adjusted = new ArrayList<CardInfo>(infos);
            if (adjusted.size() > 6) {
                adjusted = new ArrayList(adjusted.subList(0, 6));
            }
            while (adjusted.size() < 6) {
                adjusted.add(new CardInfo());
            }
            ProcessorCardInfoData updated = data.withInfos(List.copyOf(adjusted));
            this.setData(ProcessorModule.PROCESSOR_CARD_INFO_DATA.get(), updated);
            infos = updated.infos();
        }
        return infos;
    }

    private void setCardInfos(List<CardInfo> infos) {
        ArrayList<CardInfo> adjusted = new ArrayList<CardInfo>(infos);
        if (adjusted.size() > 6) {
            adjusted = new ArrayList(adjusted.subList(0, 6));
        }
        while (adjusted.size() < 6) {
            adjusted.add(new CardInfo());
        }
        ProcessorCardInfoData updated = this.getCardInfoData().withInfos(List.copyOf(adjusted));
        this.setData(ProcessorModule.PROCESSOR_CARD_INFO_DATA.get(), updated);
    }

    private void updateCardInfos(Consumer<List<CardInfo>> consumer) {
        ArrayList<CardInfo> infos = new ArrayList<CardInfo>(this.getCardInfos());
        consumer.accept(infos);
        this.setCardInfos(infos);
    }

    private int getTickCount() {
        return this.getCoreData().tickCount();
    }

    private void incTickCount() {
        ProcessorCoreData cd = this.getCoreData();
        this.setData(ProcessorModule.PROCESSOR_CORE_DATA.get(), cd.withTickCount(cd.tickCount() + 1));
    }

    @Nullable
    public WatchInfo getWatchInfoAt(int idx) {
        return this.getCoreData().watchInfoAt(idx);
    }

    private int getLocksSize() {
        return this.getCoreData().locks().size();
    }

    private void clearLocks() {
        ProcessorCoreData cd = this.getCoreData();
        if (!cd.locks().isEmpty()) {
            this.setData(ProcessorModule.PROCESSOR_CORE_DATA.get(), cd.withLocks(Set.of()));
        }
    }

    private void addLock(String name) {
        ProcessorCoreData cd = this.getCoreData();
        ProcessorCoreData updated = cd.withLockAdded(name);
        if (updated != cd) {
            this.setData(ProcessorModule.PROCESSOR_CORE_DATA.get(), updated);
        }
    }

    public ProcessorCraftingData getCraftingData() {
        return (ProcessorCraftingData)this.getData(ProcessorModule.PROCESSOR_CRAFTING_DATA.get());
    }

    public ProcessorExtraData getExtraData() {
        return (ProcessorExtraData)this.getData(ProcessorModule.PROCESSOR_EXTRA_DATA.get());
    }

    public ProcessorSettingsData getSettingsData() {
        return (ProcessorSettingsData)this.getData(ProcessorModule.PROCESSOR_SETTINGS_DATA.get());
    }

    public boolean isDummy() {
        return this.dummyType != null;
    }

    public ResourceKey<Level> getDimension() {
        if (this.dummyType != null) {
            return this.dummyType;
        }
        return super.getDimension();
    }

    public boolean isExclusive() {
        return this.getSettingsData().exclusive();
    }

    public void setExclusive(boolean exclusive) {
        ProcessorSettingsData data = this.getSettingsData();
        if (data.exclusive() != exclusive) {
            this.setData(ProcessorModule.PROCESSOR_SETTINGS_DATA.get(), data.withExclusive(exclusive));
        }
    }

    public Parameter getVariableAt(int idx) {
        return this.getCoreData().variableAt(idx);
    }

    public void setVariableAt(int idx, Parameter parameter) {
        ProcessorCoreData cd = this.getCoreData();
        ProcessorCoreData updated = cd.withVariable(idx, parameter);
        if (updated != cd) {
            this.setData(ProcessorModule.PROCESSOR_CORE_DATA.get(), updated);
        }
    }

    public boolean isFluidSlotAvailable(int idx) {
        int sideIndex = idx / 4;
        return (this.getFluidSlotsAvailable() & 1 << sideIndex) != 0;
    }

    private BlockPos getAdjacentPosition(@Nonnull BlockSide side) {
        BlockPos p;
        if (side.getNodeName() != null && !side.getNodeName().isEmpty()) {
            Map<String, BlockPos> nodes = this.getExtraData().networkNodes();
            p = nodes.get(side.getNodeName());
            if (p == null) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNODE);
            }
            BlockEntity te = this.level.getBlockEntity(p);
            if (!(te instanceof NodeTileEntity)) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNODE);
            }
        } else {
            p = this.worldPosition;
        }
        return p;
    }

    public int readRedstoneIn(@Nonnull BlockSide side) {
        Direction facing = side.getSide();
        BlockPos p = this.getAdjacentPosition(side);
        if (p == null) {
            return 0;
        }
        return this.level.getSignal(p.relative(facing), facing);
    }

    public void setPowerOut(@Nonnull BlockSide side, int amount) {
        Direction facing = side.getSide();
        BlockPos p = this.getAdjacentPosition(side);
        if (p == null) {
            return;
        }
        if (amount < 0) {
            amount = 0;
        } else if (amount > 15) {
            amount = 15;
        }
        if (p.equals((Object)this.worldPosition)) {
            this.powerOut[facing.ordinal()] = amount;
            this.setChanged();
            this.level.neighborChanged(this.worldPosition.relative(facing), this.getBlockState().getBlock(), this.worldPosition);
        } else {
            NodeTileEntity te = (NodeTileEntity)this.level.getBlockEntity(p);
            te.setPowerOut(facing, amount);
        }
    }

    public int getPowerOut(Direction side) {
        return this.powerOut[side.ordinal()];
    }

    public void tickServer() {
        this.process();
        this.prevIn = this.powerLevel;
    }

    private void process() {
        this.incTickCount();
        this.setChanged();
        this.updateCores();
        this.compileCards((HolderLookup.Provider)this.level.registryAccess());
        this.processEventQueue();
        try {
            this.handleEvents();
        }
        catch (ProgException e) {
            this.exception(e.getExceptionType(), null);
        }
        this.run();
    }

    private void processEventQueue() {
        Queue<QueuedEvent> queue = this.getEventQueue();
        QueuedEvent queuedEvent = queue.peek();
        if (queuedEvent != null) {
            CompiledEvent compiledEvent = queuedEvent.compiledEvent();
            if (compiledEvent.single() && this.isEventRunning(queuedEvent.cardIndex(), compiledEvent.index())) {
                return;
            }
            CpuCore core = this.findAvailableCore(queuedEvent.cardIndex());
            if (core != null) {
                ArrayDeque<QueuedEvent> newQueue = new ArrayDeque<QueuedEvent>(queue);
                newQueue.remove();
                this.setEventQueue(newQueue);
                RunningProgram program = new RunningProgram(queuedEvent.cardIndex());
                program.startFromEvent(compiledEvent);
                program.setCraftTicket(queuedEvent.ticket());
                program.setLastValue((IParameter)queuedEvent.parameter());
                core.startProgram(program);
                if (compiledEvent.single()) {
                    this.addRunningEvent(queuedEvent.cardIndex(), compiledEvent.index());
                }
            }
        }
    }

    public void getCraftableItems(List<ItemStack> stacks) {
        try {
            for (CardInfo info : this.getCardInfos()) {
                CompiledCard compiledCard = info.getCompiledCard();
                if (compiledCard == null) continue;
                for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_CRAFT)) {
                    int index = event.index();
                    CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                    ItemStack stack = this.evaluateItemParameter(compiledOpcode, null, 0);
                    Inventory inv = this.evaluateInventoryParameter(compiledOpcode, null, 1);
                    if (!stack.isEmpty() && inv != null) {
                        throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
                    }
                    if (stack.isEmpty() && inv == null) {
                        throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
                    }
                    if (!stack.isEmpty()) {
                        stacks.add(stack);
                        continue;
                    }
                    IItemHandler handler = this.getItemHandlerAt(inv);
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack result;
                        ItemStack s = handler.getStackInSlot(i);
                        if (s.isEmpty() || s.getItem() != RFToolsStuff.CRAFTING_CARD.get() || (result = CraftingCardItem.getResult((ItemStack)s)).isEmpty()) continue;
                        stacks.add(result);
                    }
                }
            }
        }
        catch (ProgException e) {
            this.exception(e.getExceptionType(), null);
        }
    }

    public void craftOk(IProgram program, @Nullable Integer slot) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        String ticket = program.getCraftTicket();
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        Integer realSlot = info.getRealSlot(slot);
        ItemStack craftedItem = ItemStack.EMPTY;
        if (realSlot != null) {
            craftedItem = this.items.getStackInSlot(realSlot.intValue());
        }
        for (BlockPos p : this.getCraftingStations()) {
            BlockEntity te = this.level.getBlockEntity(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            craftedItem = craftingStation.craftOk(this, ticket, craftedItem);
        }
        if (realSlot != null) {
            this.items.setStackInSlot(realSlot.intValue(), craftedItem);
        }
    }

    public void craftFail(IProgram program) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        String ticket = program.getCraftTicket();
        for (BlockPos p : this.getCraftingStations()) {
            BlockEntity te = this.level.getBlockEntity(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            craftingStation.craftFail(ticket);
        }
    }

    public boolean pushItemsWorkbench(IProgram program, @Nonnull BlockSide workbench, ItemStack item, int slot1, int slot2) {
        if (item.isEmpty()) {
            item = this.getCraftResult(program);
        }
        if (item.isEmpty()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        BlockEntity te = this.getTileEntityAt(workbench);
        if (!(te instanceof WorkbenchTileEntity)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTAWORKBENCH);
        }
        ItemStack finalItem = item;
        ItemStack card = this.findCraftingCard(this.getItemHandlerAt(te, Direction.EAST), finalItem);
        if (card.isEmpty()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        if (!CraftingCardItem.fitsGrid((ItemStack)card)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTAGRID);
        }
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        GenericItemHandler itemHandler = this.items;
        IItemHandler gridHandler = this.getItemHandlerAt(te, Direction.UP);
        List ingredients = CraftingCardItem.getIngredientsGrid((ItemStack)card);
        boolean success = true;
        for (int i = 0; i < 9; ++i) {
            ItemStack stackInWorkbench = gridHandler.getStackInSlot(i);
            Ingredient stackInIngredient = (Ingredient)ingredients.get(i);
            if (!stackInWorkbench.isEmpty() && stackInIngredient.isEmpty()) {
                success = false;
                continue;
            }
            if (stackInWorkbench.isEmpty() && !stackInIngredient.isEmpty()) {
                boolean found = false;
                for (int slot = slot1; slot <= slot2; ++slot) {
                    int realSlot = info.getRealSlot(slot);
                    ItemStack localStack = itemHandler.getStackInSlot(realSlot);
                    if (!stackInIngredient.test(localStack)) continue;
                    localStack = itemHandler.extractItem(realSlot, LogicInventoryTools.getCountFromIngredient(stackInIngredient), false);
                    gridHandler.insertItem(i, localStack, false);
                    found = true;
                    break;
                }
                if (found) continue;
                success = false;
                continue;
            }
            if (stackInWorkbench.isEmpty() || stackInIngredient.isEmpty()) continue;
            if (!stackInIngredient.test(stackInWorkbench)) {
                success = false;
                continue;
            }
            if (LogicInventoryTools.getCountFromIngredient(stackInIngredient) <= stackInWorkbench.getCount()) continue;
            success = false;
        }
        return success;
    }

    public int pushItemsMulti(IProgram program, @Nullable Inventory inv, int slot1, int slot2, @Nullable Integer extSlot) {
        IItemHandler handler = this.getHandlerForInv(inv);
        IStorageScanner scanner = this.getScannerForInv(inv);
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int e = 0;
        if (extSlot != null) {
            e = extSlot;
        }
        int failed = 0;
        for (int slot = slot1; slot <= slot2; ++slot) {
            int realSlot = info.getRealSlot(slot);
            ItemStack stack = this.items.getStackInSlot(realSlot);
            if (!stack.isEmpty()) {
                ItemStack remaining = LogicInventoryTools.insertItem(handler, scanner, stack, extSlot == null ? null : Integer.valueOf(e));
                if (!remaining.isEmpty()) {
                    ++failed;
                }
                this.items.setStackInSlot(realSlot, remaining);
            }
            ++e;
        }
        return failed;
    }

    public int countCardIngredients(IProgram program, @Nullable Inventory inv, ItemStack card) {
        IItemHandler handler = this.getHandlerForInv(inv);
        IStorageScanner scanner = this.getScannerForInv(inv);
        List ingredients = CraftingCardItem.getIngredients((ItemStack)card);
        List<Ingredient> needed = this.combineIngredients(ingredients);
        return this.countPossibleCrafts(scanner, handler, needed);
    }

    public boolean checkIngredients(IProgram program, @Nonnull Inventory cardInv, ItemStack item, int slot1, int slot2) {
        if (item.isEmpty()) {
            item = this.getCraftResult(program);
        }
        if (item.isEmpty()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        ItemStack finalItem = item;
        ItemStack card = this.findCraftingCard(this.getItemHandlerAt(cardInv), finalItem);
        if (card.isEmpty()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int slot = slot1;
        List ingredients = CraftingCardItem.fitsGrid((ItemStack)card) && slot2 - slot1 >= 8 ? CraftingCardItem.getIngredientsGrid((ItemStack)card) : CraftingCardItem.getIngredients((ItemStack)card);
        boolean failed = false;
        for (Ingredient ingredient : ingredients) {
            int realSlot = info.getRealSlot(slot);
            ItemStack localStack = this.items.getStackInSlot(realSlot);
            if (!ingredient.isEmpty()) {
                if (!ingredient.test(localStack)) {
                    return false;
                }
                if (LogicInventoryTools.getCountFromIngredient(ingredient) != localStack.getCount()) {
                    return false;
                }
            } else if (!localStack.isEmpty()) {
                return false;
            }
            ++slot;
        }
        return true;
    }

    public int getIngredientsSmart(IProgram program, Inventory inv, @Nonnull Inventory cardInv, ItemStack inputStack, int slot1, int slot2, @Nonnull Inventory destInv) {
        IItemHandler handler = this.getHandlerForInv(inv);
        IStorageScanner scanner = this.getScannerForInv(inv);
        ItemStack item = inputStack;
        if (item.isEmpty()) {
            item = this.getCraftResult(program);
        }
        if (item.isEmpty()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        ItemStack finalItem = item;
        IItemHandler destHandler = this.getHandlerForInv(destInv);
        if (destHandler == null) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY);
        }
        ItemStack card = this.findCraftingCard(this.getItemHandlerAt(cardInv), finalItem);
        if (card.isEmpty()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        List ingredients = CraftingCardItem.fitsGrid((ItemStack)card) && slot2 - slot1 >= 8 ? CraftingCardItem.getIngredientsGrid((ItemStack)card) : CraftingCardItem.getIngredients((ItemStack)card);
        List<Ingredient> needed = this.combineIngredients(ingredients);
        int requested = this.checkAvailableItemsAndRequestMissing(destInv, scanner, handler, needed);
        if (requested != 0) {
            return requested;
        }
        int slot = slot1;
        for (Ingredient ingredient : ingredients) {
            ItemStack stack;
            int realSlot = info.getRealSlot(slot);
            if (!ingredient.isEmpty() && !(stack = LogicInventoryTools.extractItem(handler, scanner, LogicInventoryTools.getCountFromIngredient(ingredient), true, ingredient, null)).isEmpty()) {
                this.items.insertItem(realSlot, stack, false);
            }
            ++slot;
        }
        return 0;
    }

    private int checkAvailableItemsAndRequestMissing(Inventory destInv, IStorageScanner scanner, IItemHandler handler, List<Ingredient> needed) {
        int requested = 0;
        for (Ingredient ingredient : needed) {
            int countFromIngredient;
            int cnt;
            if (ingredient.isEmpty() || (cnt = LogicInventoryTools.countItem(handler, scanner, ingredient, countFromIngredient = LogicInventoryTools.getCountFromIngredient(ingredient))) >= countFromIngredient) continue;
            ++requested;
            if (this.isRequested(ingredient) || this.requestCraft(ingredient, destInv)) continue;
            return -1;
        }
        return requested;
    }

    private int countPossibleCrafts(IStorageScanner scanner, IItemHandler handler, List<Ingredient> needed) {
        int maxPossible = Integer.MAX_VALUE;
        for (Ingredient ingredient : needed) {
            int cnt;
            int possible;
            if (ingredient.isEmpty() || (possible = (cnt = LogicInventoryTools.countItem(handler, scanner, ingredient, -1)) / LogicInventoryTools.getCountFromIngredient(ingredient)) >= maxPossible) continue;
            maxPossible = possible;
        }
        return maxPossible;
    }

    private List<Ingredient> combineIngredients(List<Ingredient> ingredients) {
        ArrayList<Ingredient> needed = new ArrayList<Ingredient>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            boolean found = false;
            for (int i = 0; i < needed.size(); ++i) {
                Ingredient neededStack = (Ingredient)needed.get(i);
                if (!this.testIngredientEquality(ingredient, neededStack)) continue;
                needed.set(i, this.combine(ingredient, neededStack));
                found = true;
                break;
            }
            if (found) continue;
            needed.add(ingredient);
        }
        return needed;
    }

    private boolean testIngredientEquality(Ingredient i1, Ingredient i2) {
        ItemStack[] items2;
        ItemStack[] items1;
        if (i1.isSimple() && i2.isSimple() && (items1 = i1.getItems()).length == (items2 = i2.getItems()).length) {
            for (int i = 0; i < items1.length; ++i) {
                if (ItemStack.isSameItemSameComponents((ItemStack)items1[i], (ItemStack)items2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Ingredient combine(Ingredient i1, Ingredient i2) {
        ItemStack[] items2;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack[] items1 = i1.getItems();
        if (items1.length == (items2 = i2.getItems()).length) {
            for (int i = 0; i < items1.length; ++i) {
                ItemStack copy = items1[i].copy();
                copy.grow(items2[i].getCount());
                list.add(copy);
            }
        }
        return Ingredient.of((ItemStack[])list.toArray(new ItemStack[list.size()]));
    }

    public int getIngredients(IProgram program, Inventory inv, Inventory cardInv, ItemStack inputStack, int slot1, int slot2) {
        IItemHandler handler = this.getHandlerForInv(inv);
        IStorageScanner scanner = this.getScannerForInv(inv);
        ItemStack item = inputStack;
        if (item.isEmpty()) {
            item = this.getCraftResult(program);
        }
        if (item.isEmpty()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        ItemStack finalItem = item;
        ItemStack card = this.findCraftingCard(this.getItemHandlerAt(cardInv), finalItem);
        if (card.isEmpty()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int slot = slot1;
        List ingredients = CraftingCardItem.fitsGrid((ItemStack)card) && slot2 - slot1 >= 8 ? CraftingCardItem.getIngredientsGrid((ItemStack)card) : CraftingCardItem.getIngredients((ItemStack)card);
        int failed = 0;
        for (Ingredient ingredient : ingredients) {
            int realSlot = info.getRealSlot(slot);
            if (!ingredient.isEmpty()) {
                ItemStack stack = LogicInventoryTools.extractItem(handler, scanner, LogicInventoryTools.getCountFromIngredient(ingredient), true, ingredient, null);
                if (!stack.isEmpty()) {
                    ItemStack remainder = this.items.insertItem(realSlot, stack, false);
                    if (!remainder.isEmpty()) {
                        LogicInventoryTools.insertItem(handler, scanner, remainder, null);
                    }
                } else {
                    ++failed;
                }
            }
            ++slot;
        }
        return failed;
    }

    public void craftWait(IProgram program, @Nonnull Inventory inv, ItemStack stack) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        if (stack.isEmpty() && (stack = this.getCraftResult(program)).isEmpty()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        WaitForItem waitForItem = new WaitForItem(program.getCraftTicket(), stack, inv);
        this.addWaitingForItem(waitForItem);
        this.setChanged();
    }

    public void craftWaitTimed(IProgram program) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        WaitForItem waitForItem = new WaitForItem(program.getCraftTicket(), ItemStack.EMPTY, null);
        this.addWaitingForItem(waitForItem);
        this.setChanged();
    }

    public boolean isRequested(Ingredient ingredient) {
        for (BlockPos p : this.getCraftingStations()) {
            BlockEntity te = this.level.getBlockEntity(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            return craftingStation.isRequested(ingredient);
        }
        throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGSTATION);
    }

    public boolean requestCraft(@Nonnull Ingredient ingredient, @Nullable Inventory inventory) {
        for (BlockPos p : this.getCraftingStations()) {
            BlockEntity te = this.level.getBlockEntity(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            return craftingStation.request(ingredient, inventory);
        }
        throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGSTATION);
    }

    public void setCraftTicket(IProgram program, String ticket) {
        ((RunningProgram)program).setCraftTicket(ticket);
    }

    public ItemStack getItemFromCard(IProgram program) {
        Parameter lastValue = (Parameter)program.getLastValue();
        if (lastValue == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGLASTVALUE);
        }
        ItemStack itemStack = TypeConverters.convertToItem((IParameter)lastValue);
        if (itemStack.isEmpty()) {
            throw new ProgException(ExceptionType.EXCEPT_NOTANITEM);
        }
        if (itemStack.getItem() instanceof CraftingCardItem) {
            return CraftingCardItem.getResult((ItemStack)itemStack);
        }
        if (itemStack.getItem() instanceof TokenItem) {
            TokenData token = (TokenData)itemStack.get(VariousModule.TOKEN_DATA);
            if (token == null) {
                return ItemStack.EMPTY;
            }
            return TypeConverters.convertToItem((IParameter)token.parameter());
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getCraftResult(IProgram program) {
        if (!program.hasCraftTicket()) {
            return ItemStack.EMPTY;
        }
        for (BlockPos p : this.getCraftingStations()) {
            CraftingStationTileEntity craftingStation;
            ItemStack stack;
            BlockEntity te = this.level.getBlockEntity(p);
            if (!(te instanceof CraftingStationTileEntity) || (stack = (craftingStation = (CraftingStationTileEntity)te).getCraftResult(program.getCraftTicket())).isEmpty()) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack findCraftingCard(IProgram program, Inventory inventory, ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        IItemHandler handler = this.getHandlerForInv(inventory);
        if (handler == null) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY);
        }
        return this.findCraftingCard(handler, stack);
    }

    private ItemStack findCraftingCard(IItemHandler handler, ItemStack craftResult) {
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack result;
            ItemStack s = handler.getStackInSlot(j);
            if (s.isEmpty() || s.getItem() != RFToolsStuff.CRAFTING_CARD.get() || (result = CraftingCardItem.getResult((ItemStack)s)).isEmpty() || !LogicInventoryTools.areItemsEqual(result, craftResult, true, true)) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }

    public void fireCraftEvent(String ticket, ItemStack stackToCraft) {
        List<CardInfo> cardInfos = this.getCardInfos();
        for (int i = 0; i < cardInfos.size(); ++i) {
            CardInfo info = cardInfos.get(i);
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_CRAFT)) {
                ItemStack craftingCard;
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                ItemStack stack = this.evaluateItemParameter(compiledOpcode, null, 0);
                Inventory inv = this.evaluateInventoryParameter(compiledOpcode, null, 1);
                if (!stack.isEmpty()) {
                    if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)stackToCraft)) continue;
                    this.runOrQueueEvent(i, event, ticket, null);
                    return;
                }
                if (inv == null || (craftingCard = this.findCraftingCard(this.getItemHandlerAt(inv), stackToCraft)).isEmpty()) continue;
                this.runOrQueueEvent(i, event, ticket, null);
                return;
            }
        }
    }

    private void handleEvents() {
        List<CardInfo> cardInfos = this.getCardInfos();
        for (int i = 0; i < cardInfos.size(); ++i) {
            CardInfo info = cardInfos.get(i);
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            this.handleEventsRedstoneOn(i, compiledCard);
            this.handleEventsRedstoneOff(i, compiledCard);
            this.handleEventsTimer(i, compiledCard);
            this.handleEventsCraftResume(i, compiledCard);
        }
    }

    private void handleEventsCraftResume(int cardIndex, CompiledCard compiledCard) {
        for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_CRAFTRESUME)) {
            List<WaitForItem> waiting;
            int index = event.index();
            CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
            int ticks = this.evaluateIntParameter(compiledOpcode, null, 0);
            if (ticks <= 0 || this.getTickCount() % ticks != 0 || (waiting = this.getWaitingForItems()).isEmpty()) continue;
            WaitForItem found = null;
            int foundIdx = -1;
            for (int i = 0; i < waiting.size(); ++i) {
                WaitForItem wfi = waiting.get(i);
                if (wfi.inventory() == null || wfi.itemStack().isEmpty()) {
                    foundIdx = i;
                    found = wfi;
                    break;
                }
                int cnt = this.countItemInHandler(wfi.itemStack(), this.getItemHandlerAt(wfi.inventory()));
                if (cnt < wfi.itemStack().getCount()) continue;
                foundIdx = i;
                found = wfi;
                break;
            }
            if (found == null) continue;
            this.removeWaitingForItem(foundIdx);
            this.runOrQueueEvent(cardIndex, event, found.ticket(), null);
        }
    }

    private void handleEventsTimer(int i, CompiledCard compiledCard) {
        for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_TIMER)) {
            int index = event.index();
            CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
            int ticks = this.evaluateIntParameter(compiledOpcode, null, 0);
            if (ticks <= 0 || this.getTickCount() % ticks != 0) continue;
            this.runOrDropEvent(i, event, null, null);
        }
    }

    private void handleEventsRedstoneOff(int i, CompiledCard compiledCard) {
        int redstoneOffMask = this.prevIn & ~this.powerLevel;
        if (redstoneOffMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_OFF)) {
                Direction facing;
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side != null && side.hasNodeName()) continue;
                Direction direction = facing = side == null ? null : side.getSide();
                if (facing != null && (redstoneOffMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    private void handleEventsRedstoneOn(int i, CompiledCard compiledCard) {
        int redstoneOnMask = this.powerLevel & ~this.prevIn;
        if (redstoneOnMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_ON)) {
                Direction facing;
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side != null && side.hasNodeName()) continue;
                Direction direction = facing = side == null ? null : side.getSide();
                if (facing != null && (redstoneOnMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    private void handleEventsRedstoneOff(int i, CompiledCard compiledCard, String node, int prevMask, int newMask) {
        int redstoneOffMask = prevMask & ~newMask;
        if (redstoneOffMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_OFF)) {
                Direction facing;
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side == null || !node.equals(side.getNodeName()) || (facing = side.getSide()) != null && (redstoneOffMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    private void handleEventsRedstoneOn(int i, CompiledCard compiledCard, String node, int prevMask, int newMask) {
        int redstoneOnMask = newMask & ~prevMask;
        if (redstoneOnMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_ON)) {
                Direction facing;
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side == null || !node.equals(side.getNodeName()) || (facing = side.getSide()) != null && (redstoneOnMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    public void clearRunningEvent(int cardIndex, int eventIndex) {
        this.removeRunningEvent(cardIndex, eventIndex);
    }

    private void runOrDropEvent(int cardIndex, CompiledEvent event, @Nullable String ticket, @Nullable Parameter parameter) {
        if (event.single() && this.isEventRunning(cardIndex, event.index())) {
            return;
        }
        CpuCore core = this.findAvailableCore(cardIndex);
        if (core == null) {
            for (QueuedEvent q : this.getEventQueue()) {
                if (q.cardIndex() != cardIndex || !q.compiledEvent().equals(event)) continue;
                return;
            }
            this.queueEvent(cardIndex, event, ticket, parameter);
        } else {
            RunningProgram program = new RunningProgram(cardIndex);
            program.startFromEvent(event);
            program.setCraftTicket(ticket);
            program.setLastValue((IParameter)parameter);
            core.startProgram(program);
            if (event.single()) {
                this.addRunningEvent(cardIndex, event.index());
            }
        }
    }

    private void runOrQueueEvent(int cardIndex, CompiledEvent event, @Nullable String ticket, @Nullable Parameter parameter) {
        if (event.single() && this.isEventRunning(cardIndex, event.index())) {
            this.queueEvent(cardIndex, event, ticket, parameter);
            return;
        }
        CpuCore core = this.findAvailableCore(cardIndex);
        if (core == null) {
            this.queueEvent(cardIndex, event, ticket, parameter);
        } else {
            RunningProgram program = new RunningProgram(cardIndex);
            program.startFromEvent(event);
            program.setCraftTicket(ticket);
            program.setLastValue((IParameter)parameter);
            core.startProgram(program);
            if (event.single()) {
                this.addRunningEvent(cardIndex, event.index());
            }
        }
    }

    private void queueEvent(int cardIndex, CompiledEvent event, @Nullable String ticket, @Nullable Parameter parameter) {
        Queue<QueuedEvent> currentQueue = this.getEventQueue();
        if (currentQueue.size() >= (Integer)Config.maxEventQueueSize.get()) {
            throw new ProgException(ExceptionType.EXCEPT_TOOMANYEVENTS);
        }
        ArrayDeque<QueuedEvent> updatedQueue = new ArrayDeque<QueuedEvent>(currentQueue);
        updatedQueue.add(new QueuedEvent(cardIndex, event, ticket, parameter));
        this.setEventQueue(updatedQueue);
    }

    public int signal(String signal) {
        int cnt = 0;
        List<CardInfo> cardInfos = this.getCardInfos();
        for (int i = 0; i < cardInfos.size(); ++i) {
            CardInfo info = cardInfos.get(i);
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_SIGNAL)) {
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                String sig = this.evaluateStringParameter(compiledOpcode, null, 0);
                if (!signal.equals(sig)) continue;
                this.runOrQueueEvent(i, event, null, null);
                ++cnt;
            }
        }
        return cnt;
    }

    public int signal(Tuple location) {
        int cnt = 0;
        List<CardInfo> cardInfos = this.getCardInfos();
        for (int i = 0; i < cardInfos.size(); ++i) {
            CardInfo info = cardInfos.get(i);
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_GFX_SELECT)) {
                this.runOrQueueEvent(i, event, null, Parameter.builder().type(ParameterType.PAR_TUPLE).value(ParameterValue.constant((Object)location)).build());
                ++cnt;
            }
        }
        return cnt;
    }

    public void receiveMessage(String name, @Nullable Parameter value) {
        List<CardInfo> cardInfos = this.getCardInfos();
        for (int i = 0; i < cardInfos.size(); ++i) {
            CardInfo info = cardInfos.get(i);
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_MESSAGE)) {
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                String messageName = this.evaluateStringParameter(compiledOpcode, null, 0);
                if (!name.equals(messageName)) continue;
                this.runOrQueueEvent(i, event, null, value);
            }
        }
    }

    private String getStatus(int c) {
        String db;
        CpuCore core = this.cpuCores.get(c);
        String string = db = core.isDebug() ? "[DB] " : "";
        if (core.hasProgram()) {
            RunningProgram program = core.getProgram();
            if (program.getDelay() > 0) {
                return db + "<delayed: " + program.getDelay() + ">";
            }
            if (program.getLock() != null) {
                return db + "<locked: " + program.getLock() + ">";
            }
            return db + "<busy>";
        }
        return db + "<idle>";
    }

    public void listStatus() {
        int n = 0;
        for (CpuCore core : this.getCpuCores()) {
            this.log("Core: " + n + " -> " + this.getStatus(n));
            ++n;
        }
        this.log("Event queue: " + this.getEventQueue().size());
        this.log("Waiting items: " + this.getWaitingForItems().size());
        this.log("Locks: " + this.getLocksSize());
        ProcessorCoreData coreData = this.getCoreData();
        String lastException = coreData.lastException();
        if (!lastException.isEmpty()) {
            long dt = System.currentTimeMillis() - coreData.lastExceptionTime();
            this.log("Last: " + String.valueOf(ChatFormatting.RED) + lastException);
            if (dt > 3600000L) {
                this.log("(" + dt / 1000L + "hours ago)");
            } else if (dt > 60000L) {
                this.log("(" + dt / 60000L + "min ago)");
            } else if (dt > 1000L) {
                this.log("(" + dt / 1000L + "sec ago)");
            } else {
                this.log("(" + dt + "ms ago)");
            }
        }
    }

    public int stopPrograms() {
        int n = 0;
        for (CpuCore core : this.getCpuCores()) {
            if (!core.hasProgram()) continue;
            ++n;
            core.stopProgram();
        }
        this.clearLocks();
        this.clearRunningEvents();
        return n;
    }

    public void reset() {
        this.clearWaitingForItems();
        this.clearEventQueue();
        this.stopPrograms();
        this.setCraftingStations(new HashSet<BlockPos>());
        for (Direction facing : Direction.values()) {
            this.powerOut[facing.ordinal()] = 0;
        }
        for (BlockPos np : this.getExtraData().networkNodes().values()) {
            BlockEntity te = this.level.getBlockEntity(np);
            if (!(te instanceof NodeTileEntity)) continue;
            NodeTileEntity node = (NodeTileEntity)te;
            for (Direction facing : Direction.values()) {
                node.setPowerOut(facing, 0);
            }
        }
        ProcessorGraphicsOperationsData graphicsData = this.getGraphicsOperationsData();
        if (!graphicsData.operations().isEmpty()) {
            this.setData(ProcessorModule.PROCESSOR_GRAPHICS_DATA.get(), graphicsData.withOperations(Collections.emptyMap()));
        }
        this.orderedOps = null;
        for (CpuCore core : this.cpuCores) {
            core.setDebug(false);
        }
        this.setChanged();
    }

    public IOpcodeRunnable.OpcodeResult placeLock(String name) {
        if (this.testLock(name)) {
            return IOpcodeRunnable.OpcodeResult.HOLD;
        }
        this.addLock(name);
        return IOpcodeRunnable.OpcodeResult.POSITIVE;
    }

    public void releaseLock(String name) {
        ProcessorCoreData coreData = this.getCoreData();
        ProcessorCoreData updated = coreData.withLockRemoved(name);
        if (updated != coreData) {
            this.setData(ProcessorModule.PROCESSOR_CORE_DATA, updated);
        }
    }

    public boolean testLock(String name) {
        ProcessorCoreData coreData = this.getCoreData();
        return coreData.hasLock(name);
    }

    public void clearLog() {
        ProcessorExtraData extra = this.getExtraData();
        if (!extra.logMessages().isEmpty()) {
            this.setData(ProcessorModule.PROCESSOR_EXTRA_DATA.get(), extra.withLogMessages(List.of()));
        }
        ProcessorCoreData coreData = this.getCoreData();
        ProcessorCoreData updated = coreData.withLastException("").withLastExceptionTime(0L);
        this.setData(ProcessorModule.PROCESSOR_CORE_DATA.get(), updated);
        this.setChanged();
    }

    public void exception(ExceptionType exception, @Nullable RunningProgram program) {
        String message;
        if (exception != ExceptionType.EXCEPT_TOOMANYEVENTS) {
            List<CardInfo> cardInfos = this.getCardInfos();
            for (int i = 0; i < cardInfos.size(); ++i) {
                CardInfo info = cardInfos.get(i);
                CompiledCard compiledCard = info.getCompiledCard();
                if (compiledCard == null) continue;
                for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_EXCEPTION)) {
                    int index = event.index();
                    CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                    String code = this.evaluateStringParameter(compiledOpcode, null, 0);
                    if (!exception.getCode().equals(code)) continue;
                    this.runOrQueueEvent(i, event, program == null ? null : program.getCraftTicket(), null);
                    return;
                }
            }
        }
        if (program != null) {
            CompiledCard card = this.getCompiledCard(program.getCardIndex());
            if (card == null) {
                message = String.valueOf(ChatFormatting.RED) + "INTERNAL: " + exception.getDescription();
            } else {
                CompiledOpcode opcode = program.getCurrentOpcode(this);
                int gridX = opcode.getGridX();
                int gridY = opcode.getGridY();
                message = String.valueOf(ChatFormatting.RED) + "[" + gridX + "," + gridY + "] " + exception.getDescription() + " (" + program.getCardIndex() + ")";
            }
        } else {
            message = String.valueOf(ChatFormatting.RED) + exception.getDescription();
        }
        long timestamp = System.currentTimeMillis();
        ProcessorCoreData coreData = this.getCoreData();
        ProcessorCoreData updated = coreData.withLastException(message).withLastExceptionTime(timestamp);
        this.setData(ProcessorModule.PROCESSOR_CORE_DATA.get(), updated);
        this.log(message);
    }

    public void log(String message) {
        if (message == null) {
            return;
        }
        ProcessorExtraData extra = this.getExtraData();
        ArrayList<String> msgs = new ArrayList<String>(extra.logMessages());
        msgs.add(message);
        while (msgs.size() > (Integer)Config.processorMaxloglines.get()) {
            msgs.remove(0);
        }
        this.setData(ProcessorModule.PROCESSOR_EXTRA_DATA.get(), extra.withLogMessages(msgs));
    }

    private List<String> getDebugLog() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < Math.min(5, this.cpuCores.size()); ++i) {
            result.add(String.valueOf(ChatFormatting.BLUE) + "Core " + i + " " + String.valueOf(ChatFormatting.WHITE) + this.getStatus(i));
        }
        this.showWithWarn("Event queue: ", this.getEventQueue().size(), 20, result);
        this.showWithWarn("Waiting items: ", this.getWaitingForItems().size(), 20, result);
        this.showWithWarn("Locks: ", this.getLocksSize(), 10, result);
        ProcessorCoreData coreData = this.getCoreData();
        String lastException = coreData.lastException();
        if (!lastException.isEmpty()) {
            long dt = System.currentTimeMillis() - coreData.lastExceptionTime();
            result.add(String.valueOf(ChatFormatting.RED) + lastException);
            if (dt > 3600000L) {
                result.add("(" + dt / 1000L + "hours ago)");
            } else if (dt > 60000L) {
                result.add("(" + dt / 60000L + "min ago)");
            } else if (dt > 1000L) {
                result.add("(" + dt / 1000L + "sec ago)");
            } else {
                result.add("(" + dt + "ms ago)");
            }
        }
        return result;
    }

    private void showWithWarn(String label, int size, int max, List<String> result) {
        if (size >= max) {
            result.add(label + String.valueOf(ChatFormatting.RED) + size);
        } else {
            result.add(label + String.valueOf(ChatFormatting.GREEN) + size);
        }
    }

    private List<String> getLog() {
        return new ArrayList<String>(this.getExtraData().logMessages());
    }

    public List<String> getClientLog() {
        return this.clientLog;
    }

    public List<String> getClientDebugLog() {
        return this.clientDebugLog;
    }

    public List<String> getLastMessages(int n) {
        ArrayList<String> rc = new ArrayList<String>();
        List<String> logMessages = this.getExtraData().logMessages();
        int i = 0;
        for (String s : logMessages) {
            if (i >= logMessages.size() - n) {
                rc.add(s);
            }
            ++i;
        }
        return rc;
    }

    public int getFluidSlotsAvailable() {
        if (this.fluidSlotsAvailable == -1) {
            this.updateFluidSlotsAvailability();
        }
        return this.fluidSlotsAvailable;
    }

    public List<Parameter> getVariables() {
        return this.getCoreData().variables();
    }

    public void setWatchAt(int varIndex, boolean br) {
        ProcessorCoreData cd = this.getCoreData();
        ProcessorCoreData updated = cd.withWatchInfo(varIndex, new WatchInfo(br));
        if (updated != cd) {
            this.setData(ProcessorModule.PROCESSOR_CORE_DATA.get(), updated);
        }
    }

    public void clearWatchAt(int varIndex) {
        ProcessorCoreData cd = this.getCoreData();
        ProcessorCoreData updated = cd.withWatchInfo(varIndex, null);
        if (updated != cd) {
            this.setData(ProcessorModule.PROCESSOR_CORE_DATA.get(), updated);
        }
    }

    public List<PacketGetFluids.FluidEntry> getFluids() {
        ArrayList<PacketGetFluids.FluidEntry> pars = new ArrayList<PacketGetFluids.FluidEntry>();
        for (int i = 0; i < 24; ++i) {
            if (this.isFluidSlotAvailable(i)) {
                Direction side = Direction.values()[i / 4];
                BlockEntity te = this.level.getBlockEntity(this.getBlockPos().relative(side));
                if (te instanceof MultiTankTileEntity) {
                    MultiTankTileEntity mtank = (MultiTankTileEntity)te;
                    MultiTankFluidProperties[] propertyList = mtank.getProperties();
                    MultiTankFluidProperties properties = propertyList[i % 4];
                    FluidStack fluidStack = properties == null ? null : properties.getContents();
                    pars.add(new PacketGetFluids.FluidEntry(fluidStack, true));
                    continue;
                }
                pars.add(new PacketGetFluids.FluidEntry(null, true));
                continue;
            }
            pars.add(new PacketGetFluids.FluidEntry(null, false));
        }
        return pars;
    }

    public List<CpuCore> getCpuCores() {
        return this.cpuCores;
    }

    private CpuCore findAvailableCore(int cardIndex) {
        if (this.isExclusive()) {
            CpuCore core;
            if (cardIndex < this.cpuCores.size() && !(core = this.cpuCores.get(cardIndex)).hasProgram()) {
                return core;
            }
        } else {
            for (CpuCore core : this.cpuCores) {
                if (core.hasProgram()) continue;
                return core;
            }
        }
        return null;
    }

    private void run() {
        long rf = this.energyStorage.getEnergy();
        for (CpuCore core : this.cpuCores) {
            int rft;
            if (!core.hasProgram() || (long)(rft = ((Integer)Config.coreRFPerTick[core.getTier()].get()).intValue()) >= rf) continue;
            core.run(this);
            this.energyStorage.consumeEnergy((long)rft);
            rf -= (long)rft;
        }
    }

    private void updateCores() {
        if (this.coresDirty) {
            boolean different;
            this.coresDirty = false;
            ArrayList<ProcessorCoreData.CoreEntry> desired = new ArrayList<ProcessorCoreData.CoreEntry>();
            for (int i = 0; i < 16; ++i) {
                Item item;
                ItemStack expansionStack = this.items.getStackInSlot(i);
                if (expansionStack.isEmpty() || !((item = expansionStack.getItem()) instanceof CPUCoreItem)) continue;
                CPUCoreItem coreItem = (CPUCoreItem)item;
                desired.add(new ProcessorCoreData.CoreEntry(coreItem.getTier()));
            }
            ProcessorCoreData coreData = this.getCoreData();
            List<ProcessorCoreData.CoreEntry> stored = coreData.cores();
            boolean bl = different = stored.size() != desired.size();
            if (!different) {
                for (int i = 0; i < stored.size(); ++i) {
                    if (stored.get(i).tier() == ((ProcessorCoreData.CoreEntry)desired.get(i)).tier()) continue;
                    different = true;
                    break;
                }
            }
            if (different) {
                this.setData(ProcessorModule.PROCESSOR_CORE_DATA.get(), coreData.withCores(desired));
            }
            this.cpuCores.clear();
            for (ProcessorCoreData.CoreEntry entry : this.getCoreData().cores()) {
                CpuCore core = new CpuCore();
                core.setTier(entry.tier());
                this.cpuCores.add(core);
            }
        }
    }

    private void compileCards(HolderLookup.Provider provider) {
        if (this.cardsDirty) {
            this.cardsDirty = false;
            for (int i = 16; i < 22; ++i) {
                int cardIndex;
                ItemStack cardStack = this.items.getStackInSlot(i);
                if (cardStack.isEmpty() || this.getCardInfo(cardIndex = i - 16).getCompiledCard() != null) continue;
                CompiledCard compiled = CompiledCard.compile((ProgramCardInstance)cardStack.get((DataComponentType)VariousModule.PROGRAM_CARD_DATA.get()));
                this.updateCardInfos(infos -> ((CardInfo)infos.get(cardIndex)).setCompiledCard(compiled));
            }
        }
    }

    public String getMachineInfo(Inventory side, int idx) {
        BlockEntity te = this.getTileEntityAt((BlockSide)side);
        IMachineInformation h = (IMachineInformation)this.level.getCapability(CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY, te.getBlockPos(), null);
        if (h != null) {
            if (idx < 0 || idx >= h.getTagCount()) {
                throw new ProgException(ExceptionType.EXCEPT_INVALIDMACHINE_INDEX);
            }
            return h.getData(idx, 0L);
        }
        throw new ProgException(ExceptionType.EXCEPT_INVALIDMACHINE);
    }

    public int getEnergy(Inventory side) {
        BlockEntity te = this.getTileEntityAt((BlockSide)side);
        if (te == null) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        IEnergyStorage storage = (IEnergyStorage)te.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, te.getBlockPos(), (Object)side.getIntSide());
        if (storage == null) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        return storage.getEnergyStored();
    }

    public int getMaxEnergy(Inventory side) {
        BlockEntity te = this.getTileEntityAt((BlockSide)side);
        if (te == null) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        IEnergyStorage storage = (IEnergyStorage)te.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, te.getBlockPos(), (Object)side.getIntSide());
        if (storage == null) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        return storage.getMaxEnergyStored();
    }

    public long getEnergyLong(Inventory side) {
        BlockEntity te = this.getTileEntityAt((BlockSide)side);
        EnergyTools.EnergyLevel level = EnergyTools.getEnergyLevelMulti((BlockEntity)te, null);
        if (level.maxEnergy() >= 0L) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        return level.energy();
    }

    public long getMaxEnergyLong(Inventory side) {
        BlockEntity te = this.getTileEntityAt((BlockSide)side);
        EnergyTools.EnergyLevel level = EnergyTools.getEnergyLevelMulti((BlockEntity)te, null);
        if (level.maxEnergy() >= 0L) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        return level.maxEnergy();
    }

    public int getLiquid(@Nonnull Inventory side) {
        FluidStack contents;
        IFluidHandler handler = this.getFluidHandlerAt(side);
        if (handler.getTanks() > 0 && !(contents = handler.getFluidInTank(0)).isEmpty()) {
            return contents.getAmount();
        }
        return 0;
    }

    public int getMaxLiquid(@Nonnull Inventory side) {
        IFluidHandler handler = this.getFluidHandlerAt(side);
        if (handler.getTanks() > 0) {
            return handler.getTankCapacity(0);
        }
        return 0;
    }

    private IStorageScanner getScannerForInv(@Nullable Inventory inv) {
        if (inv == null) {
            return this.getStorageScanner();
        }
        return null;
    }

    @Nullable
    private IItemHandler getHandlerForInv(@Nullable Inventory inv) {
        if (inv == null) {
            return null;
        }
        return this.getItemHandlerAt(inv);
    }

    public boolean compareComponents(@Nonnull ItemStack v1, @Nonnull ItemStack v2, @Nonnull ResourceLocation componentId) {
        Object component2;
        DataComponentMap componentsV1 = v1.getComponents();
        DataComponentMap componentsV2 = v2.getComponents();
        DataComponentType componentType = (DataComponentType)((Registry)this.level.registryAccess().registry(Registries.DATA_COMPONENT_TYPE).get()).get(componentId);
        if (!componentsV1.has(componentType) || !componentsV2.has(componentType)) {
            return componentsV1.has(componentType) == componentsV2.has(componentType);
        }
        Object component1 = componentsV1.get(componentType);
        if (component1 == (component2 = componentsV2.get(componentType))) {
            return true;
        }
        if (component1 != null) {
            return component1.equals(component2);
        }
        return false;
    }

    private MultiTankFluidProperties getFluidPropertiesFromMultiTank(Direction side, int idx) {
        BlockEntity te = this.level.getBlockEntity(this.getBlockPos().relative(side));
        if (te instanceof MultiTankTileEntity) {
            MultiTankTileEntity mtank = (MultiTankTileEntity)te;
            return mtank.getProperties()[idx];
        }
        return null;
    }

    @Nonnull
    public FluidStack examineLiquid(@Nonnull Inventory inv, @Nullable Integer slot) {
        if (slot == null) {
            slot = 0;
        }
        Integer finalSlot = slot;
        IFluidHandler handler = this.getFluidHandlerAt(inv);
        if (finalSlot < handler.getTanks()) {
            return handler.getFluidInTank(finalSlot.intValue());
        }
        return FluidStack.EMPTY;
    }

    @Nullable
    public FluidStack examineLiquidInternal(IProgram program, int virtualSlot) {
        int idx;
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int realSlot = info.getRealFluidSlot(virtualSlot);
        Direction side = Direction.values()[realSlot / 4];
        MultiTankFluidProperties properties = this.getFluidPropertiesFromMultiTank(side, idx = realSlot % 4);
        if (properties == null) {
            return null;
        }
        return properties.getContents();
    }

    public int pushLiquid(IProgram program, @Nonnull Inventory inv, int amount, int virtualSlot) {
        IFluidHandler handler = this.getFluidHandlerAt(inv);
        if (handler != null) {
            int idx;
            CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
            int realSlot = info.getRealFluidSlot(virtualSlot);
            Direction side = Direction.values()[realSlot / 4];
            MultiTankFluidProperties properties = this.getFluidPropertiesFromMultiTank(side, idx = realSlot % 4);
            if (properties == null) {
                return 0;
            }
            if (!properties.hasContents()) {
                return 0;
            }
            int newAmount = Math.min(amount, properties.getContentsInternal().getAmount());
            FluidStack topush = properties.getContents();
            topush.setAmount(newAmount);
            int filled = handler.fill(topush, IFluidHandler.FluidAction.EXECUTE);
            properties.drain(filled);
            return filled;
        }
        return 0;
    }

    public int fetchLiquid(IProgram program, @Nonnull Inventory inv, int amount, @Nullable FluidStack fluidStack, int virtualSlot) {
        int newAmount;
        int idx;
        IFluidHandler handler = this.getFluidHandlerAt(inv);
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int realSlot = info.getRealFluidSlot(virtualSlot);
        Direction side = Direction.values()[realSlot / 4];
        MultiTankFluidProperties properties = this.getFluidPropertiesFromMultiTank(side, idx = realSlot % 4);
        if (properties == null) {
            return 0;
        }
        int internalAmount = 0;
        if (properties.hasContents()) {
            if (fluidStack != null && !FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)properties.getContentsInternal())) {
                return 0;
            }
            internalAmount = properties.getContentsInternal().getAmount();
        }
        if (internalAmount + (newAmount = amount) > 10000) {
            newAmount = 10000 - internalAmount;
        }
        if (newAmount <= 0) {
            return 0;
        }
        if (fluidStack == null) {
            FluidStack drained = handler.drain(newAmount, IFluidHandler.FluidAction.SIMULATE);
            if (!drained.isEmpty()) {
                if (!properties.hasContents() || FluidStack.isSameFluidSameComponents((FluidStack)properties.getContentsInternal(), (FluidStack)drained)) {
                    drained = handler.drain(newAmount, IFluidHandler.FluidAction.EXECUTE);
                    properties.fill(drained);
                    return drained.getAmount();
                }
                return 0;
            }
        } else {
            FluidStack todrain = fluidStack.copy();
            todrain.setAmount(newAmount);
            FluidStack drained = handler.drain(todrain, IFluidHandler.FluidAction.EXECUTE);
            if (!drained.isEmpty()) {
                int drainedAmount = drained.getAmount();
                if (properties.hasContents()) {
                    drained.setAmount(drained.getAmount() + properties.getContentsInternal().getAmount());
                }
                properties.set(drained);
                return drainedAmount;
            }
        }
        return 0;
    }

    public int fetchItemsFilter(IProgram program, Inventory inv, Integer amount, int virtualSlot, int filterIndex) {
        if (amount != null && amount == 0) {
            throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
        }
        Predicate<ItemStack> cache = this.getFilterCache(filterIndex);
        if (cache == null) {
            throw new ProgException(ExceptionType.EXCEPT_UNKNOWN_FILTER);
        }
        IItemHandler handler = this.getHandlerForInv(inv);
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int realSlot = info.getRealSlot(virtualSlot);
        ItemStack stack = LogicInventoryTools.tryExtractItem(handler, amount, cache);
        if (stack.isEmpty()) {
            return 0;
        }
        GenericItemHandler capability = this.items;
        if (!capability.insertItem(realSlot, stack, true).isEmpty()) {
            return 0;
        }
        stack = LogicInventoryTools.extractItem(handler, amount, cache);
        capability.insertItem(realSlot, stack, false);
        return stack.getCount();
    }

    public int fetchItems(IProgram program, Inventory inv, Integer slot, Ingredient itemMatcher, boolean routable, @Nullable Integer amount, int virtualSlot) {
        if (amount != null && amount == 0) {
            throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
        }
        IItemHandler handler = this.getHandlerForInv(inv);
        IStorageScanner scanner = this.getScannerForInv(inv);
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int realSlot = info.getRealSlot(virtualSlot);
        ItemStack stack = LogicInventoryTools.tryExtractItem(handler, scanner, amount, routable, itemMatcher, slot);
        if (stack.isEmpty()) {
            return 0;
        }
        GenericItemHandler capability = this.items;
        if (!capability.insertItem(realSlot, stack, true).isEmpty()) {
            return 0;
        }
        stack = LogicInventoryTools.extractItem(handler, scanner, amount, routable, itemMatcher, slot);
        capability.insertItem(realSlot, stack, false);
        return stack.getCount();
    }

    @Nullable
    public ItemStack getItemInternal(IProgram program, int virtualSlot) {
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int realSlot = info.getRealSlot(virtualSlot);
        return this.items.getStackInSlot(realSlot);
    }

    public int pushItems(IProgram program, Inventory inv, Integer slot, @Nullable Integer amount, int virtualSlot) {
        IItemHandler handler = this.getHandlerForInv(inv);
        IStorageScanner scanner = this.getScannerForInv(inv);
        GenericItemHandler itemHandler = this.items;
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int realSlot = info.getRealSlot(virtualSlot);
        ItemStack extracted = itemHandler.extractItem(realSlot, amount == null ? 64 : amount, false);
        if (extracted.isEmpty()) {
            return 0;
        }
        ItemStack remaining = LogicInventoryTools.insertItem(handler, scanner, extracted, slot);
        if (!remaining.isEmpty()) {
            itemHandler.insertItem(realSlot, remaining, false);
            return extracted.getCount() - remaining.getCount();
        }
        return extracted.getCount();
    }

    public void sendMessage(IProgram program, int idSlot, String messageName, @Nullable Integer variableSlot) {
        if (!this.hasNetworkCard()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGNETWORKCARD);
        }
        if (this.hasNetworkCard != 1) {
            throw new ProgException(ExceptionType.EXCEPT_NEEDSADVANCEDNETWORK);
        }
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int realIdSlot = info.getRealSlot(idSlot);
        Integer realVariable = info.getRealVar(variableSlot);
        ItemStack idCard = this.items.getStackInSlot(realIdSlot);
        if (idCard.isEmpty() || !(idCard.getItem() instanceof NetworkIdentifierItem)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTANIDENTIFIER);
        }
        if (!ModuleTools.hasModuleTarget((ItemStack)idCard)) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDDESTINATION);
        }
        ResourceKey dim = ModuleTools.getDimensionFromModule((ItemStack)idCard);
        BlockPos dest = ModuleTools.getPositionFromModule((ItemStack)idCard);
        ServerLevel world = LevelTools.getLevel((Level)this.level, (ResourceKey)dim);
        if (world == null || !LevelTools.isLoaded((Level)world, (BlockPos)dest)) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDDESTINATION);
        }
        BlockEntity te = world.getBlockEntity(dest);
        if (!(te instanceof ProcessorTileEntity)) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDDESTINATION);
        }
        ProcessorTileEntity destTE = (ProcessorTileEntity)te;
        destTE.receiveMessage(messageName, realVariable == null ? null : this.getVariableAt(realVariable));
    }

    private void setOp(String id, GfxOp op) {
        if (!this.hasGraphicsCard()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGGRAPHICSCARD);
        }
        ProcessorGraphicsOperationsData graphicsData = this.getGraphicsOperationsData();
        Map<String, GfxOp> currentOps = graphicsData.operations();
        boolean alreadyPresent = currentOps.containsKey(id);
        if (!alreadyPresent && currentOps.size() >= (Integer)Config.maxGraphicsOpcodes.get()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGNETWORKCARD);
        }
        LinkedHashMap<String, GfxOp> updatedOps = new LinkedHashMap<String, GfxOp>(currentOps);
        updatedOps.put(id, op);
        this.setData(ProcessorModule.PROCESSOR_GRAPHICS_DATA.get(), graphicsData.withOperations(updatedOps));
        this.orderedOps = null;
        this.setChanged();
    }

    private void sortOps() {
        this.orderedOps = new ArrayList<String>(this.getGraphicsOperationsData().operations().keySet());
        this.orderedOps.sort(String::compareTo);
    }

    public void gfxDrawBox(IProgram program, String id, int x, int y, int w, int h, int color) {
        this.setOp(id, new GfxOpBox(x, y, w, h, color));
    }

    public void gfxDrawLine(IProgram program, String id, int x1, int y1, int x2, int y2, int color) {
        this.setOp(id, new GfxOpLine(x1, y1, x2, y2, color));
    }

    public void gfxDrawText(IProgram program, String id, int x, int y, String text, int color) {
        this.setOp(id, new GfxOpText(x, y, text, color));
    }

    public void gfxDrawBox(IProgram program, String id, @Nonnull Tuple loc, @Nonnull Tuple size, int color) {
        this.setOp(id, new GfxOpBox(loc.getX(), loc.getY(), size.getX(), size.getY(), color));
    }

    public void gfxDrawLine(IProgram program, String id, @Nonnull Tuple pos1, @Nonnull Tuple pos2, int color) {
        this.setOp(id, new GfxOpLine(pos1.getX(), pos1.getY(), pos2.getX(), pos2.getY(), color));
    }

    public void gfxDrawText(IProgram program, String id, @Nonnull Tuple pos, String text, int color) {
        this.setOp(id, new GfxOpText(pos.getX(), pos.getY(), text, color));
    }

    public void gfxClear(IProgram program, @Nullable String id) {
        ProcessorGraphicsOperationsData graphicsData = this.getGraphicsOperationsData();
        Map<String, GfxOp> currentOps = graphicsData.operations();
        boolean changed = false;
        if (id == null || id.isEmpty()) {
            if (!currentOps.isEmpty()) {
                this.setData(ProcessorModule.PROCESSOR_GRAPHICS_DATA.get(), graphicsData.withOperations(Collections.emptyMap()));
                changed = true;
            }
        } else if (currentOps.containsKey(id)) {
            LinkedHashMap<String, GfxOp> updated = new LinkedHashMap<String, GfxOp>(currentOps);
            updated.remove(id);
            this.setData(ProcessorModule.PROCESSOR_GRAPHICS_DATA.get(), graphicsData.withOperations(updated));
            changed = true;
        }
        if (changed) {
            this.orderedOps = null;
            this.setChanged();
        }
    }

    public Map<String, GfxOp> getGfxOps() {
        return this.getGraphicsOperationsData().operations();
    }

    public List<String> getOrderedOps() {
        if (this.orderedOps == null) {
            this.sortOps();
        }
        return this.orderedOps;
    }

    public void setClientOrderedGfx(Map<String, GfxOp> gfxOps, List<String> orderedOps) {
        this.clientGfxOps.clear();
        for (String key : orderedOps) {
            this.clientGfxOps.add(gfxOps.get(key));
        }
    }

    public List<GfxOp> getClientGfxOps() {
        return this.clientGfxOps;
    }

    public boolean testWithFilter(ItemStack item, int idx) {
        Predicate<ItemStack> filterCache = this.getFilterCache(idx);
        if (filterCache == null) {
            throw new ProgException(ExceptionType.EXCEPT_UNKNOWN_FILTER);
        }
        return filterCache.test(item);
    }

    private List<Predicate<ItemStack>> getFilterCaches() {
        ArrayList<Predicate<ItemStack>> caches = new ArrayList<Predicate<ItemStack>>();
        for (int i = 0; i < 16; ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof FilterModuleItem)) continue;
            caches.add(FilterModuleItem.getCache((ItemStack)stack));
        }
        return caches;
    }

    @Nullable
    private Predicate<ItemStack> getFilterCache(int index) {
        if (index < ((List)this.filterCaches.get()).size()) {
            return (Predicate)((List)this.filterCaches.get()).get(index);
        }
        return null;
    }

    public int getMaxvars() {
        if (this.maxVars == -1) {
            this.maxVars = 0;
            this.hasNetworkCard = -1;
            this.hasGraphicsCard = false;
            this.storageCard = -1;
            Item storageCardItem = RFToolsStuff.STORAGE_CONTROL_MODULE.get();
            for (int i = 0; i < 16; ++i) {
                ItemStack stack = this.items.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                Item item = stack.getItem();
                if (item instanceof NetworkCardItem) {
                    NetworkCardItem networkCardItem = (NetworkCardItem)item;
                    this.hasNetworkCard = networkCardItem.getTier();
                    continue;
                }
                if (stack.getItem() instanceof RAMChipItem) {
                    this.maxVars += 8;
                    continue;
                }
                if (stack.getItem() instanceof GraphicsCardItem) {
                    this.hasGraphicsCard = true;
                    continue;
                }
                if (stack.getItem() != storageCardItem) continue;
                this.storageCard = i;
            }
            if (this.maxVars >= 32) {
                this.maxVars = 32;
            }
            this.updateFluidSlotsAvailability();
        }
        return this.maxVars;
    }

    public void markFluidSlotsDirty() {
        this.fluidSlotsAvailable = -1;
    }

    private void updateFluidSlotsAvailability() {
        this.fluidSlotsAvailable = 0;
        for (Direction facing : Direction.values()) {
            BlockEntity te = this.level.getBlockEntity(this.getBlockPos().relative(facing));
            if (!(te instanceof MultiTankTileEntity)) continue;
            this.fluidSlotsAvailable |= 1 << facing.ordinal();
        }
        this.fixCardInfoForSlotAvailability();
        this.setChanged();
    }

    private void fixCardInfoForSlotAvailability() {
        this.updateCardInfos(infos -> {
            for (CardInfo info : infos) {
                int alloc = info.getFluidAllocation();
                for (int i = 0; i < 24; ++i) {
                    if ((this.fluidSlotsAvailable & 1 << i / 4) != 0) continue;
                    alloc &= ~(1 << i);
                }
                info.setFluidAllocation(alloc);
            }
        });
    }

    public boolean hasGraphicsCard() {
        if (this.maxVars == -1) {
            this.getMaxvars();
        }
        return this.hasGraphicsCard;
    }

    public boolean hasNetworkCard() {
        if (this.maxVars == -1) {
            this.getMaxvars();
        }
        return this.hasNetworkCard != -1;
    }

    public int getStorageCard() {
        if (this.storageCard == -2) {
            this.getMaxvars();
        }
        return this.storageCard;
    }

    public String getChannelName() {
        return this.getExtraData().channel();
    }

    public int getNodeCount() {
        return this.getExtraData().networkNodes().size();
    }

    public void stopOrResume(IProgram program) {
        ((RunningProgram)program).popLoopStack(this);
    }

    public boolean testGreater(IProgram program, int var) {
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int realVar = this.getRealVarSafe(var, info);
        Parameter lastValue = (Parameter)program.getLastValue();
        Parameter varValue = this.getVariableAt(realVar);
        if (lastValue == null) {
            return varValue == null;
        }
        if (varValue == null) {
            return false;
        }
        if (lastValue.getParameterType() != varValue.getParameterType()) {
            return false;
        }
        return ParameterTools.compare((IParameter)lastValue, (IParameter)varValue) > 0;
    }

    public boolean testEquality(IProgram program, int var) {
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int realVar = this.getRealVarSafe(var, info);
        Parameter lastValue = (Parameter)program.getLastValue();
        Parameter varValue = this.getVariableAt(realVar);
        if (lastValue == null) {
            return varValue == null;
        }
        if (varValue == null) {
            return false;
        }
        if (lastValue.getParameterType() != varValue.getParameterType()) {
            return false;
        }
        Object v1 = lastValue.getParameterValue().getValue();
        Object v2 = varValue.getParameterValue().getValue();
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return false;
        }
        if (varValue.getParameterType() == ParameterType.PAR_ITEM) {
            return ItemStack.isSameItem((ItemStack)((ItemStack)v1), (ItemStack)((ItemStack)v2));
        }
        if (varValue.getParameterType() == ParameterType.PAR_FLUID) {
            return FluidStack.isSameFluidSameComponents((FluidStack)((FluidStack)v1), (FluidStack)((FluidStack)v2));
        }
        if (varValue.getParameterType() == ParameterType.PAR_VECTOR) {
            return ParameterTools.compare((IParameter)lastValue, (IParameter)varValue) == 0;
        }
        return v1.equals(v2);
    }

    private int getRealVarSafe(int var, CardInfo info) {
        int realVar = info.getRealVar(var);
        if (realVar == -1) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGVARIABLE);
        }
        if (realVar >= this.getMaxvars()) {
            throw new ProgException(ExceptionType.EXCEPT_NOTENOUGHVARIABLES);
        }
        return realVar;
    }

    public void handleCall(IProgram program, String signal) {
        RunningProgram p = (RunningProgram)program;
        CardInfo info = this.getCardInfo(p.getCardIndex());
        CompiledCard compiledCard = info.getCompiledCard();
        if (compiledCard != null) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_SIGNAL)) {
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                String sig = this.evaluateStringParameter(compiledOpcode, null, 0);
                if (!signal.equals(sig)) continue;
                p.pushCall(p.getCurrentOpcode(this).getPrimaryIndex());
                p.setCurrent(event.index());
                return;
            }
        }
        throw new ProgException(ExceptionType.EXCEPT_MISSINGSIGNAL);
    }

    public IOpcodeRunnable.OpcodeResult handleLoop(IProgram program, int varIdx, int end) {
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int realVar = this.getRealVarSafe(varIdx, info);
        Parameter parameter = this.getVariableAt(realVar);
        int i = TypeConverters.convertToInt((IParameter)parameter);
        if (i > end) {
            return IOpcodeRunnable.OpcodeResult.NEGATIVE;
        }
        ((RunningProgram)program).pushLoopStack(realVar);
        return IOpcodeRunnable.OpcodeResult.POSITIVE;
    }

    public void setValueInToken(IProgram program, int slot) {
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int realSlot = info.getRealSlot(slot);
        ItemStack stack = this.items.getStackInSlot(realSlot);
        if (stack.isEmpty() || !(stack.getItem() instanceof TokenItem)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTATOKEN);
        }
        Parameter lastValue = (Parameter)program.getLastValue();
        if (lastValue == null) {
            stack.remove(VariousModule.TOKEN_DATA);
        } else {
            stack.set(VariousModule.TOKEN_DATA, (Object)new TokenData(lastValue));
        }
    }

    @Nullable
    public Parameter getParameterFromToken(IProgram program, int slot) {
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int realSlot = info.getRealSlot(slot);
        ItemStack stack = this.items.getStackInSlot(realSlot);
        if (stack.isEmpty() || !(stack.getItem() instanceof TokenItem)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTATOKEN);
        }
        TokenData data = (TokenData)stack.get(VariousModule.TOKEN_DATA);
        return data != null ? data.parameter() : null;
    }

    public void setVariable(IProgram program, int var) {
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int realVar = this.getRealVarSafe(var, info);
        this.setVariableInternal(program, realVar, (Parameter)program.getLastValue());
    }

    public void setVariableInternal(IProgram program, int realVar, Parameter value) {
        Parameter oldValue;
        WatchInfo wi = this.getWatchInfoAt(realVar);
        if (wi != null && this.isWatchTriggered(oldValue = this.getVariableAt(realVar), value)) {
            this.log(String.valueOf(ChatFormatting.BLUE) + "W" + realVar + ": " + TypeConverters.convertToString((IParameter)value));
            if (wi.breakOnChange()) {
                CpuCore core = ((RunningProgram)program).getCore();
                core.setDebug(true);
            }
        }
        this.setVariableAt(realVar, value);
    }

    private boolean isWatchTriggered(Parameter old, Parameter value) {
        if (old == value) {
            return false;
        }
        if (old == null) {
            return true;
        }
        if (value == null) {
            return true;
        }
        return ParameterTools.compare((IParameter)value, (IParameter)old) != 0;
    }

    public IParameter getVariable(IProgram program, int var) {
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int realVar = this.getRealVarSafe(var, info);
        return this.getVariableAt(realVar);
    }

    @Nullable
    public <T> T evaluateGenericParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex, BiFunction<ParameterType, Object, T> convertor) {
        List parameters = compiledOpcode.getParameters();
        if (parIndex >= parameters.size()) {
            return null;
        }
        IParameter parameter = (IParameter)parameters.get(parIndex);
        ParameterValue value = parameter.getParameterValue();
        if (value.isConstant()) {
            return convertor.apply(parameter.getParameterType(), value.getValue());
        }
        if (value.isFunction()) {
            mcjty.rftoolsbase.api.control.code.Function function = value.getFunction();
            Object v = function.getFunctionRunnable().run((IProcessor)this, program);
            return convertor.apply(function.getReturnType(), v);
        }
        CardInfo info = this.getCardInfo(((RunningProgram)program).getCardIndex());
        int realVar = this.getRealVarSafe(value.getVariableIndex(), info);
        Parameter par = this.getVariableAt(realVar);
        if (par == null || par.getParameterValue() == null) {
            return null;
        }
        return convertor.apply(par.getParameterType(), par.getParameterValue().getValue());
    }

    @Nonnull
    public <T> T evaluateGenericParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex, BiFunction<ParameterType, Object, T> convertor) {
        T rc = this.evaluateGenericParameter(compiledOpcode, program, parIndex, convertor);
        if (rc == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGPARAMETER);
        }
        return rc;
    }

    @Nonnull
    public <T> T evaluateParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return (T)this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, (type, value) -> value);
    }

    @Nullable
    public <T> T evaluateParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return (T)this.evaluateGenericParameter(compiledOpcode, program, parIndex, (type, value) -> value);
    }

    @Nullable
    public Tuple evaluateTupleParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_TUPLE);
    }

    @Nonnull
    public Tuple evaluateTupleParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_TUPLE);
    }

    @Nullable
    public List<IParameter> evaluateVectorParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        List<Parameter> parameters = this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_VECTOR);
        if (parameters == null) {
            return null;
        }
        return parameters.stream().map(p -> p).collect(Collectors.toList());
    }

    @Nonnull
    public List<IParameter> evaluateVectorParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        List<Parameter> parameters = this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_VECTOR);
        return parameters.stream().map(p -> p).collect(Collectors.toList());
    }

    @Nullable
    public ItemStack evaluateItemParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        ItemStack stack = this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_ITEM);
        if (stack == null) {
            return ItemStack.EMPTY;
        }
        return stack;
    }

    @Nonnull
    public ItemStack evaluateItemParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        ItemStack stack = this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_ITEM);
        if (stack.isEmpty()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGPARAMETER);
        }
        return stack;
    }

    @Nullable
    public FluidStack evaluateFluidParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_FLUID);
    }

    @Nonnull
    public FluidStack evaluateFluidParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_FLUID);
    }

    @Nullable
    public BlockSide evaluateSideParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_SIDE);
    }

    @Nonnull
    public BlockSide evaluateSideParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_SIDE);
    }

    @Nullable
    public Inventory evaluateInventoryParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_INVENTORY);
    }

    @Nonnull
    public Inventory evaluateInventoryParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_INVENTORY);
    }

    public int evaluateIntParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        Integer value = this.evaluateIntegerParameter(compiledOpcode, program, parIndex);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public long evaluateLngParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        Long value = this.evaluateLongParameter(compiledOpcode, program, parIndex);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    @Nullable
    public Integer evaluateIntegerParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_INTEGER);
    }

    @Nullable
    public Long evaluateLongParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_LONG);
    }

    @Nullable
    public Number evaluateNumberParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_NUMBER);
    }

    @Nullable
    public String evaluateStringParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_STRING);
    }

    @Nonnull
    public String evaluateStringParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_STRING);
    }

    public boolean evaluateBoolParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        Boolean rc = this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_BOOL);
        if (rc == null) {
            return false;
        }
        return rc;
    }

    public int countItemStorage(ItemStack stack, boolean routable) {
        IStorageScanner scanner = this.getStorageScanner();
        return scanner.countItems(stack, routable);
    }

    private IStorageScanner getStorageScanner() {
        int card = this.getStorageCard();
        if (card == -1) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGECARD);
        }
        ItemStack storageStack = this.items.getStackInSlot(card);
        BlockPos c = ModuleTools.getPositionFromModule((ItemStack)storageStack);
        ResourceKey dim = ModuleTools.getDimensionFromModule((ItemStack)storageStack);
        if (dim == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGECARD);
        }
        ServerLevel world = LevelTools.getLevel((ResourceKey)dim);
        if (world == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)c)) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        BlockEntity te = world.getBlockEntity(c);
        if (te == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        if (!(te instanceof IStorageScanner)) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        return (IStorageScanner)te;
    }

    public int countSlots(Inventory inv, IProgram program) {
        return this.getItemHandlerAt(inv).getSlots();
    }

    public int countItem(Inventory inv, Integer slot, ItemStack itemMatcher, boolean routable, IProgram program) {
        if (inv == null) {
            return this.countItemStorage(itemMatcher, routable);
        }
        IItemHandler handler = this.getItemHandlerAt(inv);
        if (handler != null) {
            if (slot != null) {
                ItemStack stackInSlot = handler.getStackInSlot(slot.intValue());
                if (stackInSlot.isEmpty()) {
                    return 0;
                }
                if (!itemMatcher.isEmpty() && !ItemStack.isSameItem((ItemStack)stackInSlot, (ItemStack)itemMatcher)) {
                    return 0;
                }
                return stackInSlot.getCount();
            }
            if (!itemMatcher.isEmpty()) {
                return this.countItemInHandler(itemMatcher, handler);
            }
            int cnt = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                cnt += stack.getCount();
            }
            return cnt;
        }
        return 0;
    }

    private int countItemInHandler(ItemStack itemMatcher, IItemHandler handler) {
        int cnt = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemMatcher)) continue;
            cnt += stack.getCount();
        }
        return cnt;
    }

    @Nullable
    public BlockEntity getTileEntityAt(@Nullable BlockSide inv) {
        BlockPos np = this.getPositionAt(inv);
        if (np == null) {
            return null;
        }
        return this.level.getBlockEntity(np);
    }

    @Nullable
    public BlockPos getPositionAt(@Nullable BlockSide inv) {
        if (inv == null) {
            return null;
        }
        BlockPos p = this.worldPosition;
        if (inv.hasNodeName()) {
            if (!this.hasNetworkCard()) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNETWORKCARD);
            }
            Map<String, BlockPos> nodes = this.getExtraData().networkNodes();
            p = nodes.get(inv.getNodeName());
            if (p == null) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNODE);
            }
        }
        if (inv.getSide() == null) {
            return p;
        }
        return p.relative(inv.getSide());
    }

    @Nonnull
    public IFluidHandler getFluidHandlerAt(@Nonnull Inventory inv) {
        BlockEntity te = this.getTileEntityAt((BlockSide)inv);
        if (te == null) {
            throw new ProgException(ExceptionType.EXCEPT_NOLIQUID);
        }
        IFluidHandler capability = (IFluidHandler)te.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, te.getBlockPos(), (Object)inv.getIntSide());
        if (capability == null) {
            throw new ProgException(ExceptionType.EXCEPT_NOLIQUID);
        }
        return capability;
    }

    @Nullable
    public IItemHandler getItemHandlerAt(@Nonnull Inventory inv) {
        Direction intSide = inv.getIntSide();
        BlockEntity te = this.getTileEntityAt((BlockSide)inv);
        if (te == null) {
            return null;
        }
        return this.getItemHandlerAt(te, intSide);
    }

    private IItemHandler getItemHandlerAt(@Nonnull BlockEntity te, Direction intSide) {
        IItemHandler capability = (IItemHandler)te.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, te.getBlockPos(), (Object)intSide);
        if (capability == null) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY);
        }
        return capability;
    }

    private boolean isExpansionSlot(int index) {
        return index >= 0 && index < 16;
    }

    private boolean isCardSlot(int index) {
        return index >= 16 && index < 22;
    }

    private void removeCard(int index) {
        this.updateCardInfos(infos -> ((CardInfo)infos.get(index)).setCompiledCard(null));
        this.stopPrograms(index);
        this.filterEventQueue(event -> event.cardIndex() != index);
    }

    private void stopPrograms(int cardIndex) {
        for (CpuCore core : this.cpuCores) {
            if (!core.hasProgram() || core.getProgram().getCardIndex() != cardIndex) continue;
            core.stopProgram();
        }
        this.retainRunningEvents(pair -> (Integer)pair.getLeft() != cardIndex);
    }

    private void clearExpansions() {
        this.coresDirty = true;
        this.maxVars = -1;
        this.storageCard = -2;
        this.hasNetworkCard = -1;
        this.filterCaches.clear();
    }

    public HudMode getShowHud() {
        return this.getSettingsData().showHud();
    }

    public void setShowHud(HudMode showHud) {
        ProcessorSettingsData data = this.getSettingsData();
        if (data.showHud() != showHud) {
            this.setData(ProcessorModule.PROCESSOR_SETTINGS_DATA.get(), data.withShowHud(showHud));
            this.markDirtyClient();
        }
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        boolean ex = tagCompound.getBoolean("exclusive");
        byte hud = tagCompound.getByte("hud");
        this.setData(ProcessorModule.PROCESSOR_SETTINGS_DATA.get(), new ProcessorSettingsData(ex, HudMode.fromOrdinal(hud)));
    }

    public void saveClientDataToNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        tagCompound.putBoolean("exclusive", this.isExclusive());
        tagCompound.putInt("hud", this.getShowHud().ordinal());
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.prevIn = tag.getInt("prevIn");
        for (int i = 0; i < 6; ++i) {
            this.powerOut[i] = tag.getByte("p" + i);
        }
        this.items.load(tag, "items", provider);
        this.energyStorage.load(tag, "energy", provider);
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("prevIn", this.prevIn);
        for (int i = 0; i < 6; ++i) {
            tag.putByte("p" + i, (byte)this.powerOut[i]);
        }
        this.items.save(tag, "items", provider);
        this.energyStorage.save(tag, "energy", provider);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        ProcessorSettingsData settings;
        ProcessorExtraData extra;
        ProcessorCraftingData crafting;
        ProcessorEventData events;
        ProcessorGraphicsOperationsData graphics;
        ProcessorCardInfoData cardInfo;
        super.applyImplicitComponents(input);
        ProcessorCoreData core = (ProcessorCoreData)input.get((DataComponentType)ProcessorModule.ITEM_PROCESSOR_CORE_DATA.get());
        if (core != null) {
            this.setData(ProcessorModule.PROCESSOR_CORE_DATA.get(), core);
        }
        if ((cardInfo = (ProcessorCardInfoData)input.get((DataComponentType)ProcessorModule.ITEM_PROCESSOR_CARD_INFO_DATA.get())) != null) {
            this.setData(ProcessorModule.PROCESSOR_CARD_INFO_DATA.get(), cardInfo);
        }
        if ((graphics = (ProcessorGraphicsOperationsData)input.get((DataComponentType)ProcessorModule.ITEM_PROCESSOR_GRAPHICS_DATA.get())) != null) {
            this.setData(ProcessorModule.PROCESSOR_GRAPHICS_DATA.get(), graphics);
        }
        if ((events = (ProcessorEventData)input.get((DataComponentType)ProcessorModule.ITEM_PROCESSOR_EVENTS_DATA.get())) != null) {
            this.setData(ProcessorModule.PROCESSOR_EVENTS_DATA.get(), events);
        }
        if ((crafting = (ProcessorCraftingData)input.get((DataComponentType)ProcessorModule.ITEM_PROCESSOR_CRAFTING_DATA.get())) != null) {
            this.setData(ProcessorModule.PROCESSOR_CRAFTING_DATA.get(), crafting);
        }
        if ((extra = (ProcessorExtraData)input.get((DataComponentType)ProcessorModule.ITEM_PROCESSOR_EXTRA_DATA.get())) != null) {
            this.setData(ProcessorModule.PROCESSOR_EXTRA_DATA.get(), extra);
        }
        if ((settings = (ProcessorSettingsData)input.get((DataComponentType)ProcessorModule.ITEM_PROCESSOR_SETTINGS_DATA.get())) != null) {
            this.setData(ProcessorModule.PROCESSOR_SETTINGS_DATA.get(), settings);
        }
        this.energyStorage.applyImplicitComponents((ItemEnergy)input.get((Supplier)Registration.ITEM_ENERGY));
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((DataComponentType)ProcessorModule.ITEM_PROCESSOR_CORE_DATA.get(), (Object)((ProcessorCoreData)this.getData(ProcessorModule.PROCESSOR_CORE_DATA.get())));
        builder.set((DataComponentType)ProcessorModule.ITEM_PROCESSOR_CARD_INFO_DATA.get(), (Object)((ProcessorCardInfoData)this.getData(ProcessorModule.PROCESSOR_CARD_INFO_DATA.get())));
        builder.set((DataComponentType)ProcessorModule.ITEM_PROCESSOR_GRAPHICS_DATA.get(), (Object)((ProcessorGraphicsOperationsData)this.getData(ProcessorModule.PROCESSOR_GRAPHICS_DATA.get())));
        builder.set((DataComponentType)ProcessorModule.ITEM_PROCESSOR_EVENTS_DATA.get(), (Object)((ProcessorEventData)this.getData(ProcessorModule.PROCESSOR_EVENTS_DATA.get())));
        builder.set((DataComponentType)ProcessorModule.ITEM_PROCESSOR_CRAFTING_DATA.get(), (Object)((ProcessorCraftingData)this.getData(ProcessorModule.PROCESSOR_CRAFTING_DATA.get())));
        builder.set((DataComponentType)ProcessorModule.ITEM_PROCESSOR_EXTRA_DATA.get(), (Object)((ProcessorExtraData)this.getData(ProcessorModule.PROCESSOR_EXTRA_DATA.get())));
        builder.set((DataComponentType)ProcessorModule.ITEM_PROCESSOR_SETTINGS_DATA.get(), (Object)((ProcessorSettingsData)this.getData(ProcessorModule.PROCESSOR_SETTINGS_DATA.get())));
        this.energyStorage.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
    }

    public boolean isFluidAllocated(int cardIndex, int fluidIndex) {
        if (cardIndex == -1) {
            for (CardInfo info : this.getCardInfos()) {
                int fluidAlloc = info.getFluidAllocation();
                if ((fluidAlloc >> fluidIndex & 1) == 0) continue;
                return true;
            }
            return false;
        }
        CardInfo info = this.getCardInfo(cardIndex);
        int fluidA = info.getFluidAllocation();
        return (fluidA >> fluidIndex & 1) != 0;
    }

    public boolean isVarAllocated(int cardIndex, int varIndex) {
        if (cardIndex == -1) {
            for (CardInfo info : this.getCardInfos()) {
                int varAlloc = info.getVarAllocation();
                if ((varAlloc >> varIndex & 1) == 0) continue;
                return true;
            }
            return false;
        }
        CardInfo info = this.getCardInfo(cardIndex);
        int varAlloc = info.getVarAllocation();
        return (varAlloc >> varIndex & 1) != 0;
    }

    public boolean isItemAllocated(int cardIndex, int itemIndex) {
        if (cardIndex == -1) {
            for (CardInfo info : this.getCardInfos()) {
                int itemAlloc = info.getItemAllocation();
                if ((itemAlloc >> itemIndex & 1) == 0) continue;
                return true;
            }
            return false;
        }
        CardInfo info = this.getCardInfo(cardIndex);
        int itemAlloc = info.getItemAllocation();
        return (itemAlloc >> itemIndex & 1) != 0;
    }

    public CardInfo getCardInfo(int index) {
        List<CardInfo> infos = this.getCardInfos();
        return infos.get(index);
    }

    public CompiledCard getCompiledCard(int index) {
        CardInfo info = this.getCardInfo(index);
        CompiledCard card = info.getCompiledCard();
        ItemStack cardStack = this.items.getStackInSlot(index + 16);
        if (card == null && !cardStack.isEmpty()) {
            CompiledCard compiled = CompiledCard.compile((ProgramCardInstance)cardStack.get((DataComponentType)VariousModule.PROGRAM_CARD_DATA.get()));
            this.updateCardInfos(infos -> ((CardInfo)infos.get(index)).setCompiledCard(compiled));
            card = compiled;
        }
        return card;
    }

    private void allocate(int card, int itemAlloc, int varAlloc, int fluidAlloc) {
        this.updateCardInfos(infos -> {
            CardInfo info = (CardInfo)infos.get(card);
            info.setItemAllocation(itemAlloc);
            info.setVarAllocation(varAlloc);
            info.setFluidAllocation(fluidAlloc);
        });
        this.setChanged();
    }

    public void showNetworkInfo() {
        ProcessorExtraData extra = this.getExtraData();
        this.log("Channel: " + extra.channel());
        this.log("Nodes: " + extra.networkNodes().size());
    }

    public void listNodes() {
        Map<String, BlockPos> nodes = this.getExtraData().networkNodes();
        Set<BlockPos> craftingStations = this.getCraftingStations();
        if (nodes.isEmpty() && craftingStations.isEmpty()) {
            this.log("No nodes or crafting stations!");
        } else {
            for (Map.Entry<String, BlockPos> entry : nodes.entrySet()) {
                this.log(String.valueOf(ChatFormatting.GREEN) + "Node " + String.valueOf(ChatFormatting.YELLOW) + entry.getKey() + String.valueOf(ChatFormatting.GREEN) + " at " + String.valueOf(ChatFormatting.YELLOW) + BlockPosTools.toString((BlockPos)entry.getValue()));
            }
            for (BlockPos station : craftingStations) {
                this.log(String.valueOf(ChatFormatting.GREEN) + "Crafting station at " + String.valueOf(ChatFormatting.YELLOW) + BlockPosTools.toString((BlockPos)station));
            }
        }
    }

    public void setupNetwork(String name) {
        ProcessorExtraData extra = this.getExtraData();
        if (!Objects.equals(extra.channel(), name)) {
            this.setData(ProcessorModule.PROCESSOR_EXTRA_DATA.get(), extra.withChannel(name));
        }
        this.setChanged();
    }

    public void redstoneNodeChange(int previousMask, int newMask, String node) {
        List<CardInfo> cardInfos = this.getCardInfos();
        for (int i = 0; i < cardInfos.size(); ++i) {
            CardInfo info = cardInfos.get(i);
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            this.handleEventsRedstoneOn(i, compiledCard, node, previousMask, newMask);
            this.handleEventsRedstoneOff(i, compiledCard, node, previousMask, newMask);
        }
    }

    public void scanNodes() {
        if (!this.hasNetworkCard()) {
            this.log(String.valueOf(ChatFormatting.RED) + "No network card!");
            return;
        }
        ProcessorExtraData extra = this.getExtraData();
        String channel = extra.channel();
        if (channel == null || channel.isEmpty()) {
            this.log(String.valueOf(ChatFormatting.RED) + "Setup a channel first!");
            return;
        }
        HashMap<String, BlockPos> nodes = new HashMap<String, BlockPos>();
        int range = this.hasNetworkCard == 0 ? 8 : 16;
        HashSet<BlockPos> newStations = new HashSet<BlockPos>();
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos n = new BlockPos(this.worldPosition.getX() + x, this.worldPosition.getY() + y, this.worldPosition.getZ() + z);
                    BlockEntity te = this.level.getBlockEntity(n);
                    if (te instanceof NodeTileEntity) {
                        NodeTileEntity node = (NodeTileEntity)te;
                        if (!channel.equals(node.getChannelName())) continue;
                        if (node.getNodeName() == null || node.getNodeName().isEmpty()) {
                            this.log("Node is missing a name!");
                            continue;
                        }
                        nodes.put(node.getNodeName(), n);
                        node.setProcessor(this.getBlockPos());
                        continue;
                    }
                    if (!(te instanceof CraftingStationTileEntity)) continue;
                    CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
                    craftingStation.registerProcessor(this.worldPosition);
                    newStations.add(n);
                }
            }
        }
        this.setData(ProcessorModule.PROCESSOR_EXTRA_DATA.get(), extra.withNetworkNodes(nodes));
        this.setCraftingStations(newStations);
        this.log("Found " + nodes.size() + " node(s)");
        this.log("Found " + newStations.size() + " crafting station(s)");
        this.setChanged();
    }

    private boolean isValidExpansionItem(Item item) {
        Item storageCardItem = RFToolsStuff.STORAGE_CONTROL_MODULE.get();
        return item == ProcessorModule.GRAPHICS_CARD.get() || item == ProcessorModule.NETWORK_CARD.get() || item == ProcessorModule.ADVANCED_NETWORK_CARD.get() || item == ProcessorModule.CPU_CORE_500.get() || item == ProcessorModule.CPU_CORE_1000.get() || item == ProcessorModule.CPU_CORE_2000.get() || item == ProcessorModule.RAM_CHIP.get() || item == storageCardItem || item instanceof FilterModuleItem;
    }

    private void onUpdateCard(int index) {
        if (this.isCardSlot(index)) {
            this.removeCard(index - 16);
            this.cardsDirty = true;
        } else if (this.isExpansionSlot(index)) {
            this.clearExpansions();
        }
    }
}

