/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.grid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import mcjty.rftoolscontrol.modules.processor.logic.grid.GridInstance;
import mcjty.rftoolscontrol.modules.processor.logic.grid.GridPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record ProgramCardInstance(Map<GridPos, GridInstance> gridInstances) {
    private static final ProgramCardInstance EMPTY = new ProgramCardInstance(Collections.emptyMap());
    private static final Codec<Entry> ENTRY_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GridPos.CODEC.fieldOf("pos").forGetter(Entry::pos), (App)GridInstance.CODEC.fieldOf("opcode").forGetter(Entry::opcode)).apply((Applicative)inst, Entry::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, Entry> ENTRY_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, e -> e.pos().x(), (StreamCodec)ByteBufCodecs.VAR_INT, e -> e.pos().y(), GridInstance.STREAM_CODEC, Entry::opcode, (x, y, op) -> new Entry(new GridPos((int)x, (int)y), (GridInstance)op));
    public static final Codec<ProgramCardInstance> CODEC = ENTRY_CODEC.listOf().xmap(list -> {
        HashMap<GridPos, GridInstance> map = new HashMap<GridPos, GridInstance>();
        for (Entry e : list) {
            map.put(e.pos(), e.opcode());
        }
        return new ProgramCardInstance(map);
    }, inst -> {
        ArrayList<Entry> list = new ArrayList<Entry>();
        for (Map.Entry<GridPos, GridInstance> me : inst.gridInstances().entrySet()) {
            list.add(new Entry(me.getKey(), me.getValue()));
        }
        return list;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgramCardInstance> STREAM_CODEC = StreamCodec.of((buf, inst) -> {
        ArrayList<Entry> list = new ArrayList<Entry>();
        for (Map.Entry<GridPos, GridInstance> me : inst.gridInstances().entrySet()) {
            list.add(new Entry(me.getKey(), me.getValue()));
        }
        ByteBufCodecs.VAR_INT.encode(buf, (Object)list.size());
        for (Entry e : list) {
            ENTRY_STREAM_CODEC.encode(buf, (Object)e);
        }
    }, buf -> {
        int size = (Integer)ByteBufCodecs.VAR_INT.decode(buf);
        HashMap<GridPos, GridInstance> map = new HashMap<GridPos, GridInstance>();
        for (int i = 0; i < size; ++i) {
            Entry e = (Entry)ENTRY_STREAM_CODEC.decode(buf);
            map.put(e.pos(), e.opcode());
        }
        return new ProgramCardInstance(map);
    });

    public ProgramCardInstance {
        Objects.requireNonNull(gridInstances, "gridInstances cannot be null");
        gridInstances = Collections.unmodifiableMap(new LinkedHashMap<GridPos, GridInstance>(gridInstances));
    }

    public static ProgramCardInstance empty() {
        return EMPTY;
    }

    public ProgramCardInstance withGridInstance(int x, int y, GridInstance gridInstance) {
        Objects.requireNonNull(gridInstance, "gridInstance cannot be null");
        HashMap<GridPos, GridInstance> mutable = new HashMap<GridPos, GridInstance>(this.gridInstances());
        mutable.put(GridPos.pos(x, y), gridInstance);
        return new ProgramCardInstance(mutable);
    }

    public ProgramCardInstance withGridInstance(GridPos pos, GridInstance gridInstance) {
        Objects.requireNonNull(pos, "pos cannot be null");
        return this.withGridInstance(pos.x(), pos.y(), gridInstance);
    }

    public ProgramCardInstance withoutGridInstance(GridPos pos) {
        Objects.requireNonNull(pos, "pos cannot be null");
        if (!this.gridInstances.containsKey(pos)) {
            return this;
        }
        HashMap<GridPos, GridInstance> mutable = new HashMap<GridPos, GridInstance>(this.gridInstances());
        mutable.remove(pos);
        return new ProgramCardInstance(mutable);
    }

    public GridInstance gridInstanceAt(GridPos pos) {
        return this.gridInstances.get(pos);
    }

    public static ProgramCardInstance readFromJson(String json) {
        JsonElement root = JsonParser.parseString((String)json);
        HashMap<GridPos, GridInstance> map = new HashMap<GridPos, GridInstance>();
        for (JsonElement entry : root.getAsJsonArray()) {
            JsonElement posElement = entry.getAsJsonObject().get("pos");
            JsonElement gridElement = entry.getAsJsonObject().get("opcode");
            int x = posElement.getAsJsonObject().get("x").getAsInt();
            int y = posElement.getAsJsonObject().get("y").getAsInt();
            GridInstance gi = GridInstance.readFromJson(gridElement);
            if (gi == null) continue;
            map.put(GridPos.pos(x, y), gi);
        }
        return new ProgramCardInstance(map);
    }

    public String writeToJson() {
        JsonArray array = new JsonArray();
        for (Map.Entry<GridPos, GridInstance> entry : this.gridInstances().entrySet()) {
            GridPos coordinate = entry.getKey();
            GridInstance gridInstance = entry.getValue();
            JsonObject ruleObject = new JsonObject();
            ruleObject.add("pos", ProgramCardInstance.buildCoordinateElement(coordinate));
            ruleObject.add("opcode", gridInstance.getJsonElement());
            array.add((JsonElement)ruleObject);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)array);
    }

    private static JsonElement buildCoordinateElement(GridPos pos) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("x", (JsonElement)new JsonPrimitive((Number)pos.x()));
        jsonObject.add("y", (JsonElement)new JsonPrimitive((Number)pos.y()));
        return jsonObject;
    }

    private record Entry(GridPos pos, GridInstance opcode) {
    }
}

