/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.network.PacketFluidsReady;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketGetFluids(BlockPos pos, ResourceKey<Level> level, TypedMap params, boolean fromTablet) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolscontrol", (String)"getfluids");
    public static final CustomPacketPayload.Type<PacketGetFluids> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketGetFluids> CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeBlockPos(packet.pos);
        buf.writeResourceLocation(packet.level.location());
        TypedMap.STREAM_CODEC.encode(buf, (Object)packet.params);
        buf.writeBoolean(packet.fromTablet);
    }, buf -> new PacketGetFluids(buf.readBlockPos(), (ResourceKey<Level>)LevelTools.getId((ResourceLocation)buf.readResourceLocation()), (TypedMap)TypedMap.STREAM_CODEC.decode(buf), buf.readBoolean()));

    public static PacketGetFluids create(BlockPos pos, ResourceKey<Level> type, boolean fromTablet) {
        return new PacketGetFluids(pos, type, TypedMap.EMPTY, fromTablet);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockEntity te;
            ServerLevel world = LevelTools.getLevel((Level)ctx.player().getCommandSenderWorld(), this.level);
            if (world.hasChunkAt(this.pos) && (te = world.getBlockEntity(this.pos)) instanceof GenericTileEntity) {
                List list = ((GenericTileEntity)te).executeServerCommandList(ProcessorTileEntity.CMD_GETFLUIDS.name(), ctx.player(), this.params, FluidEntry.class);
                RFToolsCtrlMessages.sendToPlayer(new PacketFluidsReady(this.fromTablet ? null : this.pos, ProcessorTileEntity.CMD_GETFLUIDS.name(), list), ctx.player());
            }
        });
    }

    public static class FluidEntry {
        private final FluidStack fluidStack;
        private final boolean allocated;

        public FluidEntry(FluidStack fluidStack, boolean allocated) {
            this.fluidStack = fluidStack;
            this.allocated = allocated;
        }

        public static FluidEntry fromPacket(RegistryFriendlyByteBuf buf) {
            if (buf.readBoolean()) {
                FluidStack fluidStack = null;
                if (buf.readBoolean()) {
                    fluidStack = NetworkTools.readFluidStack((RegistryFriendlyByteBuf)buf);
                }
                boolean allocated = buf.readBoolean();
                return new FluidEntry(fluidStack, allocated);
            }
            return null;
        }

        public static void toPacket(RegistryFriendlyByteBuf buf, FluidEntry item) {
            if (item == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                if (item.getFluidStack() != null) {
                    buf.writeBoolean(true);
                    NetworkTools.writeFluidStack((RegistryFriendlyByteBuf)buf, (FluidStack)item.getFluidStack());
                } else {
                    buf.writeBoolean(false);
                }
                buf.writeBoolean(item.isAllocated());
            }
        }

        public FluidStack getFluidStack() {
            return this.fluidStack;
        }

        public boolean isAllocated() {
            return this.allocated;
        }

        public static class Serializer
        implements ISerializer<FluidEntry> {
            public Function<RegistryFriendlyByteBuf, FluidEntry> getDeserializer() {
                return FluidEntry::fromPacket;
            }

            public BiConsumer<RegistryFriendlyByteBuf, FluidEntry> getSerializer() {
                return FluidEntry::toPacket;
            }
        }
    }
}

