/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.vectorart;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mcjty.lib.client.RenderHelper;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class GfxOpBox
extends GfxOp {
    private int x;
    private int y;
    private int w;
    private int h;
    private int color;
    public static final Codec<GfxOpBox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BYTE.fieldOf("x").forGetter(o -> (byte)o.x), (App)Codec.BYTE.fieldOf("y").forGetter(o -> (byte)o.y), (App)Codec.BYTE.fieldOf("w").forGetter(o -> (byte)o.w), (App)Codec.BYTE.fieldOf("h").forGetter(o -> (byte)o.h), (App)Codec.INT.fieldOf("color").forGetter(o -> o.color)).apply((Applicative)instance, (x, y, w, h, color) -> new GfxOpBox(x.byteValue(), y.byteValue(), w.byteValue(), h.byteValue(), (int)color)));
    public static final StreamCodec<RegistryFriendlyByteBuf, GfxOpBox> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, o -> (byte)o.x, (StreamCodec)ByteBufCodecs.BYTE, o -> (byte)o.y, (StreamCodec)ByteBufCodecs.BYTE, o -> (byte)o.w, (StreamCodec)ByteBufCodecs.BYTE, o -> (byte)o.h, (StreamCodec)ByteBufCodecs.INT, o -> o.color, (x, y, w, h, color) -> new GfxOpBox(x.byteValue(), y.byteValue(), w.byteValue(), h.byteValue(), (int)color));

    public GfxOpBox() {
    }

    public GfxOpBox(int x, int y, int w, int h, int color) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.color = color;
    }

    @Override
    public void render(GuiGraphics graphics, MultiBufferSource buffer) {
        RenderHelper.drawBeveledBox((GuiGraphics)graphics, (MultiBufferSource)buffer, (int)this.x, (int)this.y, (int)(this.x + this.w - 1), (int)(this.y + this.h - 1), (int)this.color, (int)this.color, (int)this.color, (int)0xF000F0);
    }

    @Override
    public GfxOpType getType() {
        return GfxOpType.OP_BOX;
    }

    @Override
    protected void readFromNBTInternal(CompoundTag tag) {
        this.x = tag.getByte("x");
        this.y = tag.getByte("y");
        this.w = tag.getByte("w");
        this.h = tag.getByte("h");
        this.color = tag.getInt("color");
    }

    @Override
    protected void writeToNBTInternal(CompoundTag tag) {
        tag.putByte("x", (byte)this.x);
        tag.putByte("y", (byte)this.y);
        tag.putByte("w", (byte)this.w);
        tag.putByte("h", (byte)this.h);
        tag.putInt("color", this.color);
    }

    @Override
    protected void readFromBufInternal(FriendlyByteBuf buf) {
        this.x = buf.readByte();
        this.y = buf.readByte();
        this.w = buf.readByte();
        this.h = buf.readByte();
        this.color = buf.readInt();
    }

    @Override
    protected void writeToBufInternal(FriendlyByteBuf buf) {
        buf.writeByte(this.x);
        buf.writeByte(this.y);
        buf.writeByte(this.w);
        buf.writeByte(this.h);
        buf.writeInt(this.color);
    }
}

