/*
 * Decompiled with CFR 0.152.
 */
package com.reazip.economycraft.orders;

import com.reazip.economycraft.EconomyConfig;
import com.reazip.economycraft.EconomyCraft;
import com.reazip.economycraft.EconomyManager;
import com.reazip.economycraft.orders.OrderManager;
import com.reazip.economycraft.orders.OrderRequest;
import com.reazip.economycraft.util.ChatCompat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;

public final class OrdersUi {
    private OrdersUi() {
    }

    public static void open(final ServerPlayer player, final EconomyManager eco) {
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"Orders");
            }

            public AbstractContainerMenu createMenu(int id, Inventory inv, Player p) {
                return new RequestMenu(id, inv, eco.getOrders(), eco, player);
            }
        });
    }

    public static void openClaims(final ServerPlayer player, final EconomyManager eco) {
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"Deliveries");
            }

            public AbstractContainerMenu createMenu(int id, Inventory inv, Player p) {
                return new ClaimMenu(id, inv, eco, player.getUUID());
            }
        });
    }

    private static class ClaimMenu
    extends AbstractContainerMenu {
        private final EconomyManager eco;
        private final UUID owner;
        private final List<ItemStack> orderItems;
        private final List<ItemStack> shopItems;
        private final SimpleContainer container = new SimpleContainer(54);
        private final List<ItemStack> items = new ArrayList<ItemStack>();
        private int page;

        ClaimMenu(int id, Inventory inv, EconomyManager eco, UUID owner) {
            super(MenuType.GENERIC_9x6, id);
            int c;
            int r;
            this.eco = eco;
            this.owner = owner;
            this.orderItems = eco.getOrders().getDeliveries(owner);
            this.shopItems = eco.getShop().getDeliveries(owner);
            this.updatePage();
            for (int i = 0; i < 54; ++i) {
                r = i / 9;
                c = i % 9;
                final int idx = i;
                this.addSlot(new Slot(this, (Container)this.container, i, 8 + c * 18, 18 + r * 18){

                    public boolean mayPlace(ItemStack stack) {
                        return false;
                    }

                    public boolean mayPickup(Player player) {
                        return idx < 45 && super.mayPickup(player);
                    }
                });
            }
            int y = 140;
            for (r = 0; r < 3; ++r) {
                for (c = 0; c < 9; ++c) {
                    this.addSlot(new Slot((Container)inv, c + r * 9 + 9, 8 + c * 18, y + r * 18));
                }
            }
            for (int c2 = 0; c2 < 9; ++c2) {
                this.addSlot(new Slot((Container)inv, c2, 8 + c2 * 18, y + 58));
            }
        }

        private void updatePage() {
            int index;
            this.items.clear();
            this.items.addAll(this.orderItems);
            this.items.addAll(this.shopItems);
            this.container.clearContent();
            int start = this.page * 45;
            int totalPages = (int)Math.ceil((double)this.items.size() / 45.0);
            for (int i = 0; i < 45 && (index = start + i) < this.items.size(); ++i) {
                this.container.setItem(i, this.items.get(index));
            }
            if (this.page > 0) {
                ItemStack prev = new ItemStack((ItemLike)Items.ARROW);
                prev.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Previous page"));
                this.container.setItem(45, prev);
            }
            if (start + 45 < this.items.size()) {
                ItemStack next = new ItemStack((ItemLike)Items.ARROW);
                next.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Next page"));
                this.container.setItem(53, next);
            }
            ItemStack paper = new ItemStack((ItemLike)Items.PAPER);
            paper.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("Page " + (this.page + 1) + "/" + Math.max(1, totalPages))));
            this.container.setItem(49, paper);
        }

        private void removeStack(ItemStack stack) {
            this.eco.getOrders().removeDelivery(this.owner, stack);
            this.eco.getShop().removeDelivery(this.owner, stack);
        }

        public boolean stillValid(Player player) {
            return true;
        }

        public void clicked(int slot, int dragType, ClickType type, Player player) {
            if (type == ClickType.PICKUP) {
                if (slot < 45) {
                    Slot s = (Slot)this.slots.get(slot);
                    if (s.hasItem()) {
                        ItemStack stack = s.getItem();
                        ItemStack copy = stack.copy();
                        if (player.getInventory().add(copy)) {
                            this.removeStack(stack);
                            this.updatePage();
                        }
                    }
                    return;
                }
                if (slot == 45 && this.page > 0) {
                    --this.page;
                    this.updatePage();
                    return;
                }
                if (slot == 53 && (this.page + 1) * 45 < this.items.size()) {
                    ++this.page;
                    this.updatePage();
                    return;
                }
            }
            super.clicked(slot, dragType, type, player);
        }

        public ItemStack quickMoveStack(Player player, int idx) {
            Slot slot = (Slot)this.slots.get(idx);
            if (!slot.hasItem()) {
                return ItemStack.EMPTY;
            }
            ItemStack stack = slot.getItem();
            ItemStack copy = stack.copy();
            if (idx < 45) {
                if (player.getInventory().add(copy)) {
                    this.removeStack(stack);
                    this.updatePage();
                    return copy;
                }
                return ItemStack.EMPTY;
            }
            return ItemStack.EMPTY;
        }
    }

    private static class RemoveMenu
    extends AbstractContainerMenu {
        private final OrderRequest request;
        private final RequestMenu parent;
        private final SimpleContainer container = new SimpleContainer(9);

        RemoveMenu(int id, Inventory inv, OrderRequest req, RequestMenu parent) {
            super(MenuType.GENERIC_9x1, id);
            this.request = req;
            this.parent = parent;
            ItemStack confirm = new ItemStack((ItemLike)Items.LIME_STAINED_GLASS_PANE);
            confirm.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Confirm"));
            this.container.setItem(2, confirm);
            ItemStack item = req.item.copy();
            long tax = Math.round((double)req.price * EconomyConfig.get().taxRate);
            item.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)("Reward: " + EconomyCraft.formatMoney(req.price) + " (-" + EconomyCraft.formatMoney(tax) + " tax)")), Component.literal((String)("Amount: " + req.amount)), Component.literal((String)"This will remove the request"))));
            this.container.setItem(4, item);
            ItemStack cancel = new ItemStack((ItemLike)Items.RED_STAINED_GLASS_PANE);
            cancel.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Cancel"));
            this.container.setItem(6, cancel);
            for (int i = 0; i < 9; ++i) {
                this.addSlot(new Slot(this, (Container)this.container, i, 8 + i * 18, 20){

                    public boolean mayPickup(Player p) {
                        return false;
                    }
                });
            }
            int y = 40;
            for (int r = 0; r < 3; ++r) {
                for (int c = 0; c < 9; ++c) {
                    this.addSlot(new Slot((Container)inv, c + r * 9 + 9, 8 + c * 18, y + r * 18));
                }
            }
            for (int c = 0; c < 9; ++c) {
                this.addSlot(new Slot((Container)inv, c, 8 + c * 18, y + 58));
            }
        }

        public void clicked(int slot, int drag, ClickType type, Player player) {
            if (type == ClickType.PICKUP) {
                if (slot == 2) {
                    OrderRequest removed = this.parent.orders.removeRequest(this.request.id);
                    if (removed != null) {
                        ((ServerPlayer)player).sendSystemMessage((Component)Component.literal((String)"Request removed").withStyle(ChatFormatting.GREEN));
                    } else {
                        ((ServerPlayer)player).sendSystemMessage((Component)Component.literal((String)"Request no longer available").withStyle(ChatFormatting.RED));
                    }
                    player.closeContainer();
                    OrdersUi.open((ServerPlayer)player, this.parent.eco);
                    return;
                }
                if (slot == 6) {
                    player.closeContainer();
                    OrdersUi.open((ServerPlayer)player, this.parent.eco);
                    return;
                }
            }
            super.clicked(slot, drag, type, player);
        }

        public boolean stillValid(Player player) {
            return true;
        }

        public ItemStack quickMoveStack(Player player, int idx) {
            return ItemStack.EMPTY;
        }
    }

    private static class ConfirmMenu
    extends AbstractContainerMenu {
        private final OrderRequest request;
        private final RequestMenu parent;
        private final SimpleContainer container = new SimpleContainer(9);

        ConfirmMenu(int id, Inventory inv, OrderRequest req, RequestMenu parent) {
            super(MenuType.GENERIC_9x1, id);
            this.request = req;
            this.parent = parent;
            ItemStack confirm = new ItemStack((ItemLike)Items.LIME_STAINED_GLASS_PANE);
            confirm.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Confirm"));
            this.container.setItem(2, confirm);
            ItemStack item = req.item.copy();
            String name = parent.viewer.getServer().getProfileCache().get(req.requester).map(p -> p.getName()).orElse(req.requester.toString());
            long tax = Math.round((double)req.price * EconomyConfig.get().taxRate);
            item.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)("Reward: " + EconomyCraft.formatMoney(req.price) + " (-" + EconomyCraft.formatMoney(tax) + " tax)")), Component.literal((String)("Requester: " + name)), Component.literal((String)("Amount: " + req.amount)))));
            this.container.setItem(4, item);
            ItemStack cancel = new ItemStack((ItemLike)Items.RED_STAINED_GLASS_PANE);
            cancel.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Cancel"));
            this.container.setItem(6, cancel);
            for (int i = 0; i < 9; ++i) {
                this.addSlot(new Slot(this, (Container)this.container, i, 8 + i * 18, 20){

                    public boolean mayPickup(Player p) {
                        return false;
                    }
                });
            }
            int y = 40;
            for (int r = 0; r < 3; ++r) {
                for (int c = 0; c < 9; ++c) {
                    this.addSlot(new Slot((Container)inv, c + r * 9 + 9, 8 + c * 18, y + r * 18));
                }
            }
            for (int c = 0; c < 9; ++c) {
                this.addSlot(new Slot((Container)inv, c, 8 + c * 18, y + 58));
            }
        }

        public void clicked(int slot, int drag, ClickType type, Player player) {
            if (type == ClickType.PICKUP) {
                if (slot == 2) {
                    OrderRequest current = this.parent.orders.getRequest(this.request.id);
                    if (current == null) {
                        ((ServerPlayer)player).sendSystemMessage((Component)Component.literal((String)"Request no longer available").withStyle(ChatFormatting.RED));
                    } else if (!this.parent.hasItems((ServerPlayer)player, current.item, current.amount)) {
                        ((ServerPlayer)player).sendSystemMessage((Component)Component.literal((String)"Not enough items").withStyle(ChatFormatting.RED));
                    } else {
                        long cost = current.price;
                        long bal = this.parent.eco.getBalance(current.requester, true);
                        if (bal < cost) {
                            ((ServerPlayer)player).sendSystemMessage((Component)Component.literal((String)"Requester can't pay").withStyle(ChatFormatting.RED));
                        } else {
                            int c;
                            this.parent.removeItems((ServerPlayer)player, current.item.copy(), current.amount);
                            long tax = Math.round((double)cost * EconomyConfig.get().taxRate);
                            this.parent.eco.removeMoney(current.requester, cost);
                            this.parent.eco.addMoney(player.getUUID(), cost - tax);
                            this.parent.orders.removeRequest(current.id);
                            for (int remaining = current.amount; remaining > 0; remaining -= c) {
                                c = Math.min(current.item.getMaxStackSize(), remaining);
                                this.parent.orders.addDelivery(current.requester, new ItemStack((ItemLike)current.item.getItem(), c));
                            }
                            ((ServerPlayer)player).sendSystemMessage((Component)Component.literal((String)("Fulfilled request for " + current.amount + "x " + current.item.getHoverName().getString() + " and earned " + EconomyCraft.formatMoney(cost - tax))).withStyle(ChatFormatting.GREEN));
                            ServerPlayer requesterPlayer = this.parent.viewer.getServer().getPlayerList().getPlayer(current.requester);
                            if (requesterPlayer != null) {
                                ClickEvent ev = ChatCompat.runCommandEvent("/eco orders claim");
                                if (ev != null) {
                                    MutableComponent msg = Component.literal((String)("Your request for " + current.amount + "x " + current.item.getHoverName().getString() + " has been fulfilled: ")).withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)"[Claim]").withStyle(s -> s.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.GREEN).withClickEvent(ev)));
                                    requesterPlayer.sendSystemMessage((Component)msg);
                                } else {
                                    ChatCompat.sendRunCommandTellraw(requesterPlayer, "Your request for " + current.amount + "x " + current.item.getHoverName().getString() + " has been fulfilled: ", "[Claim]", "/eco orders claim");
                                }
                            }
                            this.parent.requests.removeIf(r -> r.id == current.id);
                            this.parent.updatePage();
                        }
                    }
                    player.closeContainer();
                    OrdersUi.open((ServerPlayer)player, this.parent.eco);
                    return;
                }
                if (slot == 6) {
                    player.closeContainer();
                    OrdersUi.open((ServerPlayer)player, this.parent.eco);
                    return;
                }
            }
            super.clicked(slot, drag, type, player);
        }

        public boolean stillValid(Player player) {
            return true;
        }

        public ItemStack quickMoveStack(Player player, int idx) {
            return ItemStack.EMPTY;
        }
    }

    private static class RequestMenu
    extends AbstractContainerMenu {
        private final OrderManager orders;
        private final EconomyManager eco;
        private final ServerPlayer viewer;
        private List<OrderRequest> requests = new ArrayList<OrderRequest>();
        private final SimpleContainer container = new SimpleContainer(54);
        private int page;
        private final Runnable listener = this::updatePage;

        RequestMenu(int id, Inventory inv, OrderManager orders, EconomyManager eco, ServerPlayer viewer) {
            super(MenuType.GENERIC_9x6, id);
            int c;
            int r;
            this.orders = orders;
            this.eco = eco;
            this.viewer = viewer;
            this.updatePage();
            orders.addListener(this.listener);
            for (int i = 0; i < 54; ++i) {
                r = i / 9;
                c = i % 9;
                this.addSlot(new Slot(this, (Container)this.container, i, 8 + c * 18, 18 + r * 18){

                    public boolean mayPickup(Player player) {
                        return false;
                    }

                    public boolean mayPlace(ItemStack stack) {
                        return false;
                    }
                });
            }
            int y = 140;
            for (r = 0; r < 3; ++r) {
                for (c = 0; c < 9; ++c) {
                    this.addSlot(new Slot((Container)inv, c + r * 9 + 9, 8 + c * 18, y + r * 18));
                }
            }
            for (int c2 = 0; c2 < 9; ++c2) {
                this.addSlot(new Slot((Container)inv, c2, 8 + c2 * 18, y + 58));
            }
        }

        private void updatePage() {
            int index;
            this.requests = new ArrayList<OrderRequest>(this.orders.getRequests());
            this.container.clearContent();
            int start = this.page * 45;
            int totalPages = (int)Math.ceil((double)this.requests.size() / 45.0);
            for (int i = 0; i < 45 && (index = start + i) < this.requests.size(); ++i) {
                OrderRequest r = this.requests.get(index);
                ItemStack display = r.item.copy();
                String reqName = this.viewer.getServer().getProfileCache().get(r.requester).map(p -> p.getName()).orElse(r.requester.toString());
                long tax = Math.round((double)r.price * EconomyConfig.get().taxRate);
                display.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)("Reward: " + EconomyCraft.formatMoney(r.price) + " (-" + EconomyCraft.formatMoney(tax) + " tax)")), Component.literal((String)("Requester: " + reqName)), Component.literal((String)("Amount: " + r.amount)))));
                display.setCount(1);
                this.container.setItem(i, display);
            }
            if (this.page > 0) {
                ItemStack prev = new ItemStack((ItemLike)Items.ARROW);
                prev.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Previous page"));
                this.container.setItem(45, prev);
            }
            if (start + 45 < this.requests.size()) {
                ItemStack next = new ItemStack((ItemLike)Items.ARROW);
                next.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Next page"));
                this.container.setItem(53, next);
            }
            ItemStack paper = new ItemStack((ItemLike)Items.PAPER);
            paper.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("Page " + (this.page + 1) + "/" + Math.max(1, totalPages))));
            this.container.setItem(49, paper);
        }

        public void clicked(int slot, int dragType, ClickType type, Player player) {
            if (type == ClickType.PICKUP) {
                int index;
                if (slot < 45 && (index = this.page * 45 + slot) < this.requests.size()) {
                    OrderRequest req = this.requests.get(index);
                    if (req.requester.equals(player.getUUID())) {
                        this.openRemove((ServerPlayer)player, req);
                    } else {
                        this.openConfirm((ServerPlayer)player, req);
                    }
                    return;
                }
                if (slot == 45 && this.page > 0) {
                    --this.page;
                    this.updatePage();
                    return;
                }
                if (slot == 53 && (this.page + 1) * 45 < this.requests.size()) {
                    ++this.page;
                    this.updatePage();
                    return;
                }
            }
            super.clicked(slot, dragType, type, player);
        }

        private boolean hasItems(ServerPlayer player, ItemStack proto, int amount) {
            int total = 0;
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack s = player.getInventory().getItem(i);
                if (!s.is(proto.getItem())) continue;
                total += s.getCount();
            }
            return total >= amount;
        }

        private void removeItems(ServerPlayer player, ItemStack proto, int amount) {
            int remaining = amount;
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack s = player.getInventory().getItem(i);
                if (!s.is(proto.getItem())) continue;
                int take = Math.min(s.getCount(), remaining);
                s.shrink(take);
                if ((remaining -= take) > 0) continue;
                return;
            }
        }

        private void openConfirm(ServerPlayer player, final OrderRequest req) {
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Confirm");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inv, Player p) {
                    return new ConfirmMenu(id, inv, req, this);
                }
            });
        }

        private void openRemove(ServerPlayer player, final OrderRequest req) {
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Remove");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inv, Player p) {
                    return new RemoveMenu(id, inv, req, this);
                }
            });
        }

        public boolean stillValid(Player player) {
            return true;
        }

        public void removed(Player player) {
            super.removed(player);
            this.orders.removeListener(this.listener);
        }

        public ItemStack quickMoveStack(Player player, int idx) {
            return ItemStack.EMPTY;
        }
    }
}

