/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.vanilla_input;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.vanilla_input.ItemChemicalRecipeInput;
import net.minecraft.world.item.ItemStack;

@NothingNullByDefault
public record SingleItemChemicalRecipeInput(ItemStack item, ChemicalStack chemical) implements ItemChemicalRecipeInput
{
    public ItemStack getItem(int index) {
        if (index != 0) {
            throw new IllegalArgumentException("No item for index " + index);
        }
        return this.item;
    }

    @Override
    public ChemicalStack getChemical(int index) {
        if (index != 0) {
            throw new IllegalArgumentException("No chemical for index " + index);
        }
        return this.chemical;
    }

    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.item.isEmpty() || this.chemical.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleItemChemicalRecipeInput other = (SingleItemChemicalRecipeInput)o;
        return this.chemical.equals(other.chemical) && ItemStack.matches((ItemStack)this.item, (ItemStack)other.item);
    }

    @Override
    public int hashCode() {
        int hash = this.chemical.hashCode();
        hash = 31 * hash + ItemStack.hashItemAndComponents((ItemStack)this.item);
        hash = 31 + hash + this.item.getCount();
        return hash;
    }
}

