/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.lib.effect.BillboardingEffectRenderer;
import mekanism.client.render.lib.effect.BoltRenderer;
import mekanism.client.render.tileentity.MultiblockTileEntityRenderer;
import mekanism.common.content.sps.SPSMultiblockData;
import mekanism.common.lib.Color;
import mekanism.common.lib.effect.BoltEffect;
import mekanism.common.lib.effect.CustomEffect;
import mekanism.common.lib.math.Plane;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.particle.SPSOrbitEffect;
import mekanism.common.tile.multiblock.TileEntitySPSCasing;
import mekanism.common.util.MekanismUtils;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;

@NothingNullByDefault
public class RenderSPS
extends MultiblockTileEntityRenderer<SPSMultiblockData, TileEntitySPSCasing> {
    private static final CustomEffect CORE = (CustomEffect)Util.make((Object)new CustomEffect(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "energy_effect.png")), core -> core.setColor(Color.rgbai(255, 255, 255, 240)));
    private static final Map<UUID, BoltRenderer> boltRendererMap = new HashMap<UUID, BoltRenderer>();
    private static final float MIN_SCALE = 0.1f;
    private static final float MAX_SCALE = 4.0f;
    private static final RandomSource rand = RandomSource.create();

    public static void clearBoltRenderers() {
        boltRendererMap.clear();
    }

    public RenderSPS(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void render(TileEntitySPSCasing tile, SPSMultiblockData multiblock, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        BoltRenderer bolts = boltRendererMap.computeIfAbsent(multiblock.inventoryID, mb -> new BoltRenderer());
        Vec3 center = Vec3.atLowerCornerOf((Vec3i)multiblock.getMinPos()).add(Vec3.atLowerCornerOf((Vec3i)multiblock.getMaxPos())).add(new Vec3(1.0, 1.0, 1.0)).scale(0.5);
        Vec3 renderCenter = center.subtract((double)tile.getBlockPos().getX(), (double)tile.getBlockPos().getY(), (double)tile.getBlockPos().getZ());
        boolean tickingNormally = this.isTickingNormally(tile);
        if (tickingNormally) {
            for (SPSMultiblockData.CoilData data : multiblock.coilData.coilMap.values()) {
                if (data.prevLevel <= 0) continue;
                bolts.update(data.coilPos.hashCode(), RenderSPS.getBoltFromData(data, tile.getBlockPos(), renderCenter), partialTick);
            }
        }
        float energyScale = RenderSPS.getEnergyScale(multiblock.lastProcessed);
        int targetEffectCount = 0;
        if (tickingNormally && multiblock.lastReceivedEnergy > 0L) {
            if (rand.nextDouble() < (double)RenderSPS.getBoundedScale(energyScale, 0.01f, 0.4f)) {
                VoxelCuboid.CuboidSide side = (VoxelCuboid.CuboidSide)((Object)Util.getRandom((Object[])VoxelCuboid.CuboidSide.SIDES, (RandomSource)rand));
                Plane plane = Plane.getInnerCuboidPlane(multiblock.getBounds(), side);
                Vec3 endPos = plane.getRandomPoint(rand).subtract((double)tile.getBlockPos().getX(), (double)tile.getBlockPos().getY(), (double)tile.getBlockPos().getZ());
                BoltEffect bolt = new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, renderCenter, endPos, 15).size(0.01f * RenderSPS.getBoundedScale(energyScale, 0.5f, 5.0f)).lifespan(8).spawn(BoltEffect.SpawnFunction.NO_DELAY);
                bolts.update(31 * side.hashCode() + endPos.hashCode(), bolt, partialTick);
            }
            targetEffectCount = (int)RenderSPS.getBoundedScale(energyScale, 10.0f, 120.0f);
        }
        if (tile.orbitEffects.size() > targetEffectCount) {
            tile.orbitEffects.poll();
        } else if (tile.orbitEffects.size() < targetEffectCount && rand.nextDouble() < 0.5) {
            tile.orbitEffects.add(new SPSOrbitEffect(multiblock, center));
        }
        bolts.render(partialTick, matrix, renderer);
        if (multiblock.lastProcessed > 0.0) {
            float scale = RenderSPS.getBoundedScale(energyScale, 0.1f, 4.0f);
            BillboardingEffectRenderer.render(CORE.getTexture(), "supercriticalPhaseShifter.core", () -> {
                CORE.setPos(center);
                CORE.setScale(scale);
                return CORE;
            });
        }
        for (SPSOrbitEffect effect : tile.orbitEffects) {
            BillboardingEffectRenderer.render(effect, "supercriticalPhaseShifter.orbitEffect");
        }
    }

    private static float getEnergyScale(double lastProcessed) {
        return (float)Math.min(1.0, Math.max(0.0, (Math.log10(lastProcessed) + 2.0) / 4.0));
    }

    private static float getBoundedScale(float scale, float min, float max) {
        return min + scale * (max - min);
    }

    private static BoltEffect getBoltFromData(SPSMultiblockData.CoilData data, BlockPos pos, Vec3 center) {
        Vec3 start = data.coilPos.relative(data.side).getCenter();
        start = start.add(Vec3.atLowerCornerOf((Vec3i)data.side.getNormal()).scale(0.5));
        int count = 1 + (data.prevLevel - 1) / 2;
        float size = 0.01f * (float)data.prevLevel;
        return new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, start.subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), center, 15).count(count).size(size).lifespan(8).spawn(BoltEffect.SpawnFunction.delay(4.0f));
    }

    @Override
    protected String getProfilerSection() {
        return "supercriticalPhaseShifter";
    }

    @Override
    protected boolean shouldRender(TileEntitySPSCasing tile, SPSMultiblockData multiblock, Vec3 camera) {
        return super.shouldRender(tile, multiblock, camera) && multiblock.getBounds() != null;
    }
}

