/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.IdentityHashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class SignPostBlockTileRenderer
implements BlockEntityRenderer<SignPostBlockTile> {
    public static final Map<WoodType, BakedModel> MODELS = new IdentityHashMap<WoodType, BakedModel>();
    private static ModelBlockRenderer renderer;
    private final Font font;

    public SignPostBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.getFont();
        ModelManager manager = Minecraft.getInstance().getModelManager();
        MODELS.clear();
        for (Map.Entry<WoodType, ModelResourceLocation> e : ClientRegistry.WAY_SIGN_MODELS.get().entrySet()) {
            MODELS.put(e.getKey(), ClientHelper.getModel((ModelManager)manager, (ModelResourceLocation)e.getValue()));
        }
        renderer = Minecraft.getInstance().getBlockRenderer().getModelRenderer();
    }

    public AABB getRenderBoundingBox(BlockEntity tile) {
        return new AABB(tile.getBlockPos()).inflate(0.1);
    }

    public int getViewDistance() {
        return 32;
    }

    public void render(SignPostBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        SignPostBlockTile.Sign signUp = tile.getSignUp();
        SignPostBlockTile.Sign signDown = tile.getSignDown();
        boolean up = signUp.active();
        boolean down = signDown.active();
        if (up || down) {
            TextUtil.RenderProperties textProperties;
            LOD lod = LOD.at((BlockEntity)tile);
            if (!lod.isNear()) {
                return;
            }
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            Vec3 offsetFromCenter = new Vec3(0.0, 0.0, 0.125);
            if (up && !lod.isPlaneCulled(signUp.getNormal(), offsetFromCenter, 0.0f)) {
                Vector3f v = new Vector3f(1.0f, 0.0f, 0.0f);
                v.rotateY(signUp.yaw() * ((float)Math.PI / 180));
                textProperties = tile.getTextHolder(0).computeRenderProperties(combinedLightIn, v, () -> ((LOD)lod).isVeryNear());
                this.renderSignText(tile, poseStack, bufferIn, signUp, textProperties, 0);
            }
            if (down && !lod.isPlaneCulled(signDown.getNormal(), offsetFromCenter, 0.0f)) {
                Vector3f normalVector = new Vector3f(1.0f, 0.0f, 0.0f);
                normalVector.rotateY(signUp.yaw() * ((float)Math.PI / 180));
                textProperties = tile.getTextHolder(1).computeRenderProperties(combinedLightIn, normalVector, () -> ((LOD)lod).isVeryNear());
                poseStack.translate(0.0, -0.5, 0.0);
                this.renderSignText(tile, poseStack, bufferIn, signDown, textProperties, 1);
            }
            poseStack.popPose();
        }
    }

    private void renderSignText(SignPostBlockTile tile, PoseStack matrixStackIn, MultiBufferSource bufferIn, SignPostBlockTile.Sign sign, TextUtil.RenderProperties textProperties, int line) {
        matrixStackIn.pushPose();
        boolean left = sign.left();
        int o = left ? 1 : -1;
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(sign.yaw() - 90.0f));
        float zOffset = tile.getOffset() - 0.5f + 0.0625f;
        matrixStackIn.translate(-0.03125 * (double)o, 0.28125, (double)zOffset + 0.005);
        matrixStackIn.scale(0.010416667f, -0.010416667f, 0.010416667f);
        TextUtil.renderLine((FormattedCharSequence)tile.getTextHolder(line).getRenderMessages(0, this.font), (Font)this.font, (float)-4.0f, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (TextUtil.RenderProperties)textProperties);
        matrixStackIn.popPose();
    }

    public static void renderSigns(PoseStack poseStack, VertexConsumer builder, int combinedLightIn, int combinedOverlayIn, SignPostBlockTile.Sign signUp, SignPostBlockTile.Sign signDown, Float zOffset) {
        boolean up = signUp.active();
        boolean down = signDown.active();
        if (up || down) {
            poseStack.pushPose();
            if (down) {
                SignPostBlockTileRenderer.renderSign(poseStack, builder, combinedLightIn, combinedOverlayIn, signDown, zOffset);
            }
            if (up) {
                poseStack.translate(0.0, 0.5, 0.0);
                SignPostBlockTileRenderer.renderSign(poseStack, builder, combinedLightIn, combinedOverlayIn, signUp, zOffset);
            }
            poseStack.popPose();
        }
    }

    public static void renderSign(PoseStack posestack, VertexConsumer builder, int light, int overlay, SignPostBlockTile.Sign sign, Float zOffset) {
        posestack.pushPose();
        boolean left = sign.left();
        posestack.translate(0.5, 0.5, 0.5);
        posestack.mulPose(Axis.YP.rotationDegrees(sign.yaw() - 90.0f));
        float z = -0.625f;
        if (zOffset != null) {
            z += zOffset.floatValue();
        }
        posestack.translate(0.0f, 0.0f, z);
        if (!left) {
            posestack.mulPose(RotHlpr.YN180);
            posestack.translate(0.0, 0.0, -0.3125);
        }
        posestack.translate(-0.5, -0.5, -0.25);
        renderer.renderModel(posestack.last(), builder, null, MODELS.get(sign.woodType()), 1.0f, 1.0f, 1.0f, light, overlay);
        posestack.popPose();
    }
}

