/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.placeable_book;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSLColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;

public record BookModelVisuals(ModelResourceLocation model, HSVColor color, float hueShift, boolean hasGlint) {
    public static final Codec<Either<Integer, DyeColor>> COLOR_CODEC = Codec.either((Codec)ColorUtils.CODEC, (Codec)DyeColor.CODEC);
    public static final Codec<BookModelVisuals> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.xmap(RenderUtil::getStandaloneModelLocation, ModelResourceLocation::id).fieldOf("model").forGetter(BookModelVisuals::model), (App)COLOR_CODEC.optionalFieldOf("color", (Object)Either.left((Object)-1)).forGetter(b -> Either.left((Object)b.color.asRGB().toInt())), (App)Codec.FLOAT.optionalFieldOf("neighbor_hue_shift", (Object)Float.valueOf(1.0f)).forGetter(b -> Float.valueOf(b.hueShift)), (App)Codec.BOOL.optionalFieldOf("has_glint", (Object)false).forGetter(BookModelVisuals::hasGlint)).apply((Applicative)instance, (modelResourceLocation, color, aFloat, aBoolean) -> (BookModelVisuals)color.map(integer -> new BookModelVisuals((ModelResourceLocation)modelResourceLocation, (int)integer, aFloat.floatValue(), (boolean)aBoolean), dyeColor -> new BookModelVisuals((ModelResourceLocation)modelResourceLocation, (DyeColor)dyeColor, aFloat.floatValue(), (boolean)aBoolean))));

    public BookModelVisuals(ModelResourceLocation res, int color, float hueShift, boolean hasGlint) {
        this(res, new RGBColor(color).asHSV(), hueShift, hasGlint);
    }

    public BookModelVisuals(ModelResourceLocation res, DyeColor color, float hueShift, boolean hasGlint) {
        this(res, color.getTextureDiffuseColor(), hueShift, hasGlint);
    }

    private static float getAllowedHueShift(HSVColor color) {
        float v = color.value();
        float minAngle = 0.19444445f;
        float addAngle = 0.18055555f;
        return minAngle + addAngle * (1.0f - v);
    }

    private static float getLegacyAllowedHueShift(HSLColor color) {
        float l = color.lightness();
        float s = ColorHelper.normalizeHSLSaturation(color.saturation(), l);
        float minAngle = 0.25f;
        float addAngle = 0.18055555f;
        float distLightSq = 2.0f;
        float distDarkSq = s * s + l * l;
        float distSq = Math.min(1.0f, Math.min(distDarkSq, distLightSq));
        return minAngle + (1.0f - distSq) * addAngle;
    }

    public boolean looksGoodNextTo(BookModelVisuals other) {
        float diff = Math.abs(Mth.degreesDifference((float)(this.color.hue() * 360.0f), (float)(other.color.hue() * 360.0f)) / 360.0f);
        return diff < (other.hueShift + this.hueShift) / 2.0f;
    }

    public record VariantModelList(DataComponentMap itemComponents, List<BookModelVisuals> models) {
        private static final Codec<VariantModelList> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DataComponentMap.CODEC.optionalFieldOf("item_components", (Object)DataComponentMap.EMPTY).forGetter(VariantModelList::itemComponents), (App)CODEC.listOf().fieldOf("models").forGetter(VariantModelList::models)).apply((Applicative)instance, VariantModelList::new)).validate(v -> {
            if (v.models.isEmpty()) {
                return DataResult.error(() -> "VariantModelList must have at least one model");
            }
            return DataResult.success((Object)v);
        });
        public static final Codec<List<VariantModelList>> LIST_CODEC = CODEC.listOf().fieldOf("variants").codec();

        public boolean matchesComponents(DataComponentMap other) {
            for (TypedDataComponent entry : this.itemComponents) {
                DataComponentType type = entry.type();
                Object otherValue = other.get(type);
                Object myValue = entry.value();
                if (Objects.equals(myValue, otherValue)) continue;
                return false;
            }
            return true;
        }
    }
}

