/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import org.jetbrains.annotations.Nullable;

public final class SafeOwner
implements TooltipProvider {
    private static final MutableComponent BOUND = Component.translatable((String)"message.supplementaries.safe.bound").withStyle(ChatFormatting.GRAY);
    private static final MutableComponent UNBOUND = Component.translatable((String)"message.supplementaries.safe.unbound").withStyle(ChatFormatting.GRAY);
    public static final Codec<SafeOwner> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.optionalFieldOf("owner").forGetter(s -> Optional.ofNullable(s.owner)), (App)Codec.STRING.optionalFieldOf("password").forGetter(s -> Optional.ofNullable(s.password)), (App)Codec.STRING.optionalFieldOf("owner").forGetter(s -> Optional.ofNullable(s.ownerName))).apply((Applicative)instance, SafeOwner::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SafeOwner> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), s -> Optional.ofNullable(s.owner), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), s -> Optional.ofNullable(s.ownerName), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), s -> Optional.ofNullable(s.password), SafeOwner::new);
    @Nullable
    private final UUID owner;
    @Nullable
    private final String ownerName;
    @Nullable
    private final String password;

    SafeOwner(Optional<UUID> owner, Optional<String> ownerName, Optional<String> password) {
        this.owner = owner.orElse(null);
        this.ownerName = ownerName.orElse(null);
        this.password = password.orElse(null);
    }

    @Nullable
    public static SafeOwner of(@Nullable UUID owner, @Nullable String ownerName, @Nullable String password) {
        if (owner == null && password == null) {
            return null;
        }
        return new SafeOwner(Optional.ofNullable(owner), Optional.ofNullable(ownerName), Optional.ofNullable(password));
    }

    @Nullable
    public String ownerName() {
        return this.ownerName;
    }

    @Nullable
    public UUID owner() {
        return this.owner;
    }

    @Nullable
    public String password() {
        return this.password;
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
            if (this.owner != null && !this.owner.equals(Minecraft.getInstance().player.getUUID())) {
                if (this.ownerName != null) {
                    tooltipAdder.accept((Component)Component.translatable((String)"message.supplementaries.safe.owner", (Object[])new Object[]{this.ownerName}).withStyle(ChatFormatting.GRAY));
                }
                return;
            }
            return;
        }
        if (this.password != null) {
            tooltipAdder.accept((Component)BOUND);
            return;
        }
        tooltipAdder.accept((Component)UNBOUND);
    }

    public boolean canPlayerOpen(Player player) {
        if (player == null || player.isCreative()) {
            return true;
        }
        if (CommonConfigs.Functional.SAFE_SIMPLE.get().booleanValue()) {
            return !this.isNotOwnedBy(player);
        }
        return ItemsUtil.getPlayerKeyStatus(player, this.password).isCorrect();
    }

    private boolean isNotOwnedBy(Player player) {
        return this.owner != null && !this.owner.equals(player.getUUID());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafeOwner)) {
            return false;
        }
        SafeOwner safeOwner = (SafeOwner)o;
        return Objects.equals(this.owner, safeOwner.owner) && Objects.equals(this.ownerName, safeOwner.ownerName) && Objects.equals(this.password, safeOwner.password);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.ownerName, this.password);
    }
}

