/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.neoforge;

import io.netty.buffer.ByteBuf;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.neoforge.ForgeConfigHolder;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.mixins.neoforge.FireBlockAccessor;
import net.mehvahdjukaar.supplementaries.mixins.neoforge.ItemStackAccessor;
import net.mehvahdjukaar.supplementaries.neoforge.CapabilityHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppPlatformStuffImpl {
    @Nullable
    public static <T> T getForgeCap(Entity entity, Class<T> capClass) {
        BaseCapability<?, ?> t = CapabilityHandler.getToken(capClass);
        if (t != null) {
            return (T)entity.getCapability((EntityCapability)t);
        }
        return null;
    }

    @Nullable
    public static <T> T getForgeCap(Level level, BlockPos pos, Class<T> capClass) {
        BaseCapability<?, ?> t = CapabilityHandler.getToken(capClass);
        if (t != null) {
            return (T)level.getCapability((BlockCapability)t, pos);
        }
        return null;
    }

    @Nullable
    public static <T> T getForgeCap(BlockEntity object, Class<T> capClass) {
        BaseCapability<?, ?> t = CapabilityHandler.getToken(capClass);
        if (t != null) {
            return (T)object.getLevel().getCapability((BlockCapability)t, object.getBlockPos(), object.getBlockState(), object);
        }
        return null;
    }

    @Nullable
    public static BlockState getUnoxidised(Level level, BlockPos pos, BlockState state) {
        BlockState newMod;
        Player fp = FakePlayerManager.getDefault((Level)level);
        fp.setItemInHand(InteractionHand.MAIN_HAND, Items.IRON_AXE.getDefaultInstance());
        Block b = state.getBlock();
        UseOnContext context = new UseOnContext(fp, InteractionHand.MAIN_HAND, new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.UP, pos, false));
        BlockState modified = state;
        modified = b.getToolModifiedState(modified, context, ItemAbilities.AXE_WAX_OFF, false);
        if (modified == null) {
            modified = state;
        }
        while ((newMod = b.getToolModifiedState(modified, context, ItemAbilities.AXE_SCRAPE, false)) != null && newMod != modified) {
            modified = newMod;
        }
        if (modified == state) {
            return null;
        }
        return modified;
    }

    public static boolean isEndermanMask(@NotNull EnderMan enderMan, Player player, ItemStack itemstack) {
        try {
            if (itemstack.isEnderMask(player, enderMan)) {
                return true;
            }
            Level level = player.level();
            if (CompatObjects.END_VEIL.isPresent((HolderLookup.Provider)level.registryAccess())) {
                ItemEnchantments ench = (ItemEnchantments)itemstack.get(DataComponents.ENCHANTMENTS);
                return ench != null && ench.getLevel(CompatObjects.END_VEIL.getHolder(level)) > 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static int getItemLifeSpawn(ItemEntity itemEntity) {
        return itemEntity.lifespan;
    }

    public static void fireItemPickupPost(Player player, ItemEntity itemEntity, ItemStack copy) {
        EventHooks.fireItemPickupPost((ItemEntity)itemEntity, (Player)player, (ItemStack)copy);
    }

    public static CreativeModeTab.Builder searchBar(CreativeModeTab.Builder c) {
        return c.withSearchBar();
    }

    public static float getDownfall(Biome biome) {
        return biome.getModifiedClimateSettings().downfall();
    }

    public static void disableAMWarn() {
        ((ModConfigSpec.BooleanValue)ClientConfigs.General.NO_AMENDMENTS_WARN).set((Object)true);
        ForgeConfigHolder fg = (ForgeConfigHolder)ClientConfigs.CONFIG_HOLDER;
        fg.getSpec().save();
    }

    public static void disableIMWarn() {
        ((ModConfigSpec.BooleanValue)ClientConfigs.General.NO_INCOMPATIBLE_MODS).set((Object)true);
        ForgeConfigHolder fg = (ForgeConfigHolder)ClientConfigs.CONFIG_HOLDER;
        fg.getSpec().save();
    }

    public static void disableOFWarn(boolean on) {
        ((ModConfigSpec.BooleanValue)ClientConfigs.General.NO_OPTIFINE_WARN).set((Object)on);
        ForgeConfigHolder fg = (ForgeConfigHolder)ClientConfigs.CONFIG_HOLDER;
        fg.getSpec().save();
    }

    public static boolean canStickTo(BlockState movedState, BlockState blockState) {
        return movedState.canStickTo(blockState);
    }

    public static SlotReference getFirstInInventory(LivingEntity entity, Predicate<ItemStack> predicate) {
        IItemHandler cap = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY);
        if (cap != null) {
            for (int i = 0; i < cap.getSlots(); ++i) {
                ItemStack itemInSlot = cap.getStackInSlot(i);
                if (!predicate.test(itemInSlot)) continue;
                return new CapSlotReference(i);
            }
        }
        return SlotReference.EMPTY;
    }

    public static FoodProperties getFoodProperties(ItemStack selected, LivingEntity entity) {
        return selected.getFoodProperties(entity);
    }

    public static SoundType getSoundType(BlockState blockState, BlockPos pos, Level level, Entity entity) {
        return blockState.getSoundType((LevelReader)level, pos, entity);
    }

    public static void setParticlePos(BlockParticleOption blockParticleOption, BlockPos pos) {
        blockParticleOption.setPos(pos);
    }

    public static boolean canCatchFire(Level level, BlockPos below, Direction direction) {
        return ((FireBlock)Blocks.FIRE).canCatchFire((BlockGetter)level, below, direction);
    }

    public static void tryBurningByFire(ServerLevel level, BlockPos pos, int chance, RandomSource random, int age, Direction direction) {
        ((FireBlockAccessor)Blocks.FIRE).invokeTryCatchFire((Level)level, pos, chance, random, age, direction);
    }

    public static InteractionResultHolder<ItemStack> fireItemRightClickEvent(Player player, InteractionHand hand) {
        InteractionResult r = CommonHooks.onItemRightClick((Player)player, (InteractionHand)hand);
        if (r == null) {
            r = InteractionResult.PASS;
        }
        return new InteractionResultHolder(r, (Object)player.getItemInHand(hand));
    }

    public static void dispenseContent(DispensibleContainerItem dc, ItemStack stack, BlockHitResult hit, Level level, @Nullable Player player) {
        dc.emptyContents(player, level, hit.getBlockPos(), hit, stack);
    }

    public static void releaseUsingItem(ItemStack stack, LivingEntity entity) {
        if (!EventHooks.onUseItemStop((LivingEntity)entity, (ItemStack)stack, (int)entity.getUseItemRemainingTicks())) {
            ItemStack copy = entity instanceof Player ? stack.copy() : null;
            stack.releaseUsing(entity.level(), entity, entity.getUseItemRemainingTicks());
            if (copy != null && stack.isEmpty()) {
                EventHooks.onPlayerDestroyItem((Player)((Player)entity), (ItemStack)copy, (InteractionHand)entity.getUsedItemHand());
            }
        }
        stack.onStopUsing(entity, entity.getUseItemRemainingTicks());
    }

    public static ItemStack finishUsingItem(ItemStack item, Level level, LivingEntity entity) {
        return EventHooks.onItemUseFinish((LivingEntity)entity, (ItemStack)item.copy(), (int)entity.getUseItemRemainingTicks(), (ItemStack)item.finishUsingItem(level, entity));
    }

    public static float getGrowthSpeed(BlockState state, ServerLevel level, BlockPos pos) {
        return CropAccessor.callGetGrowthSpeed(state, level, pos);
    }

    public static InteractionResult placeBlockItem(BlockItem bi, BlockPlaceContext context) {
        ItemStack stack = context.getItemInHand();
        return !context.getLevel().isClientSide ? CommonHooks.onPlaceItemIntoWorld((UseOnContext)context) : ((ItemStackAccessor)stack).invokeOnItemUse((UseOnContext)context, c -> bi.place(context));
    }

    public static void init() {
        RegHelper.register((ResourceLocation)Supplementaries.res("mod_cap"), () -> CapSlotReference.CODEC, SlotReference.TYPE_REGISTRY_KEY);
    }

    public record CapSlotReference(int slot) implements SlotReference
    {
        public static final StreamCodec<ByteBuf, CapSlotReference> CODEC = ByteBufCodecs.VAR_INT.map(CapSlotReference::new, CapSlotReference::slot);

        @Override
        public ItemStack get(LivingEntity player) {
            IItemHandler cap = (IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY);
            if (cap != null) {
                return cap.getStackInSlot(this.slot);
            }
            return null;
        }

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, ? extends SlotReference> getCodec() {
            return CODEC;
        }
    }

    private static abstract class CropAccessor
    extends CropBlock {
        public CropAccessor(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public static float callGetGrowthSpeed(BlockState state, ServerLevel level, BlockPos pos) {
            return CropBlock.getGrowthSpeed((BlockState)state, (BlockGetter)level, (BlockPos)pos);
        }
    }
}

