/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.entities.SkylineHookEntity;
import blusunrize.immersiveengineering.common.util.IELogger;
import javax.annotation.Nullable;

public class SkyhookUserData {
    private SkyhookStatus status = SkyhookStatus.NONE;
    @Nullable
    public SkylineHookEntity hook = null;

    public void release() {
        if (this.status.release != null) {
            this.status = this.status.release;
        }
    }

    public void dismount() {
        if (this.hook != null) {
            IELogger.logger.debug("Dismounting");
            this.hook.discard();
            this.hook = null;
        }
        if (this.status.dismount != null) {
            this.status = this.status.dismount;
        }
    }

    public SkyhookStatus getStatus() {
        return this.status;
    }

    public void startHolding() {
        this.status = SkyhookStatus.HOLDING_CONNECTING;
    }

    public void startRiding() {
        this.status = this.status.mount;
    }

    public static enum SkyhookStatus {
        NONE(null, null),
        RIDING(NONE, null),
        HOLDING_CONNECTING(null, NONE),
        HOLDING_FAILED(null, NONE),
        HOLDING_RIDING(HOLDING_FAILED, RIDING);

        @Nullable
        public final SkyhookStatus dismount;
        @Nullable
        public final SkyhookStatus release;
        @Nullable
        public SkyhookStatus mount;

        private SkyhookStatus(SkyhookStatus dismount, SkyhookStatus release) {
            this.dismount = dismount;
            this.release = release;
        }

        static {
            SkyhookStatus.NONE.mount = RIDING;
            SkyhookStatus.HOLDING_CONNECTING.mount = HOLDING_RIDING;
        }
    }
}

