/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.utils.codec.IEDualCodecs;
import blusunrize.immersiveengineering.client.utils.TimestampFormat;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.util.Utils;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class CoresampleItem
extends IEBaseItem {
    public CoresampleItem() {
        super(new Item.Properties().component(IEDataComponents.CORESAMPLE, (Object)ItemData.EMPTY));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        ItemData data = (ItemData)stack.getOrDefault(IEDataComponents.CORESAMPLE, (Object)ItemData.EMPTY);
        CoresampleItem.getCoresampleInfo(data, list, ChatFormatting.GRAY, ImmersiveEngineering.proxy.getClientWorld(), true, true);
    }

    public static void getCoresampleInfo(ItemData data, List<Component> list, ChatFormatting baseColor, @Nullable Level level, boolean showYield, boolean showTimestamp) {
        ColumnPos pos;
        if (level == null) {
            return;
        }
        if (!data.veins.isEmpty()) {
            data.veins.forEach(veinData -> {
                MutableComponent component = Component.literal((String)(Utils.formatDouble(veinData.percentageInTotalSample * 100.0, "0.00") + "% "));
                component.append((Component)Component.translatable((String)MineralMix.getTranslationKey(veinData.mineral)));
                list.add((Component)component.withStyle(baseColor));
                if (showYield) {
                    component = Component.literal((String)"  ");
                    component.append((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.saturation", (Object[])new Object[]{Utils.formatDouble(veinData.saturation * 100.0, "0.00")}));
                    list.add((Component)component.withStyle(ChatFormatting.DARK_GRAY));
                    component = Component.literal((String)"  ");
                    int yield_ = ExcavatorHandler.mineralVeinYield - veinData.depletion;
                    MineralMix mineral = MineralMix.RECIPES.getById(level, veinData.mineral);
                    yield_ = (int)((float)yield_ * (1.0f - mineral.failChance));
                    if (ExcavatorHandler.mineralVeinYield == 0) {
                        component.append((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.infinite"));
                    } else {
                        component.append((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.yield", (Object[])new Object[]{yield_}));
                    }
                    list.add((Component)component.withStyle(ChatFormatting.DARK_GRAY));
                }
            });
        } else {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.noMineral").withStyle(baseColor));
        }
        ResourceKey<Level> dimension = data.position.dimension;
        if (dimension != null) {
            String s2 = dimension.location().getPath();
            if (s2.toLowerCase(Locale.ENGLISH).startsWith("the_")) {
                s2 = s2.substring(4);
            }
            list.add((Component)Component.literal((String)Utils.toCamelCase(s2)).withStyle(baseColor));
        }
        if ((pos = data.position.position()) != null) {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.pos", (Object[])new Object[]{pos.x(), pos.z()}).withStyle(baseColor));
        }
        if (showTimestamp) {
            long dist = level.getGameTime() - data.timestamp;
            if (dist < 0L) {
                list.add((Component)Component.literal((String)"Somehow this sample is dated in the future...are you a time traveller?!").withStyle(ChatFormatting.RED));
            } else {
                list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.timestamp", (Object[])new Object[]{TimestampFormat.formatTimestamp(dist, TimestampFormat.DHM)}).withStyle(baseColor));
            }
        }
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        ItemStack stack = ctx.getItemInHand();
        if (player != null && player.isShiftKeyDown()) {
            BlockPlaceContext blockCtx;
            Level world = ctx.getLevel();
            BlockPos pos = ctx.getClickedPos();
            Direction side = ctx.getClickedFace();
            BlockState state = world.getBlockState(pos);
            if (!state.canBeReplaced(blockCtx = new BlockPlaceContext(ctx))) {
                pos = pos.relative(side);
            }
            if (!stack.isEmpty() && player.mayUseItemAt(pos, side, stack) && world.getBlockState(pos).canBeReplaced(blockCtx)) {
                BlockState coresample = IEBlocks.StoneDecoration.CORESAMPLE.defaultBlockState();
                if (world.setBlock(pos, coresample, 3)) {
                    IEBlocks.StoneDecoration.CORESAMPLE.get().onIEBlockPlacedBy(blockCtx, coresample);
                    SoundType soundtype = world.getBlockState(pos).getBlock().getSoundType(world.getBlockState(pos), (LevelReader)world, pos, (Entity)player);
                    world.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                    stack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.useOn(ctx);
    }

    public static List<RecipeHolder<MineralMix>> getMineralMixes(Level level, ItemStack coresample) {
        return ((ItemData)coresample.get(IEDataComponents.CORESAMPLE)).veins().stream().map(VeinSample::mineral).map(rl -> MineralMix.RECIPES.holderById(level, (ResourceLocation)rl)).toList();
    }

    public record ItemData(SamplePosition position, List<VeinSample> veins, long timestamp) {
        public static final DualCodec<ByteBuf, ItemData> CODECS = DualCompositeCodecs.composite((DualMapCodec)SamplePosition.CODECS.fieldOf("position"), ItemData::position, (DualMapCodec)VeinSample.CODECS.listOf().fieldOf("veins"), ItemData::veins, (DualMapCodec)DualCodecs.LONG.fieldOf("timestamp"), ItemData::timestamp, ItemData::new);
        public static final ItemData EMPTY = new ItemData(SamplePosition.NONE, List.of(), 0L);
    }

    public record SamplePosition(ResourceKey<Level> dimension, int x, int z) {
        public static final DualCodec<ByteBuf, SamplePosition> CODECS = DualCompositeCodecs.composite((DualMapCodec)DualCodecs.resourceKey((ResourceKey)Registries.DIMENSION).fieldOf("dimension"), SamplePosition::dimension, (DualMapCodec)DualCodecs.INT.fieldOf("x"), SamplePosition::x, (DualMapCodec)DualCodecs.INT.fieldOf("z"), SamplePosition::z, SamplePosition::new);
        public static final SamplePosition NONE = new SamplePosition((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"overworld")), 0, 0);

        public ColumnPos position() {
            return new ColumnPos(this.x, this.z);
        }
    }

    public record VeinSample(ResourceLocation mineral, int depletion, double saturation, double percentageInTotalSample) {
        public static final DualCodec<ByteBuf, VeinSample> CODECS = DualCompositeCodecs.composite((DualMapCodec)DualCodecs.RESOURCE_LOCATION.fieldOf("mineral"), VeinSample::mineral, (DualMapCodec)DualCodecs.INT.fieldOf("depletion"), VeinSample::depletion, (DualMapCodec)DualCodecs.DOUBLE.fieldOf("saturation"), VeinSample::saturation, (DualMapCodec)DualCodecs.DOUBLE.fieldOf("percentage"), VeinSample::percentageInTotalSample, VeinSample::new);
    }

    public record CoresampleMapData(Map<String, List<ResourceLocation>> mapDataToMinerals) {
        public static final DualCodec<ByteBuf, CoresampleMapData> CODECS = IEDualCodecs.forMap(DualCodecs.STRING, DualCodecs.RESOURCE_LOCATION.listOf()).fieldOf("mapDataToMinerals").codec().map(CoresampleMapData::new, CoresampleMapData::mapDataToMinerals);
        public static final CoresampleMapData EMPTY = new CoresampleMapData(Map.of());

        public CoresampleMapData {
            mapDataToMinerals = Map.copyOf(mapDataToMinerals);
        }

        public CoresampleMapData remove(String key) {
            HashMap<String, List<ResourceLocation>> newMap = new HashMap<String, List<ResourceLocation>>(this.mapDataToMinerals);
            newMap.remove(key);
            return new CoresampleMapData(newMap);
        }

        public CoresampleMapData with(String key, List<ResourceLocation> minerals) {
            HashMap<String, List<ResourceLocation>> newMap = new HashMap<String, List<ResourceLocation>>(this.mapDataToMinerals);
            newMap.put(key, minerals);
            return new CoresampleMapData(newMap);
        }
    }
}

