/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations;

import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.IParticleMotionType;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleDensityProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleTypeProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.PropMap;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.SpeedProperty;
import com.hollingsworth.arsnouveau.api.registry.ParticleMotionRegistry;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TrailMotion
extends ParticleMotion {
    public static MapCodec<TrailMotion> CODEC = TrailMotion.buildPropCodec(TrailMotion::new);
    public static StreamCodec<RegistryFriendlyByteBuf, TrailMotion> STREAM = TrailMotion.buildStreamCodec(TrailMotion::new);

    public TrailMotion(PropMap propMap) {
        super(propMap);
    }

    public TrailMotion() {
        super(new PropMap());
    }

    @Override
    public IParticleMotionType<?> getType() {
        return (IParticleMotionType)ParticleMotionRegistry.TRAIL_TYPE.get();
    }

    @Override
    public void tick(PropertyParticleOptions particleOptions, Level level, double x, double y, double z, double prevX, double prevY, double prevZ) {
        ParticleDensityProperty densityProp = this.getDensity(particleOptions, 100, 0.1f);
        SpeedProperty speedProperty = this.getSpeed(particleOptions);
        double minXSpeed = speedProperty.minXZ() * 0.25;
        double minYSpeed = speedProperty.minY() * 0.25;
        double maxXSpeed = speedProperty.maxXZ() * 0.25;
        double maxYSpeed = speedProperty.maxY() * 0.25;
        int density = densityProp.density();
        double radius = densityProp.radius();
        ParticleMotion.SpawnType spawnType = densityProp.spawnType().orElse(ParticleMotion.SpawnType.SPHERE);
        int totalParticles = this.getNumParticles(density);
        double deltaX = x - prevX;
        double deltaY = y - prevY;
        double deltaZ = z - prevZ;
        for (int i = 0; i < totalParticles; ++i) {
            double t = (double)i / (double)Math.max(1, totalParticles - 1);
            double px = prevX + deltaX * t;
            double py = prevY + deltaY * t;
            double pz = prevZ + deltaZ * t;
            Vec3 deltaVec = new Vec3(px, py, pz);
            Vec3 point = this.getMotionScaled(deltaVec, radius, spawnType);
            level.addAlwaysVisibleParticle((ParticleOptions)particleOptions, true, point.x, point.y, point.z, ParticleUtil.inRange(minXSpeed, maxXSpeed), ParticleUtil.inRange(minYSpeed, maxYSpeed), ParticleUtil.inRange(minXSpeed, maxXSpeed));
        }
    }

    @Override
    public List<BaseProperty<?>> getProperties(PropMap propMap) {
        return List.of(propMap.createIfMissing(new ParticleTypeProperty()), propMap.createIfMissing(new ParticleDensityProperty(100, (double)0.1f, ParticleMotion.SpawnType.SPHERE)));
    }
}

