/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mob_jar;

import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.common.block.MobJar;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.projectile.windcharge.BreezeWindCharge;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class BreezeBehavior
extends JarBehavior<Breeze> {
    @Override
    public void onRedstonePower(MobJarTile tile) {
        ServerLevel level;
        block3: {
            block2: {
                Level level2 = tile.getLevel();
                if (!(level2 instanceof ServerLevel)) break block2;
                level = (ServerLevel)level2;
                if (tile.getExtraDataTag().getLong("lastActive") != level.getGameTime()) break block3;
            }
            return;
        }
        Breeze breeze = (Breeze)this.entityFromJar(tile);
        BreezeWindCharge windCharge = new BreezeWindCharge(breeze, (Level)level);
        Vec3 pos = tile.getBlockPos().getCenter().add(new Vec3(((Direction)tile.getBlockState().getValue((Property)MobJar.FACING)).step()).scale(0.6));
        Vector3f dir = ((Direction)tile.getBlockState().getValue((Property)MobJar.FACING)).step();
        windCharge.setPos(pos);
        breeze.playSound(SoundEvents.BREEZE_SHOOT, 1.5f, 1.0f);
        windCharge.shoot((double)dir.x, (double)dir.y, (double)dir.z, 0.7f, (float)(5 - level.getDifficulty().getId() * 4));
        level.addFreshEntity((Entity)windCharge);
        CompoundTag tag = new CompoundTag();
        tag.putLong("lastActive", level.getGameTime());
        tile.setExtraDataTag(tag);
    }
}

