/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.search.BooleanClause;
import org.apache.lucene.ars_nouveau.search.BooleanQuery;
import org.apache.lucene.ars_nouveau.search.BooleanScorerSupplier;
import org.apache.lucene.ars_nouveau.search.Explanation;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.Matches;
import org.apache.lucene.ars_nouveau.search.MatchesUtils;
import org.apache.lucene.ars_nouveau.search.ScoreMode;
import org.apache.lucene.ars_nouveau.search.Scorer;
import org.apache.lucene.ars_nouveau.search.ScorerSupplier;
import org.apache.lucene.ars_nouveau.search.Weight;
import org.apache.lucene.ars_nouveau.search.similarities.Similarity;

final class BooleanWeight
extends Weight {
    final Similarity similarity;
    final BooleanQuery query;
    final ArrayList<WeightedBooleanClause> weightedClauses;
    final ScoreMode scoreMode;

    BooleanWeight(BooleanQuery query, IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        super(query);
        this.query = query;
        this.scoreMode = scoreMode;
        this.similarity = searcher.getSimilarity();
        this.weightedClauses = new ArrayList();
        for (BooleanClause c : query) {
            Weight w = searcher.createWeight(c.query(), c.isScoring() ? scoreMode : ScoreMode.COMPLETE_NO_SCORES, boost);
            this.weightedClauses.add(new WeightedBooleanClause(c, w));
        }
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        boolean fail = false;
        int matchCount = 0;
        int shouldMatchCount = 0;
        for (WeightedBooleanClause wc : this.weightedClauses) {
            Weight w = wc.weight;
            BooleanClause c = wc.clause;
            Explanation e = w.explain(context, doc);
            if (e.isMatch()) {
                if (c.isScoring()) {
                    subs.add(e);
                } else if (c.isRequired()) {
                    subs.add(Explanation.match((Number)Float.valueOf(0.0f), "match on required clause, product of:", Explanation.match((Number)Float.valueOf(0.0f), String.valueOf((Object)BooleanClause.Occur.FILTER) + " clause", new Explanation[0]), e));
                } else if (c.isProhibited()) {
                    subs.add(Explanation.noMatch("match on prohibited clause (" + c.query().toString() + ")", e));
                    fail = true;
                }
                if (!c.isProhibited()) {
                    ++matchCount;
                }
                if (c.occur() != BooleanClause.Occur.SHOULD) continue;
                ++shouldMatchCount;
                continue;
            }
            if (!c.isRequired()) continue;
            subs.add(Explanation.noMatch("no match on required clause (" + c.query().toString() + ")", e));
            fail = true;
        }
        if (fail) {
            return Explanation.noMatch("Failure to meet condition(s) of required/prohibited clause(s)", subs);
        }
        if (matchCount == 0) {
            return Explanation.noMatch("No matching clauses", subs);
        }
        if (shouldMatchCount < minShouldMatch) {
            return Explanation.noMatch("Failure to match minimum number of optional clauses: " + minShouldMatch, subs);
        }
        Scorer scorer = this.scorer(context);
        int advanced = scorer.iterator().advance(doc);
        assert (advanced == doc);
        return Explanation.match((Number)Float.valueOf(scorer.score()), "sum of:", subs);
    }

    @Override
    public Matches matches(LeafReaderContext context, int doc) throws IOException {
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        ArrayList<Matches> matches = new ArrayList<Matches>();
        int shouldMatchCount = 0;
        for (WeightedBooleanClause wc : this.weightedClauses) {
            Weight w = wc.weight;
            BooleanClause bc = wc.clause;
            Matches m = w.matches(context, doc);
            if (bc.isProhibited() && m != null) {
                return null;
            }
            if (bc.isRequired()) {
                if (m == null) {
                    return null;
                }
                matches.add(m);
            }
            if (bc.occur() != BooleanClause.Occur.SHOULD || m == null) continue;
            matches.add(m);
            ++shouldMatchCount;
        }
        if (shouldMatchCount < minShouldMatch) {
            return null;
        }
        return MatchesUtils.fromSubMatches(matches);
    }

    @Override
    public int count(LeafReaderContext context) throws IOException {
        int numDocs = context.reader().numDocs();
        if (this.query.isPureDisjunction()) {
            return this.optCount(context, BooleanClause.Occur.SHOULD);
        }
        int positiveCount = (!this.query.getClauses(BooleanClause.Occur.FILTER).isEmpty() || !this.query.getClauses(BooleanClause.Occur.MUST).isEmpty()) && this.query.getMinimumNumberShouldMatch() == 0 ? this.reqCount(context) : -1;
        if (positiveCount == 0) {
            return 0;
        }
        int prohibitedCount = this.optCount(context, BooleanClause.Occur.MUST_NOT);
        if (prohibitedCount == -1) {
            return -1;
        }
        if (prohibitedCount == 0) {
            return positiveCount;
        }
        if (prohibitedCount == numDocs) {
            return 0;
        }
        if (positiveCount == numDocs) {
            return numDocs - prohibitedCount;
        }
        return -1;
    }

    private int reqCount(LeafReaderContext context) throws IOException {
        int numDocs;
        int reqCount = numDocs = context.reader().numDocs();
        for (WeightedBooleanClause weightedClause : this.weightedClauses) {
            if (!weightedClause.clause.isRequired()) continue;
            int count = weightedClause.weight.count(context);
            if (count == -1 || count == 0) {
                return count;
            }
            if (count == numDocs) continue;
            if (reqCount == numDocs) {
                reqCount = count;
                continue;
            }
            return -1;
        }
        return reqCount;
    }

    private int optCount(LeafReaderContext context, BooleanClause.Occur occur) throws IOException {
        int numDocs = context.reader().numDocs();
        int optCount = 0;
        boolean unknownCount = false;
        for (WeightedBooleanClause weightedClause : this.weightedClauses) {
            if (weightedClause.clause.occur() != occur) continue;
            int count = weightedClause.weight.count(context);
            if (count == -1) {
                unknownCount = true;
                continue;
            }
            if (count == numDocs) {
                return count;
            }
            if (count == 0) continue;
            if (optCount == 0) {
                optCount = count;
                continue;
            }
            unknownCount = true;
        }
        return unknownCount ? -1 : optCount;
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        if (this.query.clauses().size() > 16) {
            return false;
        }
        for (WeightedBooleanClause wc : this.weightedClauses) {
            Weight w = wc.weight;
            if (w.isCacheable(ctx)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        EnumMap<BooleanClause.Occur, Collection<ScorerSupplier>> scorers = new EnumMap<BooleanClause.Occur, Collection<ScorerSupplier>>(BooleanClause.Occur.class);
        for (BooleanClause.Occur occur : BooleanClause.Occur.values()) {
            scorers.put(occur, new ArrayList());
        }
        for (WeightedBooleanClause wc : this.weightedClauses) {
            Weight w = wc.weight;
            BooleanClause c = wc.clause;
            ScorerSupplier subScorer = w.scorerSupplier(context);
            if (subScorer == null) {
                if (!c.isRequired()) continue;
                return null;
            }
            ((Collection)scorers.get((Object)c.occur())).add(subScorer);
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).size() == minShouldMatch) {
            ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).addAll((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD));
            ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).clear();
            minShouldMatch = 0;
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.FILTER)).isEmpty() && ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).isEmpty() && ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).isEmpty()) {
            return null;
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).size() < minShouldMatch) {
            return null;
        }
        if (!this.scoreMode.needsScores() && minShouldMatch == 0 && ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).size() + ((Collection)scorers.get((Object)BooleanClause.Occur.FILTER)).size() > 0) {
            ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).clear();
        }
        return new BooleanScorerSupplier(this, scorers, this.scoreMode, minShouldMatch, context.reader().maxDoc());
    }

    protected static class WeightedBooleanClause {
        final BooleanClause clause;
        final Weight weight;

        WeightedBooleanClause(BooleanClause clause, Weight weight) {
            this.clause = clause;
            this.weight = weight;
        }
    }
}

