/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.util;

import java.util.Arrays;
import org.apache.lucene.ars_nouveau.util.Accountable;
import org.apache.lucene.ars_nouveau.util.ArrayUtil;
import org.apache.lucene.ars_nouveau.util.ByteBlockPool;
import org.apache.lucene.ars_nouveau.util.BytesRef;
import org.apache.lucene.ars_nouveau.util.BytesRefBlockPool;
import org.apache.lucene.ars_nouveau.util.BytesRefBuilder;
import org.apache.lucene.ars_nouveau.util.BytesRefComparator;
import org.apache.lucene.ars_nouveau.util.Counter;
import org.apache.lucene.ars_nouveau.util.RamUsageEstimator;
import org.apache.lucene.ars_nouveau.util.Sorter;
import org.apache.lucene.ars_nouveau.util.StringHelper;
import org.apache.lucene.ars_nouveau.util.StringSorter;

public final class BytesRefHash
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(BytesRefHash.class) + (long)RamUsageEstimator.primitiveSizes.get(Long.TYPE).intValue();
    public static final int DEFAULT_CAPACITY = 16;
    final BytesRefBlockPool pool;
    int[] bytesStart;
    private int hashSize;
    private int hashHalfSize;
    private int hashMask;
    private int count;
    private int lastCount = -1;
    private int[] ids;
    private final BytesStartArray bytesStartArray;
    private final Counter bytesUsed;

    public BytesRefHash() {
        this(new ByteBlockPool(new ByteBlockPool.DirectAllocator()));
    }

    public BytesRefHash(ByteBlockPool pool) {
        this(pool, 16, new DirectBytesStartArray(16));
    }

    public BytesRefHash(ByteBlockPool pool, int capacity, BytesStartArray bytesStartArray) {
        this.hashSize = capacity;
        this.hashHalfSize = this.hashSize >> 1;
        this.hashMask = this.hashSize - 1;
        this.pool = new BytesRefBlockPool(pool);
        this.ids = new int[this.hashSize];
        Arrays.fill(this.ids, -1);
        this.bytesStartArray = bytesStartArray;
        this.bytesStart = bytesStartArray.init();
        Counter bytesUsed = bytesStartArray.bytesUsed();
        this.bytesUsed = bytesUsed == null ? Counter.newCounter() : bytesUsed;
        bytesUsed.addAndGet((long)this.hashSize * 4L);
    }

    public int size() {
        return this.count;
    }

    public BytesRef get(int bytesID, BytesRef ref) {
        assert (this.bytesStart != null) : "bytesStart is null - not initialized";
        assert (bytesID < this.bytesStart.length) : "bytesID exceeds byteStart len: " + this.bytesStart.length;
        this.pool.fillBytesRef(ref, this.bytesStart[bytesID]);
        return ref;
    }

    public int[] compact() {
        assert (this.bytesStart != null) : "bytesStart is null - not initialized";
        int upto = 0;
        for (int i = 0; i < this.hashSize; ++i) {
            if (this.ids[i] == -1) continue;
            if (upto < i) {
                this.ids[upto] = this.ids[i];
                this.ids[i] = -1;
            }
            ++upto;
        }
        assert (upto == this.count);
        this.lastCount = this.count;
        return this.ids;
    }

    public int[] sort() {
        final int[] compact = this.compact();
        assert (this.count * 2 <= compact.length) : "We need load factor <= 0.5f to speed up this sort";
        final int tmpOffset = this.count;
        new StringSorter(BytesRefComparator.NATURAL){

            @Override
            protected Sorter radixSorter(BytesRefComparator cmp) {
                return new StringSorter.MSBStringRadixSorter(cmp){
                    private int k;

                    @Override
                    protected void buildHistogram(int prefixCommonBucket, int prefixCommonLen, int from, int to, int k, int[] histogram) {
                        this.k = k;
                        histogram[prefixCommonBucket] = prefixCommonLen;
                        Arrays.fill(compact, tmpOffset + from - prefixCommonLen, tmpOffset + from, prefixCommonBucket);
                        for (int i = from; i < to; ++i) {
                            int b;
                            compact[tmpOffset + i] = b = this.getBucket(i, k);
                            int n = b;
                            histogram[n] = histogram[n] + 1;
                        }
                    }

                    @Override
                    protected boolean shouldFallback(int from, int to, int l) {
                        return to - from <= 50 || l >= 8;
                    }

                    private void swapBucketCache(int i, int j) {
                        this.swap(i, j);
                        int tmp = compact[tmpOffset + i];
                        compact[tmpOffset + i] = compact[tmpOffset + j];
                        compact[tmpOffset + j] = tmp;
                    }

                    @Override
                    protected void reorder(int from, int to, int[] startOffsets, int[] endOffsets, int k) {
                        assert (this.k == k);
                        for (int i = 0; i < 257; ++i) {
                            int limit = endOffsets[i];
                            int h1 = startOffsets[i];
                            while (h1 < limit) {
                                int h2;
                                int b;
                                int n = b = compact[tmpOffset + from + h1];
                                startOffsets[n] = startOffsets[n] + 1;
                                this.swapBucketCache(from + h1, from + h2);
                                h1 = startOffsets[i];
                            }
                        }
                    }
                };
            }

            @Override
            protected void swap(int i, int j) {
                int tmp = compact[i];
                compact[i] = compact[j];
                compact[j] = tmp;
            }

            @Override
            protected void get(BytesRefBuilder builder, BytesRef result, int i) {
                BytesRefHash.this.pool.fillBytesRef(result, BytesRefHash.this.bytesStart[compact[i]]);
            }
        }.sort(0, this.count);
        Arrays.fill(compact, tmpOffset, compact.length, -1);
        return compact;
    }

    private boolean shrink(int targetSize) {
        int newSize;
        for (newSize = this.hashSize; newSize >= 8 && newSize / 4 > targetSize; newSize /= 2) {
        }
        if (newSize != this.hashSize) {
            this.bytesUsed.addAndGet(4L * (long)(-(this.hashSize - newSize)));
            this.hashSize = newSize;
            this.ids = new int[this.hashSize];
            Arrays.fill(this.ids, -1);
            this.hashHalfSize = newSize / 2;
            this.hashMask = newSize - 1;
            return true;
        }
        return false;
    }

    public void clear(boolean resetPool) {
        this.lastCount = this.count;
        this.count = 0;
        if (resetPool) {
            this.pool.reset();
        }
        this.bytesStart = this.bytesStartArray.clear();
        if (this.lastCount != -1 && this.shrink(this.lastCount)) {
            return;
        }
        Arrays.fill(this.ids, -1);
    }

    public void clear() {
        this.clear(true);
    }

    public void close() {
        this.clear(true);
        this.ids = null;
        this.bytesUsed.addAndGet(4L * (long)(-this.hashSize));
    }

    public int add(BytesRef bytes) {
        assert (this.bytesStart != null) : "Bytesstart is null - not initialized";
        int hashPos = this.findHash(bytes);
        int e = this.ids[hashPos];
        if (e == -1) {
            if (this.count >= this.bytesStart.length) {
                this.bytesStart = this.bytesStartArray.grow();
                assert (this.count < this.bytesStart.length + 1) : "count: " + this.count + " len: " + this.bytesStart.length;
            }
            this.bytesStart[this.count] = this.pool.addBytesRef(bytes);
            e = this.count++;
            assert (this.ids[hashPos] == -1);
            this.ids[hashPos] = e;
            if (this.count == this.hashHalfSize) {
                this.rehash(2 * this.hashSize, true);
            }
            return e;
        }
        return -(e + 1);
    }

    public int find(BytesRef bytes) {
        return this.ids[this.findHash(bytes)];
    }

    private int findHash(BytesRef bytes) {
        assert (this.bytesStart != null) : "bytesStart is null - not initialized";
        int code = BytesRefHash.doHash(bytes.bytes, bytes.offset, bytes.length);
        int hashPos = code & this.hashMask;
        int e = this.ids[hashPos];
        if (e != -1 && !this.pool.equals(this.bytesStart[e], bytes)) {
            while ((e = this.ids[hashPos = ++code & this.hashMask]) != -1 && !this.pool.equals(this.bytesStart[e], bytes)) {
            }
        }
        return hashPos;
    }

    public int addByPoolOffset(int offset) {
        assert (this.bytesStart != null) : "Bytesstart is null - not initialized";
        int code = offset;
        int hashPos = offset & this.hashMask;
        int e = this.ids[hashPos];
        if (e != -1 && this.bytesStart[e] != offset) {
            while ((e = this.ids[hashPos = ++code & this.hashMask]) != -1 && this.bytesStart[e] != offset) {
            }
        }
        if (e == -1) {
            if (this.count >= this.bytesStart.length) {
                this.bytesStart = this.bytesStartArray.grow();
                assert (this.count < this.bytesStart.length + 1) : "count: " + this.count + " len: " + this.bytesStart.length;
            }
            e = this.count++;
            this.bytesStart[e] = offset;
            assert (this.ids[hashPos] == -1);
            this.ids[hashPos] = e;
            if (this.count == this.hashHalfSize) {
                this.rehash(2 * this.hashSize, false);
            }
            return e;
        }
        return -(e + 1);
    }

    private void rehash(int newSize, boolean hashOnData) {
        int newMask = newSize - 1;
        this.bytesUsed.addAndGet(4L * (long)newSize);
        int[] newHash = new int[newSize];
        Arrays.fill(newHash, -1);
        for (int i = 0; i < this.hashSize; ++i) {
            int e0 = this.ids[i];
            if (e0 == -1) continue;
            int code = hashOnData ? this.pool.hash(this.bytesStart[e0]) : this.bytesStart[e0];
            int hashPos = code & newMask;
            assert (hashPos >= 0);
            if (newHash[hashPos] != -1) {
                while (newHash[hashPos = ++code & newMask] != -1) {
                }
            }
            newHash[hashPos] = e0;
        }
        this.hashMask = newMask;
        this.bytesUsed.addAndGet(4L * (long)(-this.ids.length));
        this.ids = newHash;
        this.hashSize = newSize;
        this.hashHalfSize = newSize / 2;
    }

    static int doHash(byte[] bytes, int offset, int length) {
        return StringHelper.murmurhash3_x86_32(bytes, offset, length, StringHelper.GOOD_FAST_HASH_SEED);
    }

    public void reinit() {
        if (this.bytesStart == null) {
            this.bytesStart = this.bytesStartArray.init();
        }
        if (this.ids == null) {
            this.ids = new int[this.hashSize];
            this.bytesUsed.addAndGet(4L * (long)this.hashSize);
        }
    }

    public int byteStart(int bytesID) {
        assert (this.bytesStart != null) : "bytesStart is null - not initialized";
        assert (bytesID >= 0 && bytesID < this.count) : bytesID;
        return this.bytesStart[bytesID];
    }

    @Override
    public long ramBytesUsed() {
        long size = BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.bytesStart) + RamUsageEstimator.sizeOfObject(this.ids) + RamUsageEstimator.sizeOfObject(this.pool);
        return size;
    }

    public static class DirectBytesStartArray
    extends BytesStartArray {
        protected final int initSize;
        private int[] bytesStart;
        private final Counter bytesUsed;

        public DirectBytesStartArray(int initSize, Counter counter) {
            this.bytesUsed = counter;
            this.initSize = initSize;
        }

        public DirectBytesStartArray(int initSize) {
            this(initSize, Counter.newCounter());
        }

        @Override
        public int[] clear() {
            this.bytesStart = null;
            return null;
        }

        @Override
        public int[] grow() {
            assert (this.bytesStart != null);
            this.bytesStart = ArrayUtil.grow(this.bytesStart, this.bytesStart.length + 1);
            return this.bytesStart;
        }

        @Override
        public int[] init() {
            this.bytesStart = new int[ArrayUtil.oversize(this.initSize, 4)];
            return this.bytesStart;
        }

        @Override
        public Counter bytesUsed() {
            return this.bytesUsed;
        }
    }

    public static abstract class BytesStartArray {
        public abstract int[] init();

        public abstract int[] grow();

        public abstract int[] clear();

        public abstract Counter bytesUsed();
    }

    public static class MaxBytesLengthExceededException
    extends RuntimeException {
        MaxBytesLengthExceededException(String message) {
            super(message);
        }
    }
}

