/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen;

import com.google.common.collect.ImmutableList;
import it.zerono.mods.extremereactors.CommonLocations;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.GuiTheme;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.AbstractReprocessorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.AbstractTurbineEntity;
import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.lib.IActivableMachine;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.ModTileContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Label;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.Picture;
import it.zerono.mods.zerocore.lib.client.gui.control.SlotsGroup;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISpriteTextureMap;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.SpriteTextureMap;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMultiblockScreen<Controller extends AbstractCuboidMultiblockController<Controller>, T extends AbstractMultiblockEntity<Controller>, C extends ModTileContainer<T>>
extends ModTileContainerScreen<T, C> {
    protected static final Component INDICATOR_ACTIVE_REACTOR = Component.translatable((String)"gui.bigreactors.reactor.active");
    protected static final Component INDICATOR_INACTIVE_REACTOR = Component.translatable((String)"gui.bigreactors.reactor.inactive");
    protected static final Component INDICATOR_ACTIVE_TURBINE = Component.translatable((String)"gui.bigreactors.turbine.active");
    protected static final Component INDICATOR_INACTIVE_TURBINE = Component.translatable((String)"gui.bigreactors.turbine.inactive");
    protected static final Component INDICATOR_ACTIVE_REPROCESSOR = Component.translatable((String)"gui.bigreactors.reprocessor.active");
    protected static final Component INDICATOR_INACTIVE_REPROCESSOR = Component.translatable((String)"gui.bigreactors.reprocessor.inactive");
    private static final int DEFAULT_GUI_WIDTH = 224;
    private static final int DEFAULT_GUI_HEIGHT = 166;
    private static final int TITLE_PANEL_HEIGHT = 21;
    private final ISpriteTextureMap _mainTextMap;
    private final ISprite _invMainSprite;
    private final ISprite _invHotBarSprite;
    private final ISprite _invSingleSprite;
    private final IControlContainer _contentPanel;
    private final Picture _indicatorOn;
    private final Picture _indicatorOff;
    private IControl _helpButton;

    protected AbstractMultiblockScreen(C container, Inventory inventory, PlayerInventoryUsage inventoryUsage, Component title) {
        this(container, inventory, inventoryUsage, title, 224, 166);
    }

    protected AbstractMultiblockScreen(C container, Inventory inventory, PlayerInventoryUsage inventoryUsage, Component title, Supplier<@NotNull SpriteTextureMap> mainTextureSupplier) {
        this(container, inventory, inventoryUsage, title, 224, 166, mainTextureSupplier.get());
    }

    protected AbstractMultiblockScreen(C container, Inventory inventory, PlayerInventoryUsage inventoryUsage, Component title, int guiWidth, int guiHeight, Supplier<@NotNull SpriteTextureMap> mainTextureSupplier) {
        this(container, inventory, inventoryUsage, title, guiWidth, guiHeight, mainTextureSupplier.get());
    }

    protected static Supplier<@NotNull SpriteTextureMap> mainTextureFromVariant(IMultiblockVariant variant) {
        return () -> new SpriteTextureMap(CommonLocations.TEXTURES_GUI_MULTIBLOCK.buildWithSuffix(variant.getName() + "_background.png"), 256, 256);
    }

    protected static Supplier<@NotNull SpriteTextureMap> halfTextureFromVariant(IMultiblockVariant variant) {
        return () -> new SpriteTextureMap(CommonLocations.TEXTURES_GUI_MULTIBLOCK.buildWithPrefix(variant.getName() + "_background_half.png"), 256, 98);
    }

    protected AbstractMultiblockScreen(C container, Inventory inventory, PlayerInventoryUsage inventoryUsage, Component title, int guiWidth, int guiHeight) {
        this(container, inventory, inventoryUsage, title, guiWidth, guiHeight, new SpriteTextureMap(CommonLocations.TEXTURES_GUI_MULTIBLOCK.buildWithSuffix("generic_background.png"), 256, 256));
    }

    protected AbstractMultiblockScreen(C container, Inventory inventory, PlayerInventoryUsage inventoryUsage, Component title, int guiWidth, int guiHeight, SpriteTextureMap mainTexture) {
        super(container, inventory, title, guiWidth, guiHeight);
        this._mainTextMap = mainTexture;
        this.setTheme(GuiTheme.ER.get());
        switch (inventoryUsage) {
            default: {
                this._invHotBarSprite = this._invSingleSprite = Sprite.EMPTY;
                this._invMainSprite = this._invSingleSprite;
                break;
            }
            case HotBar: {
                this._invHotBarSprite = this.createInventoryHotBarSprite();
                this._invMainSprite = Sprite.EMPTY;
                this._invSingleSprite = this.createInventorySingleSprite();
                break;
            }
            case MainInventory: {
                this._invHotBarSprite = Sprite.EMPTY;
                this._invMainSprite = this.createInventoryMainSprite();
                this._invSingleSprite = this.createInventorySingleSprite();
                break;
            }
            case Both: {
                this._invHotBarSprite = this.createInventoryHotBarSprite();
                this._invMainSprite = this.createInventoryMainSprite();
                this._invSingleSprite = this.createInventorySingleSprite();
            }
        }
        this._contentPanel = new Panel((ModContainerScreen)this, "content");
        this._helpButton = null;
        this._indicatorOn = new Picture((ModContainerScreen)this, "on", (Supplier)CommonIcons.MachineStatusOn);
        this._indicatorOff = new Picture((ModContainerScreen)this, "off", (Supplier)CommonIcons.MachineStatusOff);
        AbstractMultiblockEntity tile = (AbstractMultiblockEntity)container.getTileEntity();
        if (tile instanceof AbstractReactorEntity) {
            this.setIndicatorToolTip(true, INDICATOR_ACTIVE_REACTOR);
            this.setIndicatorToolTip(false, INDICATOR_INACTIVE_REACTOR);
        } else if (tile instanceof AbstractTurbineEntity) {
            this.setIndicatorToolTip(true, INDICATOR_ACTIVE_TURBINE);
            this.setIndicatorToolTip(false, INDICATOR_INACTIVE_TURBINE);
        } else if (tile instanceof AbstractReprocessorEntity) {
            this.setIndicatorToolTip(true, INDICATOR_ACTIVE_REPROCESSOR);
            this.setIndicatorToolTip(false, INDICATOR_INACTIVE_REPROCESSOR);
        }
    }

    protected void addControl(IControl control) {
        this._contentPanel.addControl(control);
    }

    protected void setContentPanelBackground(ISprite sprite) {
        this._contentPanel.setBackground(sprite);
    }

    protected void setContentPanelBackground(Colour colour) {
        this._contentPanel.setBackground(colour);
    }

    protected void setContentLayoutEngine(ILayoutEngine engine) {
        this._contentPanel.setLayoutEngine(engine);
    }

    protected void setIndicatorToolTip(boolean active, Component ... lines) {
        this.setIndicatorToolTip(active, (List<Component>)ImmutableList.copyOf((Object[])lines), Collections.emptyList());
    }

    protected void setIndicatorToolTip(boolean active, List<Component> lines, List<Object> objects) {
        if (active) {
            this._indicatorOn.setTooltips(lines, objects);
        } else {
            this._indicatorOff.setTooltips(lines, objects);
        }
    }

    protected void addPatchouliHelpButton(ResourceLocation bookId, ResourceLocation entryId, int pageNum) {
        this._helpButton = this.createPatchouliHelpButton(bookId, entryId, pageNum);
    }

    protected void setButtonSpritesAndOverlayForState(AbstractButtonControl button, ButtonState standardState, Supplier<@NotNull ISprite> standardSprite) {
        this.setButtonSpritesAndOverlayForState(button, standardState, standardSprite.get());
    }

    protected void setButtonSpritesAndOverlayForState(AbstractButtonControl button, ButtonState standardState, ISprite standardSprite) {
        button.setIconForState(standardSprite, standardState);
        ISprite withOverlay = standardSprite.copyWith(CommonIcons.Button16x16HightlightOverlay.get());
        button.setIconForState(withOverlay, standardState.getHighlighted());
        withOverlay = standardSprite.copyWith(CommonIcons.Button16x16DisabledOverlay.get());
        button.setIconForState(withOverlay, standardState.getDisabled());
    }

    protected Optional<Controller> getMultiblockController() {
        return ((AbstractMultiblockEntity)((ModTileContainer)this.getMenu()).getTileEntity()).getMultiblockController();
    }

    protected boolean isMultiblockActive() {
        return this.getMultiblockController().filter(controller -> controller instanceof IActivableMachine).map(controller -> ((IActivableMachine)controller).isMachineActive()).orElse(false);
    }

    protected boolean isMultiblockAssembled() {
        return this.getMultiblockController().map(rec$ -> ((IMultiblockController)rec$).isAssembled()).orElse(false);
    }

    protected SlotsGroup createSingleSlotGroupControl(String controlName, String inventorySlotsGroupName) {
        return this.createMonoSlotGroupControl(controlName, inventorySlotsGroupName, this._invSingleSprite, 1);
    }

    protected SlotsGroup createPlayerHotBarSlotsGroupControl() {
        return this.createPlayerHotBarSlotsGroupControl(this._invHotBarSprite, 1);
    }

    protected SlotsGroup createPlayerInventorySlotsGroupControl() {
        return this.createPlayerInventorySlotsGroupControl(this._invMainSprite, 1);
    }

    protected void onDataUpdated() {
        super.onDataUpdated();
        if (!this.isMultiblockAssembled()) {
            this.close();
        }
        boolean active = this.isMultiblockActive();
        this._indicatorOn.setVisible(active);
        this._indicatorOff.setVisible(!active);
    }

    protected void onScreenCreate() {
        super.onScreenCreate();
        int guiWidth = this.getGuiWidth();
        int guiHeight = this.getGuiHeight();
        Panel mainPanel = new Panel((ModContainerScreen)this, "mainPanel");
        Panel titlePanel = new Panel((ModContainerScreen)this, "titlePanel");
        int contentHeight = guiHeight - 21;
        mainPanel.setDesiredDimension(DesiredDimension.Height, guiHeight);
        mainPanel.setDesiredDimension(DesiredDimension.Width, guiWidth);
        mainPanel.setLayoutEngineHint(FixedLayoutEngine.hint((int)0, (int)0, (int)guiWidth, (int)guiHeight));
        mainPanel.setBackground(this._mainTextMap.sprite().ofSize(guiWidth, guiHeight).build());
        mainPanel.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine().setZeroMargins());
        titlePanel.setDesiredDimension(DesiredDimension.Height, 21);
        titlePanel.setDesiredDimension(DesiredDimension.Width, guiWidth);
        titlePanel.setLayoutEngineHint(FixedLayoutEngine.hint((int)0, (int)0, (int)guiWidth, (int)21));
        titlePanel.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine().setZeroMargins());
        Label title = new Label((ModContainerScreen)this, "title", this.getTitle().getString());
        title.setPadding(2);
        title.setColor(this.getTheme().GUI_TITLE);
        title.setAutoSize(false);
        title.setLayoutEngineHint(FixedLayoutEngine.hint((int)17, (int)7, (int)(guiWidth - 47), (int)12));
        this._indicatorOn.setVisible(false);
        this._indicatorOn.setLayoutEngineHint(FixedLayoutEngine.hint((int)7, (int)7, (int)10, (int)10));
        this._indicatorOff.setVisible(false);
        this._indicatorOff.setLayoutEngineHint(FixedLayoutEngine.hint((int)7, (int)7, (int)10, (int)10));
        titlePanel.addControl(new IControl[]{title, this._indicatorOn, this._indicatorOff});
        if (null != this._helpButton) {
            this._helpButton.setLayoutEngineHint(FixedLayoutEngine.hint((int)(guiWidth - 18), (int)6, (int)12, (int)12));
            titlePanel.addControl(this._helpButton);
        }
        this._contentPanel.removeControls();
        this._contentPanel.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine());
        this._contentPanel.setDesiredDimension(DesiredDimension.Height, contentHeight);
        this._contentPanel.setDesiredDimension(DesiredDimension.Width, guiWidth);
        this._contentPanel.setLayoutEngineHint(FixedLayoutEngine.hint((int)0, (int)21, (int)guiWidth, (int)contentHeight));
        mainPanel.addControl(new IControl[]{titlePanel, this._contentPanel});
        this.createWindow((IControlContainer)mainPanel, true);
    }

    private ISprite createInventoryHotBarSprite() {
        return this._mainTextMap.sprite().from(0, 202).ofSize(162, 18).build();
    }

    private ISprite createInventoryMainSprite() {
        return this._mainTextMap.sprite().from(0, 202).ofSize(162, 54).build();
    }

    private ISprite createInventorySingleSprite() {
        return this._mainTextMap.sprite().from(0, 202).ofSize(18, 18).build();
    }
}

