/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.models.bbmodel;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.razznature.decocraft.models.bbmodel.BBModel;
import com.razznature.decocraft.models.bbmodel.BBModelLoader;
import com.razznature.decocraft.models.bbmodel.BlockbenchModel;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.InventoryMenu;

public class BlockbenchLoader {
    public static BlockbenchLoader INSTANCE = new BlockbenchLoader();
    private final Map<BlockbenchSetting, BlockbenchModel> modelCache = Collections.synchronizedMap(new HashMap());
    private ResourceManager manager = Minecraft.getInstance().getResourceManager();

    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.modelCache.clear();
        this.manager = resourceManager;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public BlockbenchModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        if (!modelContents.has("model")) {
            throw new RuntimeException("Blockbench Loader requires a 'model' key that points to a valid .BBModel.");
        }
        String modelLocation = modelContents.get("model").getAsString();
        float scale = modelContents.has("scale") ? GsonHelper.getAsFloat((JsonObject)modelContents, (String)"scale") : 1.0f;
        boolean flipV = GsonHelper.getAsBoolean((JsonObject)modelContents, (String)"flip-v", (boolean)false);
        String material = GsonHelper.getAsString((JsonObject)modelContents, (String)"material", (String)"UNKNOWN");
        BlockbenchSetting settings = new BlockbenchSetting(ResourceLocation.parse((String)modelLocation), scale, flipV, material);
        BlockbenchModel cachedModel = this.modelCache.get(settings);
        if (cachedModel != null) {
            return cachedModel;
        }
        try {
            Resource resource = (Resource)this.manager.getResource(settings.modelLocation).orElseThrow(() -> new FileNotFoundException("Could not find BBModel: " + String.valueOf(settings.modelLocation)));
            try (InputStreamReader lineStream = new InputStreamReader(resource.open(), StandardCharsets.UTF_8);){
                BlockbenchModel blockbenchModel;
                try (BufferedReader lineReader = new BufferedReader(lineStream);){
                    BBModel model = new BBModelLoader().loadModel(lineReader);
                    Function<ResourceLocation, TextureAtlasSprite> spriteGetter = id -> {
                        try {
                            TextureAtlasSprite missingSprite;
                            Minecraft client = Minecraft.getInstance();
                            if (client == null) {
                                return null;
                            }
                            ModelManager modelManager = client.getModelManager();
                            if (modelManager == null) {
                                return null;
                            }
                            TextureAtlas atlas = modelManager.getAtlas(InventoryMenu.BLOCK_ATLAS);
                            if (atlas == null) {
                                return null;
                            }
                            ResourceLocation missingTexture = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"missingno");
                            TextureAtlasSprite sprite = atlas.getSprite(id);
                            if (sprite != (missingSprite = atlas.getSprite(missingTexture))) {
                                return sprite;
                            }
                            if (!id.getNamespace().equals("decocraft_nature") && (sprite = atlas.getSprite(ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)id.getPath()))) != missingSprite) {
                                return sprite;
                            }
                            sprite = atlas.getSprite(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("blocks/" + id.getPath())));
                            if (sprite != missingSprite) {
                                return sprite;
                            }
                            return missingSprite;
                        }
                        catch (Exception e) {
                            return null;
                        }
                    };
                    BlockbenchModel blockbenchModel2 = new BlockbenchModel(settings, model, spriteGetter);
                    this.modelCache.put(settings, blockbenchModel2);
                    blockbenchModel = blockbenchModel2;
                }
                return blockbenchModel;
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not find BBModel", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read BBModel", e);
        }
    }

    public static class BlockbenchSetting {
        public final ResourceLocation modelLocation;
        public final float scale;
        public final boolean flipV;
        public final boolean flipU;
        public final String material;

        public BlockbenchSetting(ResourceLocation modelLocation, float scale, boolean flipV, String material) {
            this.modelLocation = modelLocation;
            this.scale = scale;
            this.flipV = flipV;
            this.flipU = false;
            this.material = material;
        }

        public BlockbenchSetting(ResourceLocation modelLocation, float scale, boolean flipV, boolean flipU, String material) {
            this.modelLocation = modelLocation;
            this.scale = scale;
            this.flipV = flipV;
            this.flipU = flipU;
            this.material = material;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockbenchSetting that = (BlockbenchSetting)o;
            return Float.compare(that.scale, this.scale) == 0 && this.flipV == that.flipV && this.flipU == that.flipU && this.modelLocation.equals((Object)that.modelLocation) && this.material.equals(that.material);
        }

        public int hashCode() {
            int result = this.modelLocation.hashCode();
            result = 31 * result + Float.hashCode(this.scale);
            result = 31 * result + Boolean.hashCode(this.flipV);
            result = 31 * result + Boolean.hashCode(this.flipU);
            result = 31 * result + this.material.hashCode();
            return result;
        }
    }
}

