/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.platform;

import java.util.function.BiConsumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import tschipp.carryon.CarryOnCommonClient;
import tschipp.carryon.config.BuiltConfig;
import tschipp.carryon.config.neoforge.ConfigLoaderImpl;
import tschipp.carryon.networking.PacketBase;
import tschipp.carryon.platform.services.IPlatformHelper;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public void registerConfig(BuiltConfig cfg) {
        ConfigLoaderImpl.registerConfig(cfg);
    }

    @Override
    public <T extends PacketBase, B extends FriendlyByteBuf> void registerServerboundPacket(CustomPacketPayload.Type<T> type, Class<T> clazz, StreamCodec<B, T> codec, BiConsumer<T, Player> handler, Object ... args) {
        PayloadRegistrar registrar = (PayloadRegistrar)args[0];
        IPayloadHandler serverHandler = (packet, ctx) -> ctx.enqueueWork(() -> handler.accept(packet, ctx.player()));
        registrar.playToServer(type, codec, serverHandler);
    }

    @Override
    public <T extends PacketBase, B extends FriendlyByteBuf> void registerClientboundPacket(CustomPacketPayload.Type<T> type, Class<T> clazz, StreamCodec<B, T> codec, BiConsumer<T, Player> handler, Object ... args) {
        PayloadRegistrar registrar = (PayloadRegistrar)args[0];
        IPayloadHandler clientHandler = (packet, ctx) -> ctx.enqueueWork(() -> handler.accept(packet, CarryOnCommonClient.getPlayer()));
        registrar.playToClient(type, codec, clientHandler);
    }

    @Override
    public void sendPacketToServer(ResourceLocation id, PacketBase packet) {
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendPacketToPlayer(ResourceLocation id, PacketBase packet, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

