/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleFlame
extends TextureSheetParticle {
    public ParticleFlame(ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
        super(level, x, y, z, dx, dy, dz);
        this.gravity = 0.0f;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void move(double dx, double dy, double dz) {
        this.setBoundingBox(this.getBoundingBox().move(dx, dy, dz));
        this.setLocationFromBoundingbox();
    }

    public float getQuadSize(float partialTick) {
        float t = ((float)this.age + partialTick) / (float)this.lifetime;
        return this.quadSize * (1.0f - t * t * 0.5f);
    }

    public int getLightColor(float partialTick) {
        float t = ((float)this.age + partialTick) / (float)this.lifetime;
        t = Mth.clamp((float)t, (float)0.0f, (float)1.0f);
        int light = super.getLightColor(partialTick);
        int blockLight = light & 0xFF;
        int skyLight = light >> 16 & 0xFF;
        if ((blockLight += (int)(t * 240.0f)) > 240) {
            blockLight = 240;
        }
        return blockLight | skyLight << 16;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ProviderSmall
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public ProviderSmall(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            ParticleFlame flame = new ParticleFlame(level, x, y, z, dx, dy, dz);
            flame.pickSprite(this.sprites);
            flame.scale(0.5f);
            return flame;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ProviderNormal
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public ProviderNormal(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            ParticleFlame flame = new ParticleFlame(level, x, y, z, dx, dy, dz);
            flame.pickSprite(this.sprites);
            return flame;
        }
    }
}

