/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.gear.ModuleData;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.scroll.GuiInstallableScrollList;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleContainer;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GuiModuleScrollList
extends GuiInstallableScrollList<ModuleData<?>> {
    private static final ResourceLocation MODULE_SELECTION = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "module_selection.png");
    private final Consumer<Module<?>> callback;
    private final List<ModuleData<?>> currentList = new ArrayList();
    private final Supplier<ItemStack> itemSupplier;
    private ItemStack currentItem;
    @Nullable
    private ModuleContainer currentContainer;
    @Nullable
    private Component lastInfo = null;
    @Nullable
    private Tooltip lastTooltip;

    public GuiModuleScrollList(IGuiWrapper gui, int x, int y, int height, Supplier<ItemStack> itemSupplier, Consumer<Module<?>> callback) {
        super(gui, x, y, height, GuiElementHolder.HOLDER, 32, MODULE_SELECTION, 112, 36);
        this.itemSupplier = itemSupplier;
        this.callback = callback;
        this.updateItemAndList(itemSupplier.get());
    }

    public void updateItemAndList(ItemStack stack) {
        this.currentItem = stack;
        this.currentContainer = ModuleHelper.get().getModuleContainer(stack);
        this.currentList.clear();
        if (this.currentContainer != null) {
            this.currentList.addAll(this.currentContainer.moduleTypes());
        }
    }

    private void recheckItem() {
        ItemStack stack = this.itemSupplier.get();
        if (!ItemStack.matches((ItemStack)this.currentItem, (ItemStack)stack)) {
            this.updateItemAndList(stack);
            ModuleData prevSelect = (ModuleData)this.getSelection();
            if (prevSelect != null) {
                if (this.currentList.contains(prevSelect)) {
                    this.onSelectedChange();
                } else {
                    this.clearSelection();
                }
            }
        }
    }

    @Override
    protected void setSelected(@Nullable ModuleData<?> newData) {
        if (this.selectedType != newData) {
            this.selectedType = newData;
            this.onSelectedChange();
        }
    }

    private void onSelectedChange() {
        this.callback.accept(this.getModule((ModuleData)this.selectedType));
    }

    @Nullable
    private Module<?> getModule(@Nullable ModuleData<?> data) {
        if (data == null || this.currentContainer == null) {
            return null;
        }
        return this.currentContainer.getRaw(data);
    }

    @Override
    protected List<ModuleData<?>> getCurrentInstalled() {
        return this.currentList;
    }

    @Override
    protected void drawName(GuiGraphics guiGraphics, ModuleData<?> module, int y) {
        Module<?> instance = this.getModule(module);
        if (instance != null) {
            boolean enabled = instance.isEnabled();
            int color = module.isExclusive(-1) ? (enabled ? 6511572 : 3025513) : (enabled ? this.titleTextColor() : 6167837);
            this.drawNameText(guiGraphics, y, (Component)TextComponentUtil.build(module), color, 0.7f);
        }
    }

    @Override
    protected ItemStack getRenderStack(ModuleData<?> moduleData) {
        return new ItemStack(moduleData.getItemHolder());
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.recheckItem();
        super.renderForeground(guiGraphics, mouseX, mouseY);
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        if (this.currentContainer != null && mouseX >= this.getX() + 1 && mouseX < this.getX() + this.barXShift - 1) {
            int index;
            int currentSelection = this.getCurrentSelection();
            int focused = this.getFocusedElements();
            for (int i = 0; i < focused && (index = currentSelection + i) <= this.currentList.size() - 1; ++i) {
                ModuleData<?> module = this.currentList.get(index);
                int installed = this.currentContainer.installedCount(module);
                int multipliedElement = this.elementHeight * i;
                if (installed <= 0 || mouseY < this.getY() + 1 + multipliedElement || mouseY >= this.getY() + 1 + multipliedElement + this.elementHeight) continue;
                MutableComponent info = MekanismLang.MODULE_INSTALLED.translate(MekanismLang.GENERIC_FRACTION.translateColored(EnumColor.GRAY, installed, module.getMaxStackSize()));
                if (!info.equals((Object)this.lastInfo)) {
                    this.lastInfo = info;
                    this.lastTooltip = TooltipUtils.create((Component)info);
                }
                this.cachedTooltipRect = new ScreenRectangle(this.getX() + 1, this.getY() + 1 + multipliedElement, this.barXShift - 2, this.elementHeight);
                this.setTooltip(this.lastTooltip);
                return;
            }
        }
        this.cachedTooltipRect = null;
        this.lastInfo = null;
        this.lastTooltip = null;
        this.setTooltip(null);
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        GuiModuleScrollList old = (GuiModuleScrollList)element;
        if (ItemStack.matches((ItemStack)this.currentItem, (ItemStack)old.currentItem)) {
            this.selectedType = old.selectedType;
        } else if (old.selectedType != null) {
            if (this.currentList.contains(old.selectedType)) {
                this.setSelected((ModuleData)old.selectedType);
            } else {
                this.onSelectedChange();
            }
        }
    }
}

