/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei;

import java.util.List;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tier.FactoryTier;
import mekanism.common.util.EnumUtils;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class CatalystRegistryHelper {
    private CatalystRegistryHelper() {
    }

    public static void register(IRecipeCatalystRegistration registry, IRecipeViewerRecipeType<?> ... categories) {
        for (IRecipeViewerRecipeType<?> category : categories) {
            CatalystRegistryHelper.register(registry, MekanismJEI.genericRecipeType(category), category.workstations());
        }
    }

    public static void register(IRecipeCatalystRegistration registry, RecipeType<?> recipeType, List<ItemLike> workstations) {
        for (ItemLike workstation : workstations) {
            BlockItem blockItem;
            AttributeFactoryType factoryType;
            Item item = workstation.asItem();
            registry.addRecipeCatalyst((ItemLike)item, new RecipeType[]{recipeType});
            if (!(item instanceof BlockItem) || (factoryType = Attribute.get((blockItem = (BlockItem)item).getBlock(), AttributeFactoryType.class)) == null) continue;
            for (FactoryTier tier : EnumUtils.FACTORY_TIERS) {
                registry.addRecipeCatalyst(MekanismBlocks.getFactory(tier, factoryType.getFactoryType()), new RecipeType[]{recipeType});
            }
        }
    }
}

