/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.energy;

import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.math.MathUtils;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.energy.ComponentBackedEnergyContainer;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ComponentBackedResistiveEnergyContainer
extends ComponentBackedEnergyContainer {
    public static ComponentBackedResistiveEnergyContainer create(ContainerType<?, ?, ?> ignored, ItemStack attachedTo, int containerIndex) {
        return new ComponentBackedResistiveEnergyContainer(attachedTo, containerIndex);
    }

    private ComponentBackedResistiveEnergyContainer(ItemStack attachedTo, int containerIndex) {
        super(attachedTo, containerIndex, BasicEnergyContainer.manualOnly, ConstantPredicates.alwaysTrue(), ConstantPredicates.ZERO_LONG, ConstantPredicates.ZERO_LONG);
    }

    @Override
    public long getMaxEnergy() {
        return MathUtils.multiplyClamped(this.getEnergyPerTick(), 400L);
    }

    private long getRate() {
        return MekanismUtils.calculateUsage(this.getMaxEnergy());
    }

    @Override
    protected long getInsertRate(@Nullable AutomationType automationType) {
        return automationType == null || automationType == AutomationType.MANUAL ? Long.MAX_VALUE : this.getRate();
    }

    @Override
    protected long getExtractRate(@Nullable AutomationType automationType) {
        return automationType == null || automationType == AutomationType.MANUAL ? Long.MAX_VALUE : this.getRate();
    }

    private long getEnergyPerTick() {
        return (Long)this.attachedTo.getOrDefault(MekanismDataComponents.ENERGY_USAGE, (Object)100L);
    }

    private void updateEnergyUsage(long energyUsage) {
        this.attachedTo.set(MekanismDataComponents.ENERGY_USAGE, (Object)energyUsage);
        this.setEnergy(this.getEnergy());
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = super.serializeNBT(provider);
        nbt.putLong("energy_usage", this.getEnergyPerTick());
        return nbt;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        NBTUtils.setLegacyEnergyIfPresent(nbt, "energy_usage", this::updateEnergyUsage);
        super.deserializeNBT(provider, nbt);
    }
}

