/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IMekanismHeatHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.StackUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiblockCache<T extends MultiblockData>
implements IMekanismInventory,
IMekanismFluidHandler,
IMekanismStrictEnergyHandler,
IMekanismHeatHandler,
IMekanismChemicalHandler {
    private final List<IInventorySlot> inventorySlots = new ArrayList<IInventorySlot>();
    private final List<IExtendedFluidTank> fluidTanks = new ArrayList<IExtendedFluidTank>();
    private final List<IChemicalTank> chemicalTanks = new ArrayList<IChemicalTank>();
    private final List<IEnergyContainer> energyContainers = new ArrayList<IEnergyContainer>();
    private final List<IHeatCapacitor> heatCapacitors = new ArrayList<IHeatCapacitor>();

    public void apply(HolderLookup.Provider provider, T data) {
        for (CacheSubstance<?, INBTSerializable<CompoundTag>> type : CacheSubstance.VALUES) {
            List<INBTSerializable<CompoundTag>> containers = type.getContainerList(data);
            if (containers == null) continue;
            List<INBTSerializable<CompoundTag>> cacheContainers = type.getContainerList(this);
            for (int i = 0; i < cacheContainers.size(); ++i) {
                if (i >= containers.size()) continue;
                containers.get(i).deserializeNBT(provider, (Tag)((CompoundTag)cacheContainers.get(i).serializeNBT(provider)));
            }
        }
    }

    public void sync(T data) {
        for (CacheSubstance<?, INBTSerializable<CompoundTag>> type : CacheSubstance.VALUES) {
            List<INBTSerializable<CompoundTag>> containersToCopy = type.getContainerList(data);
            if (containersToCopy == null) continue;
            List<INBTSerializable<CompoundTag>> cacheContainers = type.getContainerList(this);
            if (cacheContainers.isEmpty()) {
                type.prefab(this, containersToCopy.size());
            }
            for (int i = 0; i < containersToCopy.size(); ++i) {
                type.sync(cacheContainers.get(i), containersToCopy.get(i));
            }
        }
    }

    public void load(HolderLookup.Provider provider, CompoundTag nbtTags) {
        for (CacheSubstance<?, INBTSerializable<CompoundTag>> type : CacheSubstance.VALUES) {
            type.readFrom(provider, nbtTags, this);
        }
    }

    public void save(HolderLookup.Provider provider, CompoundTag nbtTags) {
        for (CacheSubstance<?, INBTSerializable<CompoundTag>> type : CacheSubstance.VALUES) {
            type.saveTo(provider, nbtTags, this);
        }
    }

    public void merge(MultiblockCache<T> mergeCache, RejectContents rejectContents) {
        for (CacheSubstance<T, INBTSerializable<CompoundTag>> cacheSubstance : CacheSubstance.VALUES) {
            cacheSubstance.preHandleMerge(this, mergeCache);
        }
        StackUtils.merge(this.getInventorySlots(null), mergeCache.getInventorySlots(null), rejectContents.rejectedItems);
        StorageUtils.mergeFluidTanks(this.getFluidTanks(null), mergeCache.getFluidTanks(null), rejectContents.rejectedFluids);
        StorageUtils.mergeTanks(this.getChemicalTanks(null), mergeCache.getChemicalTanks(null), rejectContents.rejectedChemicals);
        StorageUtils.mergeEnergyContainers(this.getEnergyContainers(null), mergeCache.getEnergyContainers(null));
        StorageUtils.mergeHeatCapacitors(this.getHeatCapacitors(null), mergeCache.getHeatCapacitors(null));
    }

    @Override
    public void onContentsChanged() {
    }

    @Override
    @NotNull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.inventorySlots;
    }

    @Override
    @NotNull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }

    @Override
    @NotNull
    public List<IChemicalTank> getChemicalTanks(@Nullable Direction side) {
        return this.chemicalTanks;
    }

    @Override
    @NotNull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }

    @Override
    @NotNull
    public List<IHeatCapacitor> getHeatCapacitors(Direction side) {
        return this.heatCapacitors;
    }

    public static abstract class CacheSubstance<HANDLER, ELEMENT extends INBTSerializable<CompoundTag>> {
        public static final CacheSubstance<IMekanismInventory, IInventorySlot> ITEMS = new CacheSubstance<IMekanismInventory, IInventorySlot>(ContainerType.ITEM){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.inventorySlots.add(BasicInventorySlot.at(cache, 0, 0));
            }

            @Override
            protected List<IInventorySlot> containerList(IMekanismInventory inventory) {
                return inventory.getInventorySlots(null);
            }

            @Override
            public void sync(IInventorySlot cache, IInventorySlot data) {
                cache.setStack(data.getStack());
            }
        };
        public static final CacheSubstance<IMekanismFluidHandler, IExtendedFluidTank> FLUID = new CacheSubstance<IMekanismFluidHandler, IExtendedFluidTank>(ContainerType.FLUID){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.fluidTanks.add(BasicFluidTank.create(Integer.MAX_VALUE, cache));
            }

            @Override
            protected List<IExtendedFluidTank> containerList(IMekanismFluidHandler fluidHandler) {
                return fluidHandler.getFluidTanks(null);
            }

            @Override
            public void sync(IExtendedFluidTank cache, IExtendedFluidTank data) {
                cache.setStack(data.getFluid());
            }
        };
        public static final CacheSubstance<IMekanismChemicalHandler, IChemicalTank> CHEMICAL = new CacheSubstance<IMekanismChemicalHandler, IChemicalTank>(ContainerType.CHEMICAL){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.chemicalTanks.add(BasicChemicalTank.createAllValid(Long.MAX_VALUE, cache));
            }

            @Override
            protected List<IChemicalTank> containerList(IMekanismChemicalHandler tracker) {
                return tracker.getChemicalTanks(null);
            }

            @Override
            public void sync(IChemicalTank cache, IChemicalTank data) {
                cache.setStack(data.getStack());
            }

            @Override
            public void readFrom(HolderLookup.Provider provider, CompoundTag tag, MultiblockCache<?> cache) {
                int stored = Math.max(tag.getInt("gas_tanks_stored"), Math.max(tag.getInt("infusion_tanks_stored"), Math.max(tag.getInt("pigment_tanks_stored"), tag.getInt("slurry_tanks_stored"))));
                if (stored > 0) {
                    tag.putInt(this.getStoredTagKey(), Math.max(stored, tag.getInt(this.getStoredTagKey())));
                }
                super.readFrom(provider, tag, cache);
            }
        };
        public static final CacheSubstance<IMekanismStrictEnergyHandler, IEnergyContainer> ENERGY = new CacheSubstance<IMekanismStrictEnergyHandler, IEnergyContainer>(ContainerType.ENERGY){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.energyContainers.add(BasicEnergyContainer.create(Long.MAX_VALUE, cache));
            }

            @Override
            protected List<IEnergyContainer> containerList(IMekanismStrictEnergyHandler handler) {
                return handler.getEnergyContainers(null);
            }

            @Override
            public void sync(IEnergyContainer cache, IEnergyContainer data) {
                cache.setEnergy(data.getEnergy());
            }
        };
        public static final CacheSubstance<IMekanismHeatHandler, IHeatCapacitor> HEAT = new CacheSubstance<IMekanismHeatHandler, IHeatCapacitor>(ContainerType.HEAT){

            @Override
            protected void defaultPrefab(MultiblockCache<?> cache) {
                cache.heatCapacitors.add(BasicHeatCapacitor.create(1.0, null, cache));
            }

            @Override
            protected List<IHeatCapacitor> containerList(IMekanismHeatHandler handler) {
                return handler.getHeatCapacitors(null);
            }

            @Override
            public void sync(IHeatCapacitor cache, IHeatCapacitor data) {
                cache.setHeat(data.getHeat());
                if (cache instanceof BasicHeatCapacitor) {
                    BasicHeatCapacitor heatCapacitor = (BasicHeatCapacitor)cache;
                    heatCapacitor.setHeatCapacity(data.getHeatCapacity(), false);
                }
            }
        };
        public static final CacheSubstance<?, INBTSerializable<CompoundTag>>[] VALUES = new CacheSubstance[]{CHEMICAL, ITEMS, FLUID, ENERGY, HEAT};
        private final ContainerType<ELEMENT, ?, ?> containerType;

        public CacheSubstance(ContainerType<ELEMENT, ?, ?> containerType) {
            this.containerType = containerType;
        }

        protected abstract void defaultPrefab(MultiblockCache<?> var1);

        protected abstract List<ELEMENT> containerList(HANDLER var1);

        private void prefab(MultiblockCache<?> cache, int count) {
            for (int i = 0; i < count; ++i) {
                this.defaultPrefab(cache);
            }
        }

        public List<ELEMENT> getContainerList(Object holder) {
            return this.containerList(holder);
        }

        public abstract void sync(ELEMENT var1, ELEMENT var2);

        public void preHandleMerge(MultiblockCache<?> cache, MultiblockCache<?> merge) {
            int diff = this.getContainerList(merge).size() - this.getContainerList(cache).size();
            if (diff > 0) {
                this.prefab(cache, diff);
            }
        }

        protected String getStoredTagKey() {
            return this.containerType.getTag() + "_stored";
        }

        public void readFrom(HolderLookup.Provider provider, CompoundTag tag, MultiblockCache<?> cache) {
            int stored = tag.getInt(this.getStoredTagKey());
            if (stored > 0) {
                this.prefab(cache, stored);
                this.containerType.readFrom(provider, tag, this.getContainerList(cache));
            }
        }

        public void saveTo(HolderLookup.Provider provider, CompoundTag tag, MultiblockCache<?> holder) {
            List<ELEMENT> containers = this.getContainerList(holder);
            if (!containers.isEmpty()) {
                tag.putInt(this.getStoredTagKey(), containers.size());
                this.containerType.saveTo(provider, tag, this.getContainerList(holder));
            }
        }
    }

    public static class RejectContents {
        public final List<ItemStack> rejectedItems = new ArrayList<ItemStack>();
        public final List<FluidStack> rejectedFluids = new ArrayList<FluidStack>();
        public final List<ChemicalStack> rejectedChemicals = new ArrayList<ChemicalStack>();
    }
}

