/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackConstantChemicalToObjectCachedRecipe;
import mekanism.api.recipes.cache.TwoInputCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.api.recipes.vanilla_input.SingleItemChemicalRecipeInput;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityChemicalDissolutionChamber
extends TileEntityProgressMachine<ChemicalDissolutionRecipe>
implements IRecipeLookupHandler.ConstantUsageRecipeLookupHandler,
IDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<ChemicalDissolutionRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    public static final long MAX_CHEMICAL = 10000L;
    public static final int BASE_TICKS_REQUIRED = 100;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getGasInput", "getGasInputCapacity", "getGasInputNeeded", "getGasInputFilledPercentage"}, docPlaceholder="gas input tank")
    public IChemicalTank injectTank;
    public IChemicalTank outputTank;
    private final ItemStackConstantChemicalToObjectCachedRecipe.ChemicalUsageMultiplier injectUsageMultiplier;
    private double injectUsage = 1.0;
    private long usedSoFar;
    private final IOutputHandler<ChemicalStack> outputHandler;
    private final IInputHandler<@NotNull ItemStack> itemInputHandler;
    private final ILongInputHandler<@NotNull ChemicalStack> gasInputHandler;
    private MachineEnergyContainer<TileEntityChemicalDissolutionChamber> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputGasItem"}, docPlaceholder="gas input item slot")
    ChemicalInventorySlot gasInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    InputInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    ChemicalInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityChemicalDissolutionChamber(BlockPos pos, BlockState state) {
        super((Holder<Block>)MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER, pos, state, TRACKED_ERROR_TYPES, 100);
        this.configComponent.setupItemIOExtraConfig(this.inputSlot, this.outputSlot, this.gasInputSlot, this.energySlot);
        this.configComponent.setupIOConfig(TransmissionType.CHEMICAL, (Object)this.injectTank, this.outputTank, RelativeSide.RIGHT);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM, TransmissionType.CHEMICAL).setCanTankEject(tank -> tank != this.injectTank);
        this.itemInputHandler = InputHelper.getInputHandler(this.inputSlot, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.gasInputHandler = InputHelper.getConstantInputHandler(this.injectTank);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputTank, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
        this.injectUsageMultiplier = (usedSoFar, operatingTicks) -> StatUtils.inversePoisson(this.injectUsage);
    }

    @Override
    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideWithConfig(this);
        this.injectTank = BasicChemicalTank.inputModern(10000L, gas -> this.containsRecipeBA(this.inputSlot.getStack(), gas), this::containsRecipeB, recipeCacheListener);
        builder.addTank(this.injectTank);
        this.outputTank = BasicChemicalTank.output(10000L, recipeCacheUnpauseListener);
        builder.addTank(this.outputTank);
        return builder.build();
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this);
        this.energyContainer = MachineEnergyContainer.input(this, recipeCacheUnpauseListener);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this);
        this.gasInputSlot = ChemicalInventorySlot.fillOrConvert(this.injectTank, () -> ((TileEntityChemicalDissolutionChamber)this).getLevel(), listener, 8, 65);
        builder.addSlot(this.gasInputSlot);
        this.inputSlot = InputInventorySlot.at(item -> this.containsRecipeAB(item, this.injectTank.getStack()), this::containsRecipeA, recipeCacheListener, 28, 36);
        builder.addSlot(this.inputSlot).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT)));
        this.outputSlot = ChemicalInventorySlot.drain(this.outputTank, listener, 152, 55);
        builder.addSlot(this.outputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityChemicalDissolutionChamber)this).getLevel(), listener, 152, 14);
        builder.addSlot(this.energySlot);
        this.gasInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.gasInputSlot.fillTankOrConvert();
        this.outputSlot.drainTank();
        this.recipeCacheLookupMonitor.updateAndProcess();
        return sendUpdatePacket;
    }

    @Override
    @NotNull
    public IMekanismRecipeTypeProvider<SingleItemChemicalRecipeInput, ChemicalDissolutionRecipe, InputRecipeCache.ItemChemical<ChemicalDissolutionRecipe>> getRecipeType() {
        return MekanismRecipeType.DISSOLUTION;
    }

    @Override
    public IRecipeViewerRecipeType<ChemicalDissolutionRecipe> recipeViewerType() {
        return RecipeViewerRecipeType.DISSOLUTION;
    }

    @Override
    @Nullable
    public ChemicalDissolutionRecipe getRecipe(int cacheIndex) {
        return (ChemicalDissolutionRecipe)this.findFirstRecipe(this.itemInputHandler, this.gasInputHandler);
    }

    @Override
    @NotNull
    public CachedRecipe<ChemicalDissolutionRecipe> createNewCachedRecipe(@NotNull ChemicalDissolutionRecipe recipe, int cacheIndex) {
        CachedRecipe cachedRecipe = recipe.perTickUsage() ? ItemStackConstantChemicalToObjectCachedRecipe.dissolution(recipe, this.recheckAllRecipeErrors, this.itemInputHandler, this.gasInputHandler, this.injectUsageMultiplier, used -> {
            this.usedSoFar = used;
        }, this.outputHandler) : TwoInputCachedRecipe.itemChemicalToChemical(recipe, this.recheckAllRecipeErrors, this.itemInputHandler, this.gasInputHandler, this.outputHandler);
        return cachedRecipe.setErrorsChanged(x$0 -> this.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)x$0)).setCanHolderFunction(this::canFunction).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(this::markForSave).setOperatingTicksChanged(x$0 -> this.setOperatingTicks(x$0)).setBaselineMaxOperations(this::getOperationsPerTick);
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.CHEMICAL || upgrade == Upgrade.SPEED) {
            this.injectUsage = MekanismUtils.getGasPerTickMeanMultiplier(this);
        }
    }

    public MachineEnergyContainer<TileEntityChemicalDissolutionChamber> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public long getSavedUsedSoFar(int cacheIndex) {
        return this.usedSoFar;
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.usedSoFar = nbt.getLong("used_so_far");
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putLong("used_so_far", this.usedSoFar);
    }

    @ComputerMethod(methodDescription="Get the energy used in the last tick by the machine")
    long getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : 0L;
    }

    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getOutput", "getOutputCapacity", "getOutputNeeded", "getOutputFilledPercentage"}, docPlaceholder="output tank")
    IChemicalTank getOutputTank() {
        return this.outputTank;
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.0")
    public List<IChemicalTank> getLegacyGasTanks() {
        return Collections.singletonList(this.injectTank);
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.0")
    public List<IChemicalTank> getLegacySlurryTanks() {
        return Collections.singletonList(this.outputTank);
    }
}

