/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.basic.BasicItemStackToFluidOptionalItemRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.OneInputCachedRecipe;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.NutritionalLiquifierIRecipe;
import mekanism.common.recipe.lookup.cache.IInputRecipeCache;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityNutritionalLiquifier
extends TileEntityProgressMachine<BasicItemStackToFluidOptionalItemRecipe> {
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    public static final int MAX_FLUID = 10000;
    public static final int BASE_TICKS_REQUIRED = 100;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getOutput", "getOutputCapacity", "getOutputNeeded", "getOutputFilledPercentage"}, docPlaceholder="output tank")
    public IExtendedFluidTank fluidTank;
    private final IOutputHandler< @NotNull ItemStackToFluidOptionalItemRecipe.FluidOptionalItemOutput> outputHandler;
    private final IInputHandler<@NotNull ItemStack> inputHandler;
    private MachineEnergyContainer<TileEntityNutritionalLiquifier> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInput"}, docPlaceholder="input slot")
    InputInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    OutputInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getContainerFillItem"}, docPlaceholder="fillable container slot")
    FluidInventorySlot containerFillSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getContainerOutputItem"}, docPlaceholder="filled container output slot")
    OutputInventorySlot containerOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;
    @Nullable
    private HashedItem lastPasteItem;
    private float lastPasteScale;

    public TileEntityNutritionalLiquifier(BlockPos pos, BlockState state) {
        super((Holder<Block>)MekanismBlocks.NUTRITIONAL_LIQUIFIER, pos, state, TRACKED_ERROR_TYPES, 100);
        this.configComponent.setupItemIOConfig(List.of(this.inputSlot, this.containerFillSlot), List.of(this.outputSlot, this.containerOutputSlot), this.energySlot, false);
        this.configComponent.setupOutputConfig(TransmissionType.FLUID, this.fluidTank, RelativeSide.RIGHT);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.FLUID);
        this.inputHandler = InputHelper.getInputHandler(this.inputSlot, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.outputHandler = OutputHelper.getOutputHandler(this.fluidTank, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, (IInventorySlot)this.outputSlot, NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR);
    }

    @Override
    @NotNull
    public IFluidTankHolder getInitialFluidTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig(this);
        this.fluidTank = BasicFluidTank.output(10000, recipeCacheUnpauseListener);
        builder.addTank(this.fluidTank);
        return builder.build();
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this);
        this.energyContainer = MachineEnergyContainer.input(this, recipeCacheUnpauseListener);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this);
        this.inputSlot = InputInventorySlot.at(TileEntityNutritionalLiquifier::isValidInput, recipeCacheListener, 26, 36);
        builder.addSlot(this.inputSlot).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT)));
        this.outputSlot = OutputInventorySlot.at(listener, 110, 36);
        builder.addSlot(this.outputSlot).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR)));
        this.containerFillSlot = FluidInventorySlot.drain(this.fluidTank, listener, 155, 25);
        builder.addSlot(this.containerFillSlot);
        this.containerOutputSlot = OutputInventorySlot.at(listener, 155, 56);
        builder.addSlot(this.containerOutputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityNutritionalLiquifier)this).getLevel(), listener, 155, 5);
        builder.addSlot(this.energySlot);
        this.containerFillSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    public static boolean isValidInput(ItemStack stack) {
        FoodProperties food = stack.getFoodProperties(null);
        return food != null && food.nutrition() > 0;
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.containerFillSlot.drainTank(this.containerOutputSlot);
        this.recipeCacheLookupMonitor.updateAndProcess();
        float pasteScale = MekanismUtils.getScale(this.lastPasteScale, this.fluidTank);
        if (MekanismUtils.scaleChanged(pasteScale, this.lastPasteScale)) {
            this.lastPasteScale = pasteScale;
            sendUpdatePacket = true;
        }
        if (this.inputSlot.isEmpty()) {
            if (this.lastPasteItem != null) {
                this.lastPasteItem = null;
                sendUpdatePacket = true;
            }
        } else {
            HashedItem item = HashedItem.raw(this.inputSlot.getStack());
            if (!item.equals(this.lastPasteItem)) {
                this.lastPasteItem = item.recreate();
                sendUpdatePacket = true;
            }
        }
        return sendUpdatePacket;
    }

    @Override
    @NotNull
    public MekanismRecipeType<SingleRecipeInput, BasicItemStackToFluidOptionalItemRecipe, IInputRecipeCache> getRecipeType() {
        return null;
    }

    @Override
    public IRecipeViewerRecipeType<BasicItemStackToFluidOptionalItemRecipe> recipeViewerType() {
        return RecipeViewerRecipeType.NUTRITIONAL_LIQUIFICATION;
    }

    @Override
    @Nullable
    public BasicItemStackToFluidOptionalItemRecipe getRecipe(int cacheIndex) {
        return TileEntityNutritionalLiquifier.getRecipe(this.inputHandler.getInput());
    }

    @Nullable
    public static BasicItemStackToFluidOptionalItemRecipe getRecipe(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        FoodProperties food = stack.getFoodProperties(null);
        if (food == null || food.nutrition() <= 0) {
            return null;
        }
        return new NutritionalLiquifierIRecipe(IngredientCreatorAccess.item().from(stack, 1), MekanismFluids.NUTRITIONAL_PASTE.asStack(food.nutrition() * 50), food.usingConvertsTo().orElse(ItemStack.EMPTY));
    }

    @Override
    @NotNull
    public CachedRecipe<BasicItemStackToFluidOptionalItemRecipe> createNewCachedRecipe(@NotNull BasicItemStackToFluidOptionalItemRecipe recipe, int cacheIndex) {
        return OneInputCachedRecipe.itemToFluidOptionalItem(recipe, this.recheckAllRecipeErrors, this.inputHandler, this.outputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)x$0)).setCanHolderFunction(this::canFunction).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(this::markForSave).setOperatingTicksChanged(x$0 -> this.setOperatingTicks(x$0)).setBaselineMaxOperations(this::getOperationsPerTick);
    }

    public MachineEnergyContainer<TileEntityNutritionalLiquifier> getEnergyContainer() {
        return this.energyContainer;
    }

    public ItemStack getRenderStack() {
        if (this.lastPasteItem == null) {
            return ItemStack.EMPTY;
        }
        return this.lastPasteItem.getInternalStack();
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.put("fluid", (Tag)this.fluidTank.serializeNBT(provider));
        if (this.lastPasteItem != null) {
            updateTag.put("item", this.lastPasteItem.internalToNBT(provider));
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        NBTUtils.setCompoundIfPresent(tag, "fluid", nbt -> this.fluidTank.deserializeNBT(provider, (CompoundTag)nbt));
        NBTUtils.setItemStackOrEmpty(provider, tag, "item", stack -> {
            this.lastPasteItem = stack.isEmpty() ? null : HashedItem.raw(stack);
        });
    }

    @ComputerMethod(methodDescription="Get the energy used in the last tick by the machine")
    public long getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : 0L;
    }
}

