/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events.overrides;

import net.mehvahdjukaar.supplementaries.common.entities.ThrowableBrickEntity;
import net.mehvahdjukaar.supplementaries.common.events.overrides.ItemUseBehavior;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

class ThrowableBricksBehavior
implements ItemUseBehavior {
    ThrowableBricksBehavior() {
    }

    @Override
    public boolean isEnabled() {
        return CommonConfigs.Tweaks.THROWABLE_BRICKS_ENABLED.get();
    }

    @Override
    @Nullable
    public MutableComponent getTooltip() {
        return Component.translatable((String)"message.supplementaries.throwable_brick");
    }

    @Override
    public boolean appliesToItem(Item item) {
        return item.builtInRegistryHolder().is(ModTags.BRICKS);
    }

    @Override
    public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
        world.playSound(null, player.getX(), player.getY(), player.getZ(), ModSounds.BRICK_THROW.get(), SoundSource.NEUTRAL, 0.5f, 0.4f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide) {
            ThrowableBrickEntity projectile = new ThrowableBrickEntity((LivingEntity)player);
            projectile.setItem(stack);
            projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, projectile.getDefaultShootVelocity(), 1.0f);
            projectile.setDeltaMovement(projectile.getDeltaMovement().scale(1.0));
            world.addFreshEntity((Entity)projectile);
        }
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }
}

