/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.common.network.ClientReceivers;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.item.ItemStack;

public record SyncEquippedQuiverPacket(int entityID, ItemStack heldQuiver) implements Message
{
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, SyncEquippedQuiverPacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("sync_equipped_quiver"), SyncEquippedQuiverPacket::new);

    public SyncEquippedQuiverPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readVarInt(), (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf));
    }

    public <A extends Entity> SyncEquippedQuiverPacket(A entity) {
        this(entity, (IQuiverEntity)entity);
    }

    public SyncEquippedQuiverPacket(Entity entity, IQuiverEntity qe) {
        this(entity.getId(), qe.supplementaries$getQuiver());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.entityID);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)this.heldQuiver);
    }

    public void handle(Message.Context context) {
        if (context.getDirection() == Message.NetworkDir.SERVER_BOUND) {
            Entity e = context.getPlayer().level().getEntity(this.entityID);
            if (e instanceof AbstractSkeleton) {
                IQuiverEntity qe;
                AbstractSkeleton q = (AbstractSkeleton)e;
                if (e instanceof IQuiverEntity && (qe = (IQuiverEntity)e).supplementaries$hasQuiver()) {
                    NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)e, (CustomPacketPayload)new SyncEquippedQuiverPacket((Entity)q, qe));
                }
            }
        } else {
            ClientReceivers.handleSyncQuiverPacket(this);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

