/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.event;

import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.particle.ParticleEmitter;
import com.hollingsworth.arsnouveau.api.particle.timelines.DelayTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;

public class DelayedSpellEvent
implements ITimedEvent {
    public int duration;
    public final SpellResolver resolver;
    public final HitResult result;
    public final Level world;
    public final boolean showParticles;
    public ParticleEmitter emitter;

    public DelayedSpellEvent(int delay, HitResult result, Level world, SpellResolver resolver) {
        this(delay, result, world, resolver, true);
    }

    public DelayedSpellEvent(int delay, HitResult result, Level world, SpellResolver resolver, boolean showParticles) {
        this.duration = delay;
        this.result = result;
        this.world = world;
        this.resolver = resolver;
        this.showParticles = showParticles;
    }

    @Override
    public void tick(boolean serverSide) {
        --this.duration;
        if (this.duration <= 0 && serverSide) {
            this.resolveSpell();
        } else if (!serverSide && this.result != null) {
            DelayTimeline delayTimeline;
            if (this.emitter == null) {
                delayTimeline = (DelayTimeline)this.resolver.spell.particleTimeline().get((IParticleTimelineType)ParticleTimelineRegistry.DELAY_TIMELINE.get());
                this.emitter = new ParticleEmitter(() -> ((HitResult)this.result).getLocation(), () -> new Vec2(0.0f, 0.0f), delayTimeline.onTickEffect);
            }
            if (this.showParticles) {
                this.emitter.tick(this.world);
                if (this.duration <= 0) {
                    delayTimeline = (DelayTimeline)this.resolver.spell.particleTimeline().get((IParticleTimelineType)ParticleTimelineRegistry.DELAY_TIMELINE.get());
                    ParticleEmitter resolveEmitter = new ParticleEmitter(() -> ((HitResult)this.result).getLocation(), () -> new Vec2(0.0f, 0.0f), delayTimeline.onResolvingEffect);
                    resolveEmitter.tick(this.world);
                }
            }
        }
    }

    public void resolveSpell() {
        EntityHitResult ehr;
        if (this.world == null) {
            return;
        }
        HitResult hitResult = this.result;
        if (hitResult instanceof EntityHitResult && (ehr = (EntityHitResult)hitResult).getEntity().isRemoved()) {
            return;
        }
        DelayTimeline delayTimeline = (DelayTimeline)this.resolver.spell.particleTimeline().get((IParticleTimelineType)ParticleTimelineRegistry.DELAY_TIMELINE.get());
        delayTimeline.resolvingSound().sound.playSound(this.world, this.result.getLocation());
        this.resolver.resume(this.world);
    }

    @Override
    public boolean isExpired() {
        return this.duration <= 0 || this.world == null;
    }
}

