/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.sound;

import com.hollingsworth.arsnouveau.api.registry.SpellSoundRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class SpellSound {
    public static MapCodec<SpellSound> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(SpellSound::getId)).apply((Applicative)instance, SpellSoundRegistry::get));
    public static StreamCodec<RegistryFriendlyByteBuf, SpellSound> STREAM = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, SpellSound::getId, SpellSoundRegistry::get);
    private Holder<SoundEvent> soundEvent;
    private Component soundName;
    private ResourceLocation id;
    private int sortNum = 10;

    public SpellSound(Holder<SoundEvent> soundEvent, Component soundName, ResourceLocation id) {
        this.soundEvent = soundEvent;
        this.soundName = soundName;
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Holder<SoundEvent> getSoundEvent() {
        return this.soundEvent;
    }

    public Component getSoundName() {
        return this.soundName;
    }

    public ResourceLocation getTexturePath() {
        return ResourceLocation.fromNamespaceAndPath((String)this.getId().getNamespace(), (String)("textures/sounds/" + this.getId().getPath() + ".png"));
    }

    public SpellSound withSortNum(int num) {
        this.sortNum = num;
        return this;
    }

    public int sortNum() {
        return this.sortNum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpellSound that = (SpellSound)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "SpellSound{soundEvent=" + String.valueOf(this.soundEvent) + ", soundName=" + String.valueOf(this.soundName) + "}";
    }
}

