/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GlyphRecipe
implements Recipe<ScribesTile> {
    public final ItemStack output;
    public final List<Ingredient> inputs;
    public final int exp;

    public GlyphRecipe(ItemStack output, List<Ingredient> inputs, int exp) {
        this.output = output;
        this.inputs = inputs;
        this.exp = exp;
    }

    public GlyphRecipe withIngredient(Ingredient i) {
        this.inputs.add(i);
        return this;
    }

    public GlyphRecipe withIngredient(Ingredient ingredient, int count) {
        for (int i = 0; i < count; ++i) {
            this.withIngredient(ingredient);
        }
        return this;
    }

    public GlyphRecipe withIngredient(TagKey<Item> tag, int count) {
        for (int i = 0; i < count; ++i) {
            this.withIngredient(Ingredient.of(tag));
        }
        return this;
    }

    public GlyphRecipe withItem(ItemLike i) {
        this.inputs.add(Ingredient.of((ItemLike[])new ItemLike[]{i}));
        return this;
    }

    public GlyphRecipe withItem(ItemLike item, int count) {
        for (int i = 0; i < count; ++i) {
            this.withItem(item);
        }
        return this;
    }

    public GlyphRecipe withStack(ItemStack i) {
        this.inputs.add(Ingredient.of((ItemStack[])new ItemStack[]{i}));
        return this;
    }

    public GlyphRecipe withStack(ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            this.withStack(stack);
        }
        return this;
    }

    public AbstractSpellPart getSpellPart() {
        return ((Glyph)this.output.getItem()).spellPart;
    }

    public boolean matches(ScribesTile pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(ScribesTile p_345149_, HolderLookup.Provider p_346030_) {
        return this.output.copy();
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public List<Ingredient> getInputs() {
        return this.inputs;
    }

    public int getExp() {
        return this.exp;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.GLYPH_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.GLYPH_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<GlyphRecipe> {
        public static final MapCodec<GlyphRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("output").forGetter(GlyphRecipe::getOutput), (App)Ingredient.CODEC.listOf().fieldOf("inputs").forGetter(GlyphRecipe::getInputs), (App)Codec.INT.fieldOf("exp").forGetter(GlyphRecipe::getExp)).apply((Applicative)instance, GlyphRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GlyphRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static void toNetwork(RegistryFriendlyByteBuf buffer, GlyphRecipe recipe) {
            buffer.writeInt(recipe.inputs.size());
            for (Ingredient i : recipe.inputs) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)i);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            buffer.writeInt(recipe.exp);
        }

        public static GlyphRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int length = buffer.readInt();
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 0; i < length; ++i) {
                stacks.add((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            }
            return new GlyphRecipe((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer), stacks, buffer.readInt());
        }

        public MapCodec<GlyphRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GlyphRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

