/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen.patchouli;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.TextPage;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public class PatchouliBuilder {
    JsonObject object = new JsonObject();
    JsonArray pages = new JsonArray();
    int textCounter;
    String name;
    public ResourceLocation category;

    public PatchouliBuilder(ResourceLocation category, String name) {
        this.category = category;
        this.withName((String)(name.contains(".") ? name : "ars_nouveau.page." + name));
        this.name = name;
        this.withCategory(category);
    }

    public PatchouliBuilder(ResourceLocation category, ItemLike itemLike) {
        this.category = category;
        this.withName(itemLike.asItem().getDescriptionId());
        this.name = RegistryHelper.getRegistryName(itemLike.asItem()).getPath();
        this.withIcon(itemLike);
        this.withCategory(category);
    }

    public PatchouliBuilder withName(String path) {
        this.object.addProperty("name", path);
        this.name = path;
        return this;
    }

    public PatchouliBuilder withSortNum(int num) {
        this.object.addProperty("sortnum", (Number)num);
        return this;
    }

    public PatchouliBuilder withPage(IPatchouliPage page) {
        this.pages.add((JsonElement)page.build());
        return this;
    }

    public PatchouliBuilder withIcon(String path) {
        this.object.addProperty("icon", path);
        return this;
    }

    public PatchouliBuilder withIcon(ItemLike item) {
        this.object.addProperty("icon", RegistryHelper.getRegistryName(item.asItem()).toString());
        return this;
    }

    public PatchouliBuilder withCategory(ResourceLocation path) {
        this.object.addProperty("category", path.toString());
        return this;
    }

    public PatchouliBuilder withTextPage(String contents) {
        this.pages.add((JsonElement)new TextPage(contents).build());
        return this;
    }

    public PatchouliBuilder withLocalizedText(String id) {
        ++this.textCounter;
        return this.withTextPage("ars_nouveau.page" + this.textCounter + "." + id);
    }

    public PatchouliBuilder withProperty(String key, String string) {
        this.object.addProperty(key, string);
        return this;
    }

    public PatchouliBuilder withProperty(String key, Number number) {
        this.object.addProperty(key, number);
        return this;
    }

    public PatchouliBuilder withProperty(String key, Boolean bool) {
        this.object.addProperty(key, bool);
        return this;
    }

    public PatchouliBuilder withLocalizedText() {
        return this.withLocalizedText(this.name);
    }

    public JsonObject build() {
        this.object.add("pages", (JsonElement)this.pages);
        return this.object;
    }
}

