/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.api.event.FamiliarSummonEvent;
import com.hollingsworth.arsnouveau.api.event.MaxManaCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellModifierEvent;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarAmethystGolem;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarWhirlisprig;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarWixie;
import com.hollingsworth.arsnouveau.common.entity.familiar.ISpellCastListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

@EventBusSubscriber(modid="ars_nouveau")
public class FamiliarEvents {
    public static List<FamiliarEntity> getFamiliars(Predicate<FamiliarEntity> predicate) {
        ArrayList<FamiliarEntity> stale = new ArrayList<FamiliarEntity>();
        ArrayList<FamiliarEntity> matching = new ArrayList<FamiliarEntity>();
        for (FamiliarEntity familiarEntity : FamiliarEntity.FAMILIAR_SET) {
            if (familiarEntity.isRemoved() || familiarEntity.terminatedFamiliar || familiarEntity.getOwner() == null) {
                stale.add(familiarEntity);
                continue;
            }
            if (!predicate.test(familiarEntity)) continue;
            matching.add(familiarEntity);
        }
        stale.forEach(FamiliarEntity.FAMILIAR_SET::remove);
        return matching;
    }

    @SubscribeEvent
    public static void castEvent(SpellCastEvent event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(f -> f instanceof ISpellCastListener)) {
            if (!(entity instanceof ISpellCastListener)) continue;
            ((ISpellCastListener)((Object)entity)).onCast(event);
        }
    }

    @SubscribeEvent
    public static void calcEvent(SpellCostCalcEvent event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(f -> f instanceof ISpellCastListener)) {
            if (!(entity instanceof ISpellCastListener)) continue;
            ((ISpellCastListener)((Object)entity)).onCostCalc(event);
        }
    }

    @SubscribeEvent
    public static void summonEvent(FamiliarSummonEvent event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(f -> true)) {
            if (entity.getOwner() == null || !entity.getOwner().equals((Object)event.owner)) continue;
            entity.onFamiliarSpawned(event);
        }
    }

    @SubscribeEvent
    public static void maxManaCalc(MaxManaCalcEvent event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(familiarEntity -> true)) {
            if (!entity.isAlive()) {
                return;
            }
            if (entity.getOwner() == null || !entity.getOwner().equals((Object)event.getEntity())) continue;
            event.setReserve((float)((double)event.getReserve() + entity.getManaReserveModifier()));
            return;
        }
    }

    @SubscribeEvent
    public static void spellResolveEvent(SpellModifierEvent event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(familiarEntity -> familiarEntity instanceof ISpellCastListener)) {
            if (!(entity instanceof ISpellCastListener)) continue;
            ((ISpellCastListener)((Object)entity)).onModifier(event);
        }
    }

    @SubscribeEvent
    public static void modifierEvent(SpellModifierEvent event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(familiarEntity -> familiarEntity instanceof ISpellCastListener)) {
            if (!(entity instanceof ISpellCastListener)) continue;
            ((ISpellCastListener)((Object)entity)).onModifier(event);
        }
    }

    @SubscribeEvent
    public static void eatEvent(LivingEntityUseItemEvent.Finish event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(familiarEntity -> familiarEntity instanceof FamiliarWhirlisprig)) {
            if (!(entity instanceof FamiliarWhirlisprig)) continue;
            ((FamiliarWhirlisprig)entity).eatEvent(event);
        }
    }

    @SubscribeEvent
    public static void potionEvent(MobEffectEvent.Added event) {
        for (FamiliarEntity entity : FamiliarEvents.getFamiliars(familiarEntity -> familiarEntity instanceof FamiliarWixie)) {
            if (!(entity instanceof FamiliarWixie)) continue;
            ((FamiliarWixie)entity).potionEvent(event);
        }
    }

    @SubscribeEvent
    public static void knockbackEvent(LivingKnockBackEvent event) {
        List<FamiliarEntity> golems = FamiliarEvents.getFamiliars(familiarEntity -> {
            FamiliarAmethystGolem golem;
            return familiarEntity instanceof FamiliarAmethystGolem && (golem = (FamiliarAmethystGolem)familiarEntity).getOwner() != null && golem.getOwner().equals((Object)event.getEntity());
        });
        if (!golems.isEmpty()) {
            event.setStrength(event.getStrength() * 0.5f);
        }
    }

    @SubscribeEvent
    public static void livingHurtEvent(LivingDamageEvent.Post event) {
        LivingEntity livingEntity;
        if (!event.getSource().is(DamageTypeTags.BYPASSES_ARMOR) && (livingEntity = event.getEntity()) instanceof Player) {
            Entity entity;
            Player player = (Player)livingEntity;
            List<FamiliarEntity> golems = FamiliarEvents.getFamiliars(familiarEntity -> {
                FamiliarAmethystGolem golem;
                return familiarEntity instanceof FamiliarAmethystGolem && (golem = (FamiliarAmethystGolem)familiarEntity).getOwner() != null && golem.getOwner().equals((Object)event.getEntity());
            });
            if (!golems.isEmpty() && (entity = event.getSource().getEntity()) instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)entity;
                if (BlockUtil.distanceFrom(player.blockPosition(), entity.blockPosition()) < 3.0) {
                    livingTarget.knockback(0.5, player.getX() - entity.getX(), player.getZ() - entity.getZ());
                }
            }
        }
    }
}

